/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.extension.manager;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import unbbayes.draw.extension.IPluginUShapeBuilder;
import unbbayes.draw.extension.impl.ClassInstantiationPluginUShapeBuilder;
import unbbayes.gui.table.extension.IProbabilityFunctionPanelBuilder;
import unbbayes.prs.builder.INodeBuilder;
import unbbayes.prs.builder.extension.impl.ClassInstantiationPluginNodeBuilder;
import unbbayes.util.ApplicationPropertyHolder;
import unbbayes.util.Debug;
import unbbayes.util.extension.dto.INodeClassDataTransferObject;
import unbbayes.util.extension.dto.impl.NodeDto;
import unbbayes.util.extension.manager.UnBBayesPluginContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorePluginNodeManager {
    private Map<Class, INodeClassDataTransferObject> nodeClassToDtoMap = new HashMap<Class, INodeClassDataTransferObject>();
    private UnBBayesPluginContextHolder unbbayesPluginContextHolder;
    private String pluginNodeExtensionPointID;
    private String mainPluginID;
    public static final String PARAMETER_CLASS = "class";
    public static final String PARAMETER_SHAPE = "shapeClass";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_DESCRIPTION = "description";
    public static final String PARAMETER_ICON = "icon";
    public static final String PARAMETER_CURSOR = "cursor";
    public static final String PARAMETER_PANEL_BUILDER = "panelBuilder";

    protected CorePluginNodeManager() {
        this.setNodeClassToDtoMap(new HashMap<Class, INodeClassDataTransferObject>());
        this.setUnbbayesPluginContextHolder(UnBBayesPluginContextHolder.newInstance());
        this.setMainPluginID(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.node.CorePluginNodeManager.mainPluginID"));
        if (this.getMainPluginID() == null) {
            System.err.println("Error reading base plugin name from application.properties. Use core.");
            this.setMainPluginID(this.getUnbbayesPluginContextHolder().getPluginCoreID());
        }
        this.setMainExtensionPointID(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.node.CorePluginNodeManager.mainExtensionPointID"));
        if (this.getMainExtensionPointID() == null) {
            System.err.println("Error reading PluginNode extension point from application.properties. Loading from deprecated property unbbayes.util.extension.node.CorePluginNodeManager.pluginNodeExtensionPointID.");
            this.setMainExtensionPointID(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.node.CorePluginNodeManager.pluginNodeExtensionPointID"));
        }
        if (this.getMainExtensionPointID() == null) {
            System.err.println("Error reading PluginNode extension point from application.properties. Using default: PluginNode.");
            this.setMainExtensionPointID("PluginNode");
        }
    }

    public static CorePluginNodeManager newInstance() {
        return SingletonHolder.INSTANCE;
    }

    protected Map<Class, INodeClassDataTransferObject> getNodeClassToDtoMap() {
        return this.nodeClassToDtoMap;
    }

    protected void setNodeClassToDtoMap(Map<Class, INodeClassDataTransferObject> nodeClassToDtoMap) {
        this.nodeClassToDtoMap = nodeClassToDtoMap;
    }

    public void registerNodeClass(Class nodeClass, INodeClassDataTransferObject dto) {
        this.getNodeClassToDtoMap().put(nodeClass, dto);
    }

    public INodeClassDataTransferObject getPluginNodeInformation(Class nodeClass) {
        INodeClassDataTransferObject ret = this.getNodeClassToDtoMap().get(nodeClass);
        if (ret == null) {
            try {
                this.reloadPlugin();
            }
            catch (Exception e) {
                Debug.println(this.getClass(), "Error reloading plugin at getPluginNodeInformation", e);
            }
            ret = this.getNodeClassToDtoMap().get(nodeClass);
        }
        return ret;
    }

    public void reloadPlugin() throws IOException {
        this.setNodeClassToDtoMap(new HashMap<Class, INodeClassDataTransferObject>());
        if (!this.getUnbbayesPluginContextHolder().isInitialized()) {
            this.getUnbbayesPluginContextHolder().publishPlugins();
        }
        PluginDescriptor pluginDeclaringExtensionPoint = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getPluginDescriptor(this.getMainPluginID());
        ExtensionPoint point = this.getUnbbayesPluginContextHolder().getPluginManager().getRegistry().getExtensionPoint(pluginDeclaringExtensionPoint.getId(), this.getMainExtensionPointID());
        Iterator it = point.getConnectedExtensions().iterator();
        while (it.hasNext()) {
            try {
                Extension ext = (Extension)it.next();
                PluginDescriptor descr = ext.getDeclaringPluginDescriptor();
                this.getUnbbayesPluginContextHolder().getPluginManager().activatePlugin(descr.getId());
                PluginClassLoader classLoader = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(descr);
                Extension.Parameter classParam = ext.getParameter(PARAMETER_CLASS);
                Extension.Parameter cursorParam = ext.getParameter(PARAMETER_CURSOR);
                Extension.Parameter descParam = ext.getParameter(PARAMETER_DESCRIPTION);
                Extension.Parameter iconParam = ext.getParameter(PARAMETER_ICON);
                Extension.Parameter nameParam = ext.getParameter(PARAMETER_NAME);
                Extension.Parameter panelParam = ext.getParameter(PARAMETER_PANEL_BUILDER);
                Extension.Parameter shapeParam = ext.getParameter(PARAMETER_SHAPE);
                Class<?> nodeClass = null;
                nodeClass = classLoader.loadClass(classParam.valueAsString());
                INodeBuilder nodeBuilder = null;
                if (INodeBuilder.class.isAssignableFrom(nodeClass)) {
                    nodeBuilder = (INodeBuilder)nodeClass.newInstance();
                } else {
                    nodeBuilder = new ClassInstantiationPluginNodeBuilder(nodeClass);
                    if (nameParam != null && nameParam.valueAsString() != null && nameParam.valueAsString().length() > 0) {
                        ((ClassInstantiationPluginNodeBuilder)nodeBuilder).setNamePrefix(nameParam.valueAsString());
                    } else {
                        ((ClassInstantiationPluginNodeBuilder)nodeBuilder).setNamePrefix(nodeClass.getName().substring(nodeClass.getName().lastIndexOf(46)));
                    }
                }
                Class<?> shapeClass = null;
                shapeClass = classLoader.loadClass(shapeParam.valueAsString());
                IPluginUShapeBuilder shapeBuilder = null;
                shapeBuilder = IPluginUShapeBuilder.class.isAssignableFrom(shapeClass) ? (IPluginUShapeBuilder)shapeClass.newInstance() : new ClassInstantiationPluginUShapeBuilder(shapeClass);
                Class<?> panelClass = null;
                panelClass = classLoader.loadClass(panelParam.valueAsString());
                IProbabilityFunctionPanelBuilder panelBuilder = null;
                panelBuilder = (IProbabilityFunctionPanelBuilder)panelClass.newInstance();
                ImageIcon cursor = null;
                if (cursorParam != null) {
                    URL url = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(cursorParam.valueAsString());
                    cursor = url != null ? new ImageIcon(url) : null;
                }
                ImageIcon icon = null;
                if (iconParam != null) {
                    URL url = this.getUnbbayesPluginContextHolder().getPluginManager().getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(iconParam.valueAsString());
                    icon = url != null ? new ImageIcon(url) : null;
                }
                NodeDto nodeDto = NodeDto.newInstance();
                nodeDto.setIcon(icon);
                nodeDto.setNodeBuilder(nodeBuilder);
                nodeDto.setShapeBuilder(shapeBuilder);
                nodeDto.setProbabilityFunctionPanelBuilder(panelBuilder);
                nodeDto.setCursorIcon(cursor);
                if (nameParam != null) {
                    nodeDto.setName(nameParam.valueAsString());
                }
                if (descParam != null) {
                    nodeDto.setDescription(descParam.valueAsString());
                }
                this.registerNodeClass(nodeDto.getNodeBuilder().getNodeClass(), nodeDto);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void loadPlugin() throws IOException {
        this.reloadPlugin();
    }

    public Collection<INodeClassDataTransferObject> getAllLoadedPluginNodes() {
        try {
            this.reloadPlugin();
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failed to reload plugin node while getting all loaded plugin nodes", e);
        }
        if (this.getNodeClassToDtoMap() == null) {
            System.err.println("Unexpected situation at " + this.getClass().getName() + ": nodeClassToDtoMap == null.");
            return Collections.EMPTY_SET;
        }
        return new HashSet<INodeClassDataTransferObject>(this.getNodeClassToDtoMap().values());
    }

    public String getMainExtensionPointID() {
        return this.pluginNodeExtensionPointID;
    }

    public void setMainExtensionPointID(String pluginNodeID) {
        this.pluginNodeExtensionPointID = pluginNodeID;
    }

    public UnBBayesPluginContextHolder getUnbbayesPluginContextHolder() {
        return this.unbbayesPluginContextHolder;
    }

    public void setUnbbayesPluginContextHolder(UnBBayesPluginContextHolder unbbayesPluginContextHolder) {
        this.unbbayesPluginContextHolder = unbbayesPluginContextHolder;
    }

    public String getMainPluginID() {
        return this.mainPluginID;
    }

    public void setMainPluginID(String mainPluginID) {
        this.mainPluginID = mainPluginID;
    }

    private static class SingletonHolder {
        private static final CorePluginNodeManager INSTANCE = new CorePluginNodeManager();

        private SingletonHolder() {
        }
    }
}

