/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.extension.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.standard.StandardPluginLocation;
import unbbayes.io.exception.UBIOException;
import unbbayes.util.ApplicationPropertyHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnBBayesPluginContextHolder {
    private String pluginsDirectoryName = null;
    private String pluginCoreID = null;
    private boolean initialized = false;
    private List<OnReloadActionListener> onReloadListeners = new ArrayList<OnReloadActionListener>();
    private PluginManager pluginManager;

    protected UnBBayesPluginContextHolder() {
        this.setPluginsDirectoryName(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.manager.UnBBayesPluginContextHolder.pluginsDirectoryName"));
        if (this.getPluginsDirectoryName() == null) {
            this.setPluginsDirectoryName("plugins");
        }
        this.setPluginCoreID(ApplicationPropertyHolder.getProperty().getProperty("unbbayes.util.extension.manager.UnBBayesPluginContextHolder.pluginCoreID"));
        if (this.getPluginCoreID() == null) {
            this.setPluginCoreID("unbbayes.util.extension.core");
        }
        this.setPluginManager(ObjectFactory.newInstance().createManager());
    }

    public static UnBBayesPluginContextHolder newInstance() {
        return SingletonHolder.INSTANCE;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public synchronized void publishPlugins() throws IOException {
        File pluginsDir = new File(this.getPluginsDirectoryName());
        File[] plugins = pluginsDir.listFiles();
        try {
            HashSet<PluginManager.PluginLocation> locations = new HashSet<PluginManager.PluginLocation>(plugins.length);
            File[] fileArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    PluginManager.PluginLocation location = StandardPluginLocation.create((File)file);
                    if (location != null) {
                        locations.add(location);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            this.getPluginManager().publishPlugins(locations.toArray(new PluginManager.PluginLocation[locations.size()]));
        }
        catch (Throwable e) {
            throw new UBIOException(e);
        }
        this.initialized = true;
    }

    public String getPluginsDirectoryName() {
        return this.pluginsDirectoryName;
    }

    public void setPluginsDirectoryName(String pluginsDirectoryName) {
        this.pluginsDirectoryName = pluginsDirectoryName;
    }

    public String getPluginCoreID() {
        return this.pluginCoreID;
    }

    public void setPluginCoreID(String newPluginCoreID) {
        this.pluginCoreID = newPluginCoreID;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void notifyReload(Object origin) {
        for (OnReloadActionListener listener : new ArrayList<OnReloadActionListener>(this.getOnReloadListeners())) {
            try {
                listener.onReload(new EventObject(origin));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void addListener(OnReloadActionListener listener) {
        this.getOnReloadListeners().add(listener);
    }

    public List<OnReloadActionListener> getOnReloadListeners() {
        return this.onReloadListeners;
    }

    public void setOnReloadListeners(List<OnReloadActionListener> onReloadListeners) {
        this.onReloadListeners = onReloadListeners;
    }

    protected void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public Collection<String> getErroneousRequisiteID(PluginDescriptor descr) {
        ArrayList<String> ret;
        block6: {
            block5: {
                ret = new ArrayList<String>();
                if (!this.getPluginManager().isBadPlugin(descr)) break block5;
                for (PluginPrerequisite requisite : descr.getPrerequisites()) {
                    try {
                        this.getPluginManager().getRegistry().getPluginDescriptor(requisite.getPluginId());
                    }
                    catch (Exception e) {
                        ret.add(requisite.getPluginId());
                    }
                }
                break block6;
            }
            if (this.getPluginManager().isPluginActivated(descr)) break block6;
            try {
                this.getPluginManager().activatePlugin(descr.getId());
            }
            catch (PluginLifecycleException e) {
                ret.addAll(this.getErroneousRequisiteID(descr));
            }
        }
        return ret;
    }

    public Map<String, Set<String>> getErroneousPluginIDDependencyMap() throws IOException {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        try {
            for (PluginDescriptor desc : this.getPluginManager().getRegistry().getPluginDescriptors()) {
                try {
                    ret.putAll(this.getErroneousPluginIDDependencyMap(desc.getId()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Map<String, Set<String>> getErroneousPluginIDDependencyMap(String extensionPointPluginID) throws IOException {
        PluginDescriptor core;
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        if (!this.isInitialized()) {
            this.publishPlugins();
        }
        try {
            core = extensionPointPluginID == null ? this.getPluginManager().getRegistry().getPluginDescriptor(this.getPluginCoreID()) : this.getPluginManager().getRegistry().getPluginDescriptor(extensionPointPluginID);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret.put(this.getPluginCoreID(), new HashSet());
            return ret;
        }
        for (ExtensionPoint point : core.getExtensionPoints()) {
            try {
                for (Extension ext : point.getConnectedExtensions()) {
                    try {
                        PluginDescriptor descriptor = ext.getDeclaringPluginDescriptor();
                        if (!this.getPluginManager().isPluginActivated(descriptor)) {
                            try {
                                this.getPluginManager().activatePlugin(descriptor.getId());
                            }
                            catch (Throwable e) {
                                ret.put(descriptor.getId(), new HashSet<String>(this.getErroneousRequisiteID(descriptor)));
                            }
                            continue;
                        }
                        if (!this.getPluginManager().isBadPlugin(descriptor)) continue;
                        ret.put(descriptor.getId(), new HashSet<String>(this.getErroneousRequisiteID(descriptor)));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static interface OnReloadActionListener
    extends EventListener {
        public void onReload(EventObject var1);
    }

    private static class SingletonHolder {
        private static final UnBBayesPluginContextHolder INSTANCE = new UnBBayesPluginContextHolder();

        private SingletonHolder() {
        }
    }
}

