/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import unbbayes.util.graphics.GraphicsUtilities;
import unbbayes.util.graphics.ShadowRenderer;

public class DropShadowDemo
extends JFrame {
    private BlurTestPanel blurTestPanel = new BlurTestPanel();
    private JSlider shadowSizeSlider;
    private JSlider shadowOpacitySlider;
    private JCheckBox fastRenderingCheck;

    public DropShadowDemo() {
        super("Drop Shadow");
        this.add(this.blurTestPanel);
        this.shadowSizeSlider = new JSlider(1, 20, 5);
        this.shadowSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DropShadowDemo.this.blurTestPanel.setShadowSize(DropShadowDemo.this.shadowSizeSlider.getValue());
            }
        });
        this.shadowOpacitySlider = new JSlider(0, 100, 50);
        this.shadowOpacitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DropShadowDemo.this.blurTestPanel.setShadowOpacity((float)DropShadowDemo.this.shadowOpacitySlider.getValue() / 100.0f);
            }
        });
        this.fastRenderingCheck = new JCheckBox("Fast rendering");
        this.fastRenderingCheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DropShadowDemo.this.blurTestPanel.setFastRendering(DropShadowDemo.this.fastRenderingCheck.isSelected());
            }
        });
        JPanel metaControls = new JPanel(new GridLayout(3, 1));
        JPanel controls = new JPanel(new FlowLayout(0));
        controls.add(new JLabel("Size: 1px"));
        controls.add(this.shadowSizeSlider);
        controls.add(new JLabel("20px"));
        metaControls.add(controls);
        controls = new JPanel(new FlowLayout(0));
        controls.add(new JLabel("Opacity: 0%"));
        controls.add(this.shadowOpacitySlider);
        controls.add(new JLabel("100%"));
        metaControls.add(controls);
        controls = new JPanel(new FlowLayout(0));
        controls.add(this.fastRenderingCheck);
        metaControls.add(controls);
        this.add((Component)metaControls, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    public static BufferedImage createDropShadow(BufferedImage image, int size) {
        BufferedImage shadow = new BufferedImage(image.getWidth() + 4 * size, image.getHeight() + 4 * size, 2);
        Graphics2D g2 = shadow.createGraphics();
        g2.drawImage((Image)image, size * 2, size * 2, null);
        g2.setComposite(AlphaComposite.SrcIn);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, shadow.getWidth(), shadow.getHeight());
        g2.dispose();
        shadow = DropShadowDemo.getGaussianBlurFilter(size, true).filter(shadow, null);
        shadow = DropShadowDemo.getGaussianBlurFilter(size, false).filter(shadow, null);
        return shadow;
    }

    public static BufferedImage addDropShadow(BufferedImage image, int shadowSize, float shadowOpacity) {
        BufferedImage result = new BufferedImage(image.getWidth() + shadowSize, image.getHeight() + shadowSize, 2);
        int x = 0;
        int y = 0;
        Graphics2D g2 = result.createGraphics();
        Composite c = g2.getComposite();
        g2.setComposite(AlphaComposite.SrcOver.derive(shadowOpacity));
        BufferedImage shadowImage = DropShadowDemo.createDropShadow(image, shadowSize);
        g2.drawImage((Image)shadowImage, x + shadowSize, y + shadowSize, null);
        g2.setComposite(c);
        g2.drawImage(image, x, y, image.getWidth(), image.getHeight(), null);
        return result;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new DropShadowDemo().setVisible(true);
            }
        });
    }

    private static class BlurTestPanel
    extends JPanel {
        private BufferedImage image = null;
        private BufferedImage imageA;
        private int shadowSize = 5;
        private boolean fastRendering = false;
        private float shadowOpacity = 0.5f;

        public BlurTestPanel() {
            try {
                this.imageA = GraphicsUtilities.loadCompatibleImage(this.getClass().getResource("/img/util/asia.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.imageA.getWidth(), this.imageA.getHeight());
        }

        protected void paintComponent(Graphics g) {
            if (this.image == null) {
                long start = System.nanoTime();
                if (!this.fastRendering) {
                    this.image = DropShadowDemo.createDropShadow(this.imageA, this.shadowSize);
                } else {
                    ShadowRenderer renderer = new ShadowRenderer(this.shadowSize / 2, 1.0f, Color.BLACK);
                    this.image = renderer.createShadow(this.imageA);
                }
                try {
                    ImageIO.write((RenderedImage)this.image, "png", new File(this.getClass().getResource("/img/util/asia-changed.png").toURI()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                long delay = System.nanoTime() - start;
                System.out.println("time = " + (float)delay / 1000.0f / 1000.0f + "ms");
            }
            int x = (this.getWidth() - this.imageA.getWidth()) / 2;
            int y = (this.getHeight() - this.imageA.getHeight()) / 2;
            Graphics2D g2 = (Graphics2D)g;
            Composite c = g2.getComposite();
            g2.setComposite(AlphaComposite.SrcOver.derive(this.shadowOpacity));
            if (!this.fastRendering) {
                g.drawImage(this.image, x + this.shadowSize - 5, y + this.shadowSize - 5, null);
            } else {
                g.drawImage(this.image, x - this.shadowSize / 2 + 5, y - this.shadowSize / 2 + 5, null);
            }
            g2.setComposite(c);
            g.drawImage(this.imageA, x, y, null);
        }

        public void setShadowSize(int radius) {
            this.shadowSize = radius;
            this.image = null;
            this.repaint();
        }

        private void setFastRendering(boolean fastRendering) {
            this.fastRendering = fastRendering;
            this.image = null;
            this.repaint();
        }

        private void setShadowOpacity(float shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            this.image = null;
            this.repaint();
        }
    }
}

