/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.util;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXBSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object contentObject;
    private final InputSource inputSource;

    public JAXBSource(JAXBContext pContext, Object pObject) throws JAXBException {
        this(pContext.createMarshaller(), pObject);
    }

    public JAXBSource(Marshaller pMarshaller, Object pObject) throws JAXBException {
        this.marshaller = pMarshaller;
        this.contentObject = pObject;
        this.inputSource = new InputSource();
        super.setInputSource(this.inputSource);
        super.setXMLReader(new JAXBSourceXMLReader());
    }

    private class JAXBSourceXMLReader
    implements XMLReader {
        private EntityResolver resolver;
        private DTDHandler dtdHandler;
        private ErrorHandler errorHandler;
        private XMLFilterImpl contentHandlerProxy = new XMLFilterImpl();

        private JAXBSourceXMLReader() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
                return true;
            }
            throw new SAXNotRecognizedException("Unknown feature: " + name);
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
                if (!value) {
                    throw new SAXNotSupportedException("The feature " + name + " cannot be disabled.");
                }
            } else {
                throw new SAXNotRecognizedException("Unknown feature: " + name);
            }
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            throw new SAXNotRecognizedException("Unknown property: " + name);
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            throw new SAXNotRecognizedException("Unknown property: " + name);
        }

        public EntityResolver getEntityResolver() {
            return this.resolver;
        }

        public void setEntityResolver(EntityResolver resolver) {
            this.resolver = resolver;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandlerProxy.getContentHandler();
        }

        public void setContentHandler(ContentHandler handler) {
            this.contentHandlerProxy.setContentHandler(handler);
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public void parse(String systemId) throws IOException, SAXException {
            throw new IllegalStateException("The XMLReader created by a JAXBSource must not be used to parse a system ID.");
        }

        public void parse(InputSource pInput) throws IOException, SAXException {
            if (pInput != JAXBSource.this.inputSource) {
                throw new IllegalArgumentException("The XMLReader created by an instance of JAXBSource can only be used to parse the InputSource returned by the same JAXBSource.");
            }
            try {
                JAXBSource.this.marshaller.marshal(JAXBSource.this.contentObject, this.contentHandlerProxy);
            }
            catch (JAXBException e) {
                SAXParseException spe = new SAXParseException(e.getMessage(), null, null, -1, -1, e);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
        }
    }
}

