/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.beanreader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.beanreader.BeanInfo;
import org.apache.ws.jaxme.js.beanreader.BeanInfoFactory;
import org.apache.ws.jaxme.js.beanreader.BeanProperty;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSchemaWriter {
    private static final JavaQName OBJECT_TYPE = JavaQNameImpl.getInstance(class$java$lang$Object == null ? (class$java$lang$Object = BeanSchemaWriter.class$("java.lang.Object")) : class$java$lang$Object);
    private static final JavaQName BYTE_ARRAY_TYPE = JavaQNameImpl.getArray(JavaQNameImpl.BYTE);
    static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private final BeanInfoFactory factory;
    private boolean isFiringStartDocument = true;
    private boolean isFiringXmlnsAttributes = true;
    private final List prefixes = new ArrayList();
    private final Map types = new HashMap();
    private final Map remainingComplexTypes = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public BeanSchemaWriter(BeanInfoFactory pFactory) {
        this.factory = pFactory;
    }

    private String getAttrPrefix(String pURI, ContentHandler pHandler, AttributesImpl pAttrs) throws SAXException {
        if (pURI == null || pURI.length() == 0) {
            return "";
        }
        return this.getPrefix(pURI, pHandler, pAttrs);
    }

    private String getPrefix(String pURI, ContentHandler pHandler, AttributesImpl pAttrs) throws SAXException {
        String newPrefix;
        if (pURI == null) {
            pURI = "";
        }
        for (int i = this.prefixes.size() - 2; i >= 0; i -= 2) {
            if (!this.prefixes.get(i + 1).equals(pURI)) continue;
            return (String)this.prefixes.get(i);
        }
        if (XML_SCHEMA_URI.equals(pURI)) {
            newPrefix = "xs";
        } else {
            String testPrefix = "p";
            int i = 0;
            while (this.prefixes.contains(testPrefix)) {
                testPrefix = "p" + i++;
            }
            newPrefix = testPrefix;
        }
        this.prefixes.add(newPrefix);
        this.prefixes.add(pURI);
        pHandler.startPrefixMapping(newPrefix, pURI);
        if (this.isFiringXmlnsAttributes()) {
            pAttrs.addAttribute("http://www.w3.org/2000/xmlns/", newPrefix, "xmlns:" + newPrefix, "CDATA", pURI);
        }
        return newPrefix;
    }

    private int getPrefixContext() {
        return this.prefixes.size();
    }

    private void setPrefixContext(int pContext, ContentHandler pHandler) throws SAXException {
        while (this.prefixes.size() > pContext) {
            this.prefixes.remove(this.prefixes.size() - 1);
            String prefix = (String)this.prefixes.remove(this.prefixes.size() - 1);
            pHandler.endPrefixMapping(prefix);
        }
    }

    public boolean isFiringStartDocument() {
        return this.isFiringStartDocument;
    }

    public void setFiringStartDocument(boolean pIsFiringStartDocument) {
        this.isFiringStartDocument = pIsFiringStartDocument;
    }

    public boolean isFiringXmlnsAttributes() {
        return this.isFiringXmlnsAttributes;
    }

    public void setFiringXmlnsAttributes(boolean pFiringXmlnsAttributes) {
        this.isFiringXmlnsAttributes = pFiringXmlnsAttributes;
    }

    private void writeComplexType(ContentHandler pHandler, BeanInfo pBeanInfo, String pXsType) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        int ctx = this.getPrefixContext();
        this.addAttr(attrs, pHandler, "name", pXsType);
        this.startXsElement(pHandler, "complexType", attrs);
        JavaQName superClass = pBeanInfo.getSuperType();
        if (superClass == null || OBJECT_TYPE.equals(superClass)) {
            this.writeComplexTypeContents(pHandler, pBeanInfo);
        } else {
            BeanInfo beanInfo = this.factory.getBeanInfo(superClass);
            QName qName = this.getXsType(beanInfo);
            this.startXsElement(pHandler, "complexContent", new AttributesImpl());
            int ctx2 = this.getPrefixContext();
            AttributesImpl attrs2 = new AttributesImpl();
            this.addAttr(attrs2, pHandler, "base", this.getQName(qName, pHandler, attrs2));
            this.startXsElement(pHandler, "extension", attrs2);
            this.writeComplexTypeContents(pHandler, pBeanInfo);
            this.endXsElement(pHandler, "extension");
            this.setPrefixContext(ctx2, pHandler);
            this.endXsElement(pHandler, "complexContent");
        }
        this.endXsElement(pHandler, "complexType");
        this.setPrefixContext(ctx, pHandler);
    }

    private void writeComplexTypeContents(ContentHandler pHandler, BeanInfo pBeanInfo) throws SAXException {
        BeanProperty[] properties = pBeanInfo.getBeanProperties();
        ArrayList<BeanProperty> elementProperties = new ArrayList<BeanProperty>();
        ArrayList<BeanProperty> attributeProperties = new ArrayList<BeanProperty>();
        for (int i = 0; i < properties.length; ++i) {
            BeanProperty p = properties[i];
            if (this.isAttributeProperty(p)) {
                attributeProperties.add(p);
                continue;
            }
            elementProperties.add(p);
        }
        if (elementProperties.size() > 0) {
            this.startXsElement(pHandler, "sequence", new AttributesImpl());
            Iterator iter = elementProperties.iterator();
            while (iter.hasNext()) {
                this.writeParticle(pHandler, (BeanProperty)iter.next());
            }
            this.endXsElement(pHandler, "sequence");
        }
        Iterator iter = attributeProperties.iterator();
        while (iter.hasNext()) {
            this.writeAttribute(pHandler, (BeanProperty)iter.next());
        }
    }

    private void writeParticle(ContentHandler pHandler, BeanProperty pProperty) throws SAXException {
        QName xsType;
        String maxOccurs;
        JavaQName type = pProperty.getType();
        String minOccurs = "0";
        if (type.isArray()) {
            maxOccurs = "unbounded";
            if ((type = type.getInstanceClass()).isArray() && !BYTE_ARRAY_TYPE.equals(type)) {
                throw new IllegalStateException("Unable to handle multidimensional arrays.");
            }
        } else {
            maxOccurs = null;
        }
        int ctx = this.getPrefixContext();
        AttributesImpl attrs = new AttributesImpl();
        if (this.factory.isSimpleType(type)) {
            xsType = pProperty.getXsType();
        } else {
            BeanInfo beanInfo = this.factory.getBeanInfo(type);
            xsType = this.getXsType(beanInfo);
        }
        this.addAttr(attrs, pHandler, "type", this.getQName(xsType, pHandler, attrs));
        this.addAttr(attrs, pHandler, "name", pProperty.getName());
        this.addAttr(attrs, pHandler, "minOccurs", "0");
        if (maxOccurs != null) {
            this.addAttr(attrs, pHandler, "maxOccurs", maxOccurs);
        }
        this.startXsElement(pHandler, "element", attrs);
        this.endXsElement(pHandler, "element");
        this.setPrefixContext(ctx, pHandler);
    }

    private void writeAttribute(ContentHandler pHandler, BeanProperty pProperty) throws SAXException {
        int ctx = this.getPrefixContext();
        AttributesImpl attrs = new AttributesImpl();
        this.addAttr(attrs, pHandler, "name", pProperty.getName());
        if (pProperty.getType().isPrimitive()) {
            this.addAttr(attrs, pHandler, "use", "required");
        }
        this.addAttr(attrs, pHandler, "type", this.getQName(pProperty.getXsType(), pHandler, attrs));
        this.startXsElement(pHandler, "attribute", attrs);
        this.endXsElement(pHandler, "attribute");
        this.setPrefixContext(ctx, pHandler);
    }

    private boolean isAttributeProperty(BeanProperty pProperty) {
        if (this.factory.isSimpleType(pProperty.getType())) {
            return true;
        }
        if (pProperty.getType().isArray()) {
            return false;
        }
        return false;
    }

    private QName getXsType(BeanInfo pBeanInfo) throws SAXException {
        JavaQName qName = pBeanInfo.getType();
        QName xsType = (QName)this.types.get(qName);
        if (xsType == null) {
            String xsTypePrefix;
            String localPart = xsTypePrefix = "T_" + pBeanInfo.getElementName();
            int i = 0;
            while (true) {
                xsType = new QName(pBeanInfo.getTargetNamespace(), localPart);
                if (!this.types.values().contains(xsType)) break;
                localPart = xsTypePrefix + i;
                ++i;
            }
            this.types.put(qName, xsType);
            this.remainingComplexTypes.put(xsType, pBeanInfo);
        }
        return xsType;
    }

    private void addAttr(AttributesImpl pAttrs, ContentHandler pHandler, String pURI, String pLocalName, String pValue) throws SAXException {
        String prefix = this.getAttrPrefix(pURI, pHandler, pAttrs);
        String qName = prefix.length() == 0 ? pLocalName : prefix + ":" + pLocalName;
        pAttrs.addAttribute(pURI, pLocalName, qName, "CDATA", pValue);
    }

    private void addAttr(AttributesImpl pAttrs, ContentHandler pHandler, String pLocalName, String pValue) throws SAXException {
        this.addAttr(pAttrs, pHandler, "", pLocalName, pValue);
    }

    private String getQName(QName pQName, ContentHandler pHandler, AttributesImpl pAttrs) throws SAXException {
        String prefix = this.getPrefix(pQName.getNamespaceURI(), pHandler, pAttrs);
        if (prefix == null || prefix.length() == 0) {
            return pQName.getLocalPart();
        }
        return prefix + ":" + pQName.getLocalPart();
    }

    protected void writeElement(ContentHandler pHandler, BeanInfo pBeanInfo) throws SAXException {
        QName xsType = this.getXsType(pBeanInfo);
        int ctx = this.getPrefixContext();
        AttributesImpl attrs = new AttributesImpl();
        this.addAttr(attrs, pHandler, "name", pBeanInfo.getElementName());
        this.addAttr(attrs, pHandler, "type", this.getQName(xsType, pHandler, attrs));
        this.startXsElement(pHandler, "element", attrs);
        this.endXsElement(pHandler, "element");
        this.setPrefixContext(ctx, pHandler);
    }

    public void write(BeanInfo pBeanInfo, ContentHandler pHandler) throws SAXException {
        boolean firingStartDocument = this.isFiringStartDocument();
        if (firingStartDocument) {
            pHandler.startDocument();
        }
        int ctx = this.getPrefixContext();
        AttributesImpl attrs = new AttributesImpl();
        String targetNs = pBeanInfo.getTargetNamespace();
        this.getPrefix(targetNs, pHandler, attrs);
        if (targetNs != null && !"".equals(targetNs)) {
            this.addAttr(attrs, pHandler, "targetNamespace", targetNs);
        }
        this.startXsElement(pHandler, "schema", attrs);
        this.writeElement(pHandler, pBeanInfo);
        while (!this.remainingComplexTypes.isEmpty()) {
            Iterator iter = this.remainingComplexTypes.entrySet().iterator();
            Map.Entry entry = iter.next();
            iter.remove();
            QName xsType = (QName)entry.getKey();
            BeanInfo beanInfo = (BeanInfo)entry.getValue();
            this.writeComplexType(pHandler, beanInfo, xsType.getLocalPart());
        }
        this.endXsElement(pHandler, "schema");
        this.setPrefixContext(ctx, pHandler);
        if (firingStartDocument) {
            pHandler.endDocument();
        }
    }

    private void startXsElement(ContentHandler pHandler, String pLocalName, AttributesImpl pAttrs) throws SAXException {
        String prefix = this.getPrefix(XML_SCHEMA_URI, pHandler, pAttrs);
        pHandler.startElement(XML_SCHEMA_URI, pLocalName, prefix + ":" + pLocalName, pAttrs);
    }

    private void endXsElement(ContentHandler pHandler, String pLocalName) throws SAXException {
        String prefix = this.getPrefix(XML_SCHEMA_URI, pHandler, null);
        pHandler.endElement(XML_SCHEMA_URI, pLocalName, prefix + ":" + pLocalName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

