/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.types;

import org.apache.ws.jaxme.generator.sg.AtomicTypeSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGlet;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.SimpleTypeSG;
import org.apache.ws.jaxme.generator.types.AtomicTypeSGImpl;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.TypedValue;
import org.apache.ws.jaxme.js.impl.TypedValueImpl;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.SAXException;

public class IntegerSG
extends AtomicTypeSGImpl {
    public static final JavaQName INTEGER_TYPE = JavaQNameImpl.getInstance((Class)(class$java$math$BigInteger == null ? (class$java$math$BigInteger = IntegerSG.class$("java.math.BigInteger")) : class$java$math$BigInteger));
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public IntegerSG(SGFactory pFactory, SchemaSG pSchema, XSType pType) throws SAXException {
        super(pFactory, pSchema, pType);
    }

    public JavaQName getRuntimeType(SimpleTypeSG pController) {
        return INTEGER_TYPE;
    }

    protected String getDatatypeName() {
        return "Integer";
    }

    protected JavaQName getDatatypeType() {
        return INTEGER_TYPE;
    }

    public TypedValue getCastFromString(SimpleTypeSG pController, String pValue) throws SAXException {
        try {
            return new TypedValueImpl((Object)("new java.math.BigInteger(\"" + pValue + "\")"), INTEGER_TYPE);
        }
        catch (NumberFormatException e) {
            throw new LocSAXException("Failed to convert string value to BigInteger: " + pValue, this.getLocator());
        }
    }

    public void forAllNonNullValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        LocalJavaField f = pMethod.newJavaField(INTEGER_TYPE);
        f.addLine(pValue);
        pMethod.addIf((Object)f, (Object)" != null");
        pSGlet.generate(pMethod, pValue);
        pMethod.addEndIf();
    }

    public void forAllValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        pSGlet.generate(pMethod, pValue);
    }

    public void addValidation(SimpleTypeSG pController, JavaMethod pMethod, DirectAccessible pValue) {
        AtomicTypeSG atomicType = pController.getAtomicType();
        Long totalDigits = atomicType.getTotalDigits();
        if (totalDigits != null) {
            pMethod.addIf((Object)pValue, (Object)".signum()", (Object)" == -1");
            pMethod.addIf((Object)pValue, (Object)".toString().length() - 1", (Object)" > ", (Object)totalDigits);
            pMethod.addThrowNew(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = IntegerSG.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, (Object)JavaSource.getQuoted((String)("Length of " + totalDigits + " digits exceeded: ")), (Object)" + ", (Object)pValue);
            pMethod.addEndIf();
            pMethod.addElse();
            pMethod.addIf((Object)pValue, (Object)".toString().length()", (Object)" > ", (Object)totalDigits);
            pMethod.addThrowNew(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = IntegerSG.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, (Object)JavaSource.getQuoted((String)("Length of " + totalDigits + " digits exceeded: ")), (Object)" + ", (Object)pValue);
            pMethod.addEndIf();
            pMethod.addEndIf();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

