/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ws.jaxme.JMManager;
import org.apache.ws.jaxme.JMMarshaller;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.JMValidator;
import org.apache.ws.jaxme.PM;
import org.apache.ws.jaxme.PMException;
import org.apache.ws.jaxme.impl.Configuration;
import org.apache.ws.jaxme.impl.DatatypeConverterImpl;
import org.apache.ws.jaxme.util.Configurator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JAXBContextImpl
extends JAXBContext {
    public static final String CONFIGURATION_URI = "http://ws.apache.org/jaxme/namespaces/jaxme2/configuration";
    private static final SAXParserFactory spf;
    private static final DatatypeConverterImpl datatypeConverter;
    private ClassLoader cl;
    private String packageNames;
    private Map managersByQName = new HashMap();
    private Map managersByInterface = new HashMap();
    private Class jmMarshallerClass;
    private Class jmUnmarshallerClass;
    private Class jmValidatorClass;
    private static boolean verbose;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMMarshaller;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMUnmarshaller;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMValidator;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JAXBContextImpl;

    protected JAXBContextImpl() {
    }

    protected void setClassLoader(ClassLoader pClassLoader) {
        this.cl = pClassLoader;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    protected void setPackageNames(String pPackageNames) {
        this.packageNames = pPackageNames;
    }

    public String getPackageNames() {
        return this.packageNames;
    }

    protected void setJMMarshallerClass(Class pClass) {
        this.jmMarshallerClass = pClass;
    }

    public Class getJMMarshallerClass() {
        return this.jmMarshallerClass;
    }

    protected void setJMUnmarshallerClass(Class pClass) {
        this.jmUnmarshallerClass = pClass;
    }

    public Class getJMUnmarshallerClass() {
        return this.jmUnmarshallerClass;
    }

    protected void setJMValidatorClass(Class pClass) {
        this.jmValidatorClass = pClass;
    }

    public Class getJMValidatorClass() {
        return this.jmValidatorClass;
    }

    public Marshaller createMarshaller() throws JAXBException {
        Class c = this.getJMMarshallerClass();
        try {
            JMMarshaller marshaller = (JMMarshaller)c.newInstance();
            marshaller.setJAXBContextImpl(this);
            return marshaller;
        }
        catch (InstantiationException e) {
            throw new JAXBException("Failed to instantiate class " + c.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JAXBException("Illegal access to class " + c.getName(), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new JAXBException("Class " + c.getName() + " is not implementing " + (class$org$apache$ws$jaxme$JMMarshaller == null ? (class$org$apache$ws$jaxme$JMMarshaller = JAXBContextImpl.class$("org.apache.ws.jaxme.JMMarshaller")) : class$org$apache$ws$jaxme$JMMarshaller).getName());
        }
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        Class c = this.getJMUnmarshallerClass();
        try {
            JMUnmarshaller unmarshaller = (JMUnmarshaller)c.newInstance();
            unmarshaller.setJAXBContextImpl(this);
            return unmarshaller;
        }
        catch (InstantiationException e) {
            throw new JAXBException("Failed to instantiate class " + c.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JAXBException("Illegal access to class " + c.getName(), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new JAXBException("Class " + c.getName() + " is not implementing " + (class$org$apache$ws$jaxme$JMUnmarshaller == null ? (class$org$apache$ws$jaxme$JMUnmarshaller = JAXBContextImpl.class$("org.apache.ws.jaxme.JMUnmarshaller")) : class$org$apache$ws$jaxme$JMUnmarshaller).getName());
        }
    }

    public Validator createValidator() throws JAXBException {
        Class c = this.getJMValidatorClass();
        try {
            JMValidator validator = (JMValidator)c.newInstance();
            validator.setJAXBContextImpl(this);
            return validator;
        }
        catch (InstantiationException e) {
            throw new JAXBException("Failed to instantiate class " + c.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JAXBException("Illegal access to class " + c.getName(), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new JAXBException("Class " + c.getName() + " is not implementing " + (class$org$apache$ws$jaxme$JMValidator == null ? (class$org$apache$ws$jaxme$JMValidator = JAXBContextImpl.class$("org.apache.ws.jaxme.JMValidator")) : class$org$apache$ws$jaxme$JMValidator).getName());
        }
    }

    protected JMManager getManagerByQName(QName pQName) {
        return (JMManager)this.managersByQName.get(pQName);
    }

    protected JMManager getManagerByInterface(Class pElementInterface) {
        return (JMManager)this.managersByInterface.get(pElementInterface);
    }

    public JMManager getManager(QName pQName) throws JAXBException {
        JMManager manager = this.getManagerByQName(pQName);
        if (manager == null) {
            throw new JAXBException("A Manager for " + pQName + " is not declared.");
        }
        return manager;
    }

    public JMManager getManager(Class pElementInterface) throws JAXBException {
        JMManager manager = this.getManagerByInterface(pElementInterface);
        if (manager == null) {
            throw new JAXBException("A Manager for " + pElementInterface.getName() + " is not declared.");
        }
        return manager;
    }

    public JMManager getManagerS(Class pElementInterface) throws SAXException {
        JMManager manager = this.getManagerByInterface(pElementInterface);
        if (manager == null) {
            throw new SAXException("A Manager for " + pElementInterface.getName() + " is not declared.");
        }
        return manager;
    }

    public JMMarshaller getJMMarshaller() throws MarshalException {
        Class c = this.getJMMarshallerClass();
        if (c == null) {
            throw new MarshalException("A JMMarshaller class is not set.");
        }
        try {
            return (JMMarshaller)c.newInstance();
        }
        catch (Exception e) {
            throw new MarshalException("Failed to instantiate JMMarshaller class " + c, (Throwable)e);
        }
    }

    public JMUnmarshaller getJMUnmarshaller() throws UnmarshalException {
        Class c = this.getJMUnmarshallerClass();
        if (c == null) {
            throw new UnmarshalException("A JMUnmarshaller class is not set.");
        }
        try {
            return (JMUnmarshaller)c.newInstance();
        }
        catch (Exception e) {
            throw new UnmarshalException("Failed to instantiate JMUnmarshaller class " + c, (Throwable)e);
        }
    }

    public JMValidator getJMValidator() throws ValidationException {
        Class c = this.getJMValidatorClass();
        if (c == null) {
            throw new ValidationException("A JMValidator class is not set.");
        }
        try {
            return (JMValidator)c.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException("Failed to instantiate JMValidator class " + c, (Throwable)e);
        }
    }

    public PM getJMPM(Class pElementInterface) throws PMException {
        JMManager manager = this.getManagerByInterface(pElementInterface);
        Class c = manager.getPmClass();
        if (c == null) {
            throw new PMException("No persistency class configured for " + pElementInterface.getName());
        }
        try {
            PM pm = (PM)c.newInstance();
            pm.init(manager);
            return pm;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new PMException("Could not instantiate persistence manager class " + c.getName(), e);
        }
    }

    public PM getJMPM(QName pQName) throws PMException {
        JMManager manager = this.getManagerByQName(pQName);
        Class c = manager.getPmClass();
        if (c == null) {
            throw new PMException("No persistency class configured for " + pQName);
        }
        try {
            PM pm = (PM)c.newInstance();
            pm.init(manager);
            return pm;
        }
        catch (Exception e) {
            throw new PMException("Could not instantiate persistence manager class " + c.getName(), e);
        }
    }

    protected void init() throws JAXBException {
        if (this.packageNames == null || this.packageNames.length() == 0) {
            this.packageNames = (class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBContextImpl.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl).getName();
            this.packageNames = this.packageNames.substring(0, this.packageNames.lastIndexOf(46));
        }
        boolean first = true;
        StringTokenizer st = new StringTokenizer(this.packageNames, ":");
        while (st.hasMoreTokens()) {
            Exception f;
            String packageName = st.nextToken();
            String configFileName = (packageName.length() > 0 ? packageName.replace('.', '/') + '/' : "") + "Configuration.xml";
            URL url = this.getClassLoader().getResource(configFileName);
            if (url == null) continue;
            InputStream istream = null;
            try {
                Configuration c = new Configuration(this);
                Configurator configurator = new Configurator();
                configurator.setNamespace(CONFIGURATION_URI);
                configurator.setRootObject(c);
                SAXParser sp = spf.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                xr.setContentHandler(configurator);
                istream = url.openStream();
                InputSource isource = new InputSource(istream);
                isource.setSystemId(url.toString());
                xr.parse(isource);
                istream.close();
                istream = null;
                if (!first) continue;
                first = false;
                this.setJMMarshallerClass(c.getJMMarshallerClass());
                this.setJMUnmarshallerClass(c.getJMUnmarshallerClass());
                this.setJMValidatorClass(c.getJMValidatorClass());
            }
            catch (IOException e) {
                throw new JAXBException("Failed to load config file " + url, (Throwable)e);
            }
            catch (SAXParseException e) {
                f = e.getException() == null ? e : e.getException();
                throw new JAXBException("Failed to parse config file " + url + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ": " + f.getMessage(), (Throwable)f);
            }
            catch (SAXException e) {
                f = e.getException() == null ? e : e.getException();
                String msg = "Failed to parse config file " + url + ": " + f.getMessage();
                throw new JAXBException(msg, (Throwable)f);
            }
            catch (ParserConfigurationException e) {
                throw new JAXBException("Failed to create a SAX Parser: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (Throwable ignore) {}
            }
        }
        if (first) {
            throw new JAXBException("Unable to locate configuration file Configuration.xml in " + this.packageNames);
        }
    }

    public static JAXBContextImpl createContext() throws JAXBException {
        return JAXBContextImpl.createContext(null, (class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBContextImpl.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl).getClassLoader());
    }

    public Configuration createConfiguration(Attributes pAttributes) throws JAXBException {
        String className = pAttributes.getValue("", "className");
        if (className == null || className.length() == 0) {
            return new Configuration(this);
        }
        try {
            return (Configuration)this.cl.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new JAXBException("Failed to instantiate Configuration class " + className, (Throwable)e);
        }
    }

    private static void showException(Exception e) {
        if (!verbose) {
            return;
        }
        System.err.println("Exception catched in " + (class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBContextImpl.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl).getName() + ".createContext().");
        System.err.println("Set " + (class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBContextImpl.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl).getName() + ".verbose = false to suppress this message.");
        e.printStackTrace(System.err);
    }

    public static JAXBContextImpl createContext(String pPackageNames, ClassLoader pClassLoader) throws JAXBException {
        try {
            JAXBContextImpl result = new JAXBContextImpl();
            result.setClassLoader(pClassLoader);
            result.setPackageNames(pPackageNames);
            result.init();
            return result;
        }
        catch (RuntimeException e) {
            JAXBContextImpl.showException(e);
            throw e;
        }
        catch (JAXBException e) {
            JAXBContextImpl.showException((Exception)((Object)e));
            throw e;
        }
    }

    public void addManager(JMManager pManager) throws JAXBException {
        Class elementInterface = pManager.getElementInterface();
        if (elementInterface == null) {
            throw new JAXBException("The Manager must have its elementInterface set.");
        }
        if (this.managersByInterface.containsKey(elementInterface)) {
            throw new JAXBException("A Manager for interface " + elementInterface.getName() + " is already set.");
        }
        if (pManager.getDriverClass() == null) {
            throw new IllegalStateException("Missing driver class for " + pManager.getQName());
        }
        if (pManager.getHandlerClass() == null) {
            throw new IllegalStateException("Missing driver class for " + pManager.getQName());
        }
        QName qName = pManager.getQName();
        if (qName != null && this.managersByQName.containsKey(qName)) {
            throw new JAXBException("A Manager for document type " + qName + " is already set.");
        }
        this.managersByInterface.put(elementInterface, pManager);
        if (qName != null) {
            this.managersByQName.put(qName, pManager);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        datatypeConverter = new DatatypeConverterImpl();
        spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        spf.setNamespaceAware(true);
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)datatypeConverter);
        verbose = true;
    }
}

