/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

public class ClassLoader {
    public static Class getClass(String pName) throws ClassNotFoundException {
        try {
            return Class.forName(pName);
        }
        catch (ClassNotFoundException e) {
            try {
                java.lang.ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException(pName);
                }
                return cl.loadClass(pName);
            }
            catch (ClassNotFoundException f) {
                throw e;
            }
        }
    }

    public static Class getClass(String pName, Class pAssignableTo) throws ClassNotFoundException {
        Class result = ClassLoader.getClass(pName);
        if (pAssignableTo != null && !pAssignableTo.isAssignableFrom(result)) {
            throw new IllegalArgumentException("The class " + result.getName() + " is not implementing or extending " + pAssignableTo.getName());
        }
        return result;
    }
}

