/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.ui.StepPanel;
import fds.setup.util.CommonTools;
import fds.setup.util.UtilImage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class GuideWin
extends JFrame
implements ActionListener {
    private ArrayList stepPanelNames = null;
    private HashMap nameToStepPanel = null;
    private JPanel jContentPane = null;
    private JSplitPane jSplitPaneTop = null;
    private JPanel BtnPanel = null;
    private JPanel ImageContainerPanel = null;
    private JButton BtnCancel = null;
    private JButton BtnLastStep = null;
    private JButton BtnNextStep = null;
    private JPanel CardPanel = null;
    private CardLayout cardLayout = null;
    private int currStep = 0;
    private JLabel lblNote_4;
    private Image backImg = null;
    private Image logoImg = null;
    public static final int SYSTEM_EXIT = 0;
    public static final int DISPOSE = 1;
    private int closeState = 1;
    private boolean isOK = false;

    public GuideWin() throws HeadlessException {
        this.initialize();
    }

    private JSplitPane getJSplitPaneTop() {
        if (this.jSplitPaneTop == null) {
            this.jSplitPaneTop = new JSplitPane();
            this.jSplitPaneTop.setDividerSize(0);
            this.jSplitPaneTop.setBorder(new AbstractBorder(){
                Color c1 = new Color(37888);
                Color c2 = new Color(0xFFFFFF);

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Color old = g.getColor();
                    g.setColor(this.c1);
                    g.drawLine(x, y + height - 2, x + width, y + height - 2);
                    g.setColor(this.c2);
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                    g.setColor(old);
                }

                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 2, 0);
                }
            });
            this.jSplitPaneTop.setDividerLocation(167);
            this.jSplitPaneTop.setOpaque(false);
            this.jSplitPaneTop.setLeftComponent(this.getImageContainerPanel());
            this.jSplitPaneTop.setRightComponent(this.getCardPanel());
        }
        return this.jSplitPaneTop;
    }

    private JPanel getBtnPanel() {
        if (this.BtnPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.BtnPanel = new JPanel(){

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                }
            };
            this.BtnPanel.setLayout(flowLayout1);
            this.BtnPanel.setBackground(new Color(15660540));
            this.BtnPanel.setPreferredSize(new Dimension(10, 34));
            flowLayout1.setHgap(20);
            flowLayout1.setAlignment(2);
            Font font_lbl = new Font("\u5b8b\u4f53", 0, 14);
            Color c1 = new Color(0xF00000);
            this.lblNote_4 = new JLabel();
            this.lblNote_4.setBounds(new Rectangle(10, 300, 380, 340));
            this.lblNote_4.setText("http://www.uwsoft.cn       ");
            this.lblNote_4.setFont(font_lbl);
            this.lblNote_4.setForeground(c1);
            this.BtnPanel.add((Component)this.lblNote_4, null);
            this.BtnPanel.add((Component)this.getBtnCancel(), null);
            this.BtnPanel.add((Component)this.getBtnLastStep(), null);
            this.BtnPanel.add((Component)this.getBtnNextStep(), null);
        }
        return this.BtnPanel;
    }

    private JPanel getImageContainerPanel() {
        if (this.ImageContainerPanel == null) {
            this.ImageContainerPanel = new JPanel(){

                private void paintHintText(Graphics g) {
                    Color oldColor = g.getColor();
                    Font oldFont = g.getFont();
                    Font font = new Font("Dialog", 1, 12);
                    int size = GuideWin.this.getStepPanelNames().size();
                    FontMetrics fm = this.getFontMetrics(oldFont);
                    FontMetrics fmm = this.getFontMetrics(font);
                    int fHeight = fm.getHeight();
                    int fontHeight = fmm.getHeight();
                    if (size == 0) {
                        return;
                    }
                    int y = 95;
                    g.setFont(font);
                    g.setColor(new Color(0));
                    g.drawString("\u5b89\u88c5\u5411\u5bfc...", 10, y + 5);
                    y += 10;
                    int i = 0;
                    while (i < size) {
                        StepPanel panel = GuideWin.this.getStepPanel(i);
                        String title = panel.getTitle();
                        if (GuideWin.this.currStep == i) {
                            y += fontHeight;
                            g.setFont(font);
                            g.setColor(Color.red);
                        } else {
                            y += fHeight;
                            g.setFont(oldFont);
                            g.setColor(oldColor);
                        }
                        g.drawString(title, 20, y + 5);
                        ++i;
                    }
                    g.setColor(oldColor);
                    g.setFont(oldFont);
                }

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.paintHintText(g);
                }
            };
            this.ImageContainerPanel.setMinimumSize(new Dimension(200, 30));
        }
        this.ImageContainerPanel.setOpaque(false);
        return this.ImageContainerPanel;
    }

    JButton getBtnCancel() {
        if (this.BtnCancel == null) {
            this.BtnCancel = new JButton();
            this.BtnCancel.setText("\u53d6\u6d88");
            this.BtnCancel.setPreferredSize(new Dimension(100, 23));
            this.BtnCancel.addActionListener(this);
        }
        return this.BtnCancel;
    }

    JButton getBtnLastStep() {
        if (this.BtnLastStep == null) {
            this.BtnLastStep = new JButton();
            this.BtnLastStep.setText("\u4e0a\u4e00\u6b65");
            this.BtnLastStep.setPreferredSize(new Dimension(100, 23));
            this.BtnLastStep.addActionListener(this);
        }
        return this.BtnLastStep;
    }

    JButton getBtnNextStep() {
        if (this.BtnNextStep == null) {
            this.BtnNextStep = new JButton();
            this.BtnNextStep.setText("\u4e0b\u4e00\u6b65");
            this.BtnNextStep.setPreferredSize(new Dimension(100, 23));
            this.BtnNextStep.addActionListener(this);
        }
        return this.BtnNextStep;
    }

    private JPanel getCardPanel() {
        if (this.CardPanel == null) {
            this.CardPanel = new JPanel();
            this.CardPanel.setLayout(this.getCardLayout());
        }
        this.CardPanel.setOpaque(false);
        return this.CardPanel;
    }

    public CardLayout getCardLayout() {
        if (this.cardLayout == null) {
            this.cardLayout = new CardLayout();
        }
        return this.cardLayout;
    }

    public static void main(String[] args1) {
    }

    private void initialize() {
        int width = 620;
        int height = 460;
        this.backImg = UtilImage.getMainImg();
        this.logoImg = UtilImage.getLogoImg();
        this.setSize(width, height);
        this.setTitle("\u5b89\u88c5\u7a0b\u5e8f...");
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowHandle());
    }

    private StepPanel getStepPanel(int step) {
        int size = this.getStepPanelNames().size();
        if (size <= step) {
            return null;
        }
        String name = (String)this.getStepPanelNames().get(step);
        StepPanel stepPanel = (StepPanel)this.getNameToStepPanel().get(name);
        return stepPanel;
    }

    public boolean showStepPanel(int step) {
        StepPanel stepPanel = this.getStepPanel(step);
        if (stepPanel == null) {
            return false;
        }
        String name = stepPanel.getName();
        this.getCardLayout().show(this.getCardPanel(), name);
        stepPanel.start();
        return true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Dimension size = this.getSize();
                    if (GuideWin.this.backImg != null) {
                        g.drawImage(GuideWin.this.backImg, 0, 0, size.width, size.height, this);
                    }
                }
            };
            this.jContentPane.setLayout(new BorderLayout());
            Border border = BorderFactory.createLineBorder(new Color(35072));
            this.jContentPane.setBorder(border);
            this.jContentPane.add((Component)this.getJSplitPaneTop(), "Center");
            this.jContentPane.add((Component)this.getBtnPanel(), "South");
        }
        return this.jContentPane;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o.equals(this.getBtnCancel())) {
            this.doCancel();
        } else if (o.equals(this.getBtnLastStep())) {
            this.doLastStep();
        } else if (o.equals(this.getBtnNextStep())) {
            this.doNextStep();
        }
    }

    private void doCancel() {
        if (JOptionPane.showConfirmDialog(this, "\u60a8\u662f\u5426\u771f\u7684\u8981\u9000\u51fa\u5b89\u88c5\uff1f", "\u8be2\u95ee", 2) == 0) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void doLastStep() {
        StepPanel stepPanel = this.getStepPanel(this.currStep);
        try {
            stepPanel.doLastStep();
            int nextIndex = this.currStep - stepPanel.lastPanelIndexIncrement();
            if (this.showStepPanel(nextIndex)) {
                this.currStep = nextIndex;
                this.ImageContainerPanel.repaint();
            }
        }
        catch (Exception e) {
            CommonTools.showMessageDialog(this, e.getMessage(), "\u5f02\u5e38", 0);
        }
    }

    private void doNextStep() {
        StepPanel stepPanel = this.getStepPanel(this.currStep);
        try {
            if (!stepPanel.doNextStep()) {
                return;
            }
            int nextIndex = this.currStep + stepPanel.nextPanelIndexIncrement();
            if (this.showStepPanel(nextIndex)) {
                this.currStep = nextIndex;
                this.ImageContainerPanel.repaint();
            } else if (this.getCloseState() == 0) {
                System.exit(0);
            } else if (this.getCloseState() == 1) {
                this.setVisible(false);
                this.dispose();
            }
            this.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonTools.showMessageDialog(this, e.getMessage(), "\u5f02\u5e38", 0);
        }
    }

    private ArrayList getStepPanelNames() {
        if (this.stepPanelNames == null) {
            this.stepPanelNames = new ArrayList();
        }
        return this.stepPanelNames;
    }

    private HashMap getNameToStepPanel() {
        if (this.nameToStepPanel == null) {
            this.nameToStepPanel = new HashMap();
        }
        return this.nameToStepPanel;
    }

    public void addStepPanel(StepPanel stepPanel) {
        String name = stepPanel.getName();
        if (name == null) {
            throw new RuntimeException("stepPanel's name can't be null.");
        }
        if (this.getStepPanelNames().contains(name)) {
            throw new RuntimeException("stepPanel's name has exist");
        }
        stepPanel.setParentGuide(this);
        this.getCardPanel().add(name, stepPanel);
        this.getStepPanelNames().add(name);
        this.getNameToStepPanel().put(name, stepPanel);
    }

    void setIsOK(boolean isOK) {
        this.isOK = isOK;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public int getCloseState() {
        return this.closeState;
    }

    public void setCloseState(int closeState) {
        this.closeState = closeState;
    }

    private class WindowHandle
    extends WindowAdapter {
        private WindowHandle() {
        }

        public void windowClosing(WindowEvent e) {
            GuideWin.this.doCancel();
        }
    }
}

