/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.cfg.DataConnCfg;
import fds.setup.cfg.DatasourceIni;
import fds.setup.cfg.DbcIni;
import fds.setup.cfg.InstallDbcWork;
import fds.setup.cfg.InstallDbcWorkval;
import fds.setup.ui.StepPanel;
import fds.setup.util.CommonTools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InstallDbcPanel
extends StepPanel {
    private boolean errorStop = false;
    private boolean hasInstallFinished = false;
    private JPanel ProgressPanel = null;
    private JProgressBar PBDbc = null;
    private JLabel LblDbc = null;
    private JProgressBar PBFile = null;
    private JLabel LblFile = null;
    private Color pbFGColor = new Color(16746767);
    private Color pbBGColor = Color.white;
    private Color pbBorderColor = Color.black;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInstallProgressUI() {
        boolean currFileIndex = false;
        int currDbcIndex = 0;
        DbcIni currDbc = null;
        int DbcCount = 0;
        Class<InstallDbcWorkval> clazz = InstallDbcWorkval.class;
        synchronized (InstallDbcWorkval.class) {
            currDbc = InstallDbcWorkval.getCurrDbc();
            currDbcIndex = InstallDbcWorkval.getCurrDbcIndex();
            DbcCount = InstallDbcWorkval.getDbcCount();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            boolean fileProgressValue = false;
            int DbcProgressValue = 0;
            int pbDbcMax = this.getPBDbc().getMaximum();
            if (DbcCount != 0) {
                DbcProgressValue = currDbcIndex * pbDbcMax / DbcCount;
                this.getPBDbc().setValue(DbcProgressValue);
                String name = currDbc != null ? currDbc.getPrdName() : "";
                this.LblDbc.setText("\u6b63\u5728\u5b89\u88c5:" + name);
                int percent = DbcProgressValue * 100 / pbDbcMax;
                this.getPBDbc().setString(percent + "%");
            } else {
                this.getPBDbc().setValue(this.getPBDbc().getMinimum());
                this.LblDbc.setText("");
            }
            return;
        }
    }

    public InstallDbcPanel() {
        this.initialize();
    }

    public String getTitle() {
        return "\u25a0 \u5b89\u88c5\u57fa\u7840\u6570\u636e";
    }

    public String getImagePath() {
        return "";
    }

    public boolean doLastStep() throws Exception {
        this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
        return true;
    }

    private void showUpdateDBHint() {
    }

    public boolean doNextStep() throws Exception {
        DatasourceIni.getInstance();
        String connType = DatasourceIni.getConnType();
        DatasourceIni.getInstance();
        String dbURL = DatasourceIni.getUrl();
        DatasourceIni.getInstance();
        String userName = DatasourceIni.getUserName();
        DatasourceIni.getInstance();
        String userPwd = DatasourceIni.getPassword();
        if (connType.equals("MySQL")) {
            dbURL = String.valueOf(dbURL) + "?allowMultiQueries=true";
        }
        DataConnCfg.setConnFds(null);
        if (!DataConnCfg.ConnFds(connType, dbURL, userName, userPwd)) {
            JOptionPane.showMessageDialog(this, "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93:" + dbURL);
            return false;
        }
        if (this.hasInstallFinished) {
            this.showUpdateDBHint();
            return true;
        }
        this.setGuideButnState("btn_last_step", false);
        this.setGuideButnState("btn_next_step", false);
        new Thread(new MonitorRunnable()).start();
        new Thread(new InstallRunnable()).start();
        return false;
    }

    public void start() {
        this.setGuideButnState("btn_last_step", true);
        this.setGuideButnState("btn_next_step", true);
        this.hasInstallFinished = false;
        this.setGuideButnText("btn_next_step", "\u5f00\u59cb\u5b89\u88c5");
        this.setGuideButnText("btn_cancel", "\u53d6\u6d88");
        try {
            boolean b = this.doNextStep();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonTools.showMessageDialog(this, e.getMessage(), "\u5f02\u5e38", 0);
        }
    }

    public String getName() {
        return "Install Dbc panel";
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(451, 380);
        this.add((Component)this.getProgressPanel(), null);
    }

    private JPanel getProgressPanel() {
        if (this.ProgressPanel == null) {
            this.LblFile = new JLabel();
            this.ProgressPanel = new JPanel();
            this.ProgressPanel.setOpaque(false);
            this.ProgressPanel.setLayout(null);
            this.ProgressPanel.setBounds(15, 13, 423, 354);
            this.LblDbc = new JLabel();
            this.LblDbc.setBounds(21, 120, 391, 22);
            this.LblDbc.setText("\u5b89\u88c5\u57fa\u7840\u6570\u636e\uff1a");
            this.ProgressPanel.add((Component)this.getPBDbc(), null);
            this.ProgressPanel.add((Component)this.LblDbc, null);
        }
        return this.ProgressPanel;
    }

    private JProgressBar getPBDbc() {
        if (this.PBDbc == null) {
            this.PBDbc = new JProgressBar();
            this.PBDbc.setStringPainted(true);
            this.PBDbc.setForeground(this.pbFGColor);
            this.PBDbc.setBackground(this.pbBGColor);
            this.PBDbc.setBorder(BorderFactory.createLineBorder(this.pbBorderColor));
            this.PBDbc.setBounds(21, 150, 362, 20);
        }
        return this.PBDbc;
    }

    private JProgressBar getPBFile() {
        if (this.PBFile == null) {
            this.PBFile = new JProgressBar();
            this.PBFile.setForeground(this.pbFGColor);
            this.PBFile.setBackground(this.pbBGColor);
            this.PBFile.setBorder(BorderFactory.createLineBorder(this.pbBorderColor));
            this.PBFile.setStringPainted(true);
            this.PBFile.setBounds(21, 250, 362, 20);
        }
        return this.PBFile;
    }

    private class InstallRunnable
    implements Runnable {
        private InstallRunnable() {
        }

        public void run() {
            try {
                InstallDbcPanel.this.errorStop = false;
                new InstallDbcWork(InstallDbcPanel.this).install();
                InstallDbcPanel.this.hasInstallFinished = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                InstallDbcPanel.this.errorStop = true;
                this.showErrorMsg(e.getMessage());
            }
        }

        private void showErrorMsg(String msg) {
            CommonTools.showMessageDialog(InstallDbcPanel.this, msg, "\u5f02\u5e38", 0);
        }
    }

    private class MonitorRunnable
    implements Runnable {
        private MonitorRunnable() {
        }

        public void run() {
            while (!InstallDbcPanel.this.hasInstallFinished && !InstallDbcPanel.this.errorStop) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InstallDbcPanel.this.refreshInstallProgressUI();
            }
            if (InstallDbcPanel.this.hasInstallFinished && !InstallDbcPanel.this.errorStop) {
                InstallDbcPanel.this.getPBFile().setValue(InstallDbcPanel.this.getPBFile().getMaximum());
                InstallDbcPanel.this.getPBDbc().setValue(InstallDbcPanel.this.getPBDbc().getMaximum());
                InstallDbcPanel.this.setGuideButnState("btn_next_step", true);
                InstallDbcPanel.this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
                InstallDbcPanel.this.setIsOK(true);
                InstallDbcPanel.this.LblDbc.setText("\u57fa\u7840\u6570\u636e\u5b89\u88c5\u5b8c\u6bd5\uff0c\u8bf7\u70b9[\u4e0b\u4e00\u6b65]\uff01");
                Color c1 = new Color(240);
                InstallDbcPanel.this.LblDbc.setForeground(c1);
            } else {
                InstallDbcPanel.this.setIsOK(false);
                InstallDbcWorkval.reset();
                InstallDbcPanel.this.refreshInstallProgressUI();
                InstallDbcPanel.this.errorStop = false;
                InstallDbcPanel.this.setGuideButnState("btn_last_step", true);
                InstallDbcPanel.this.setGuideButnState("btn_next_step", true);
            }
        }
    }
}

