/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.cfg.InstallJreWork;
import fds.setup.cfg.InstallJreWorkval;
import fds.setup.cfg.ProductIni;
import fds.setup.ui.StepPanel;
import fds.setup.util.CommonTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InstallJrePanel
extends StepPanel {
    private boolean errorStop = false;
    private boolean hasInstallFinished = false;
    private JPanel ProgressPanel = null;
    private JLabel LblProduct = null;
    private JProgressBar PBFile = null;
    private JLabel LblFile = null;
    private Color pbFGColor = new Color(16746767);
    private Color pbBGColor = Color.white;
    private Color pbBorderColor = Color.black;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInstallProgressUI() {
        int currFileIndex = 0;
        int currProductIndex = 0;
        int fileCount = 0;
        String fileName = null;
        ProductIni currProduct = null;
        int productCount = 0;
        Class<InstallJreWorkval> clazz = InstallJreWorkval.class;
        synchronized (InstallJreWorkval.class) {
            currFileIndex = InstallJreWorkval.getCurrFileIndex();
            currProduct = InstallJreWorkval.getCurrProduct();
            currProductIndex = InstallJreWorkval.getCurrProductIndex();
            fileCount = InstallJreWorkval.getFileCount();
            fileName = InstallJreWorkval.getFileName();
            productCount = InstallJreWorkval.getProductCount();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            int pbFileMax = this.getPBFile().getMaximum();
            int fileProgressValue = 0;
            if (fileCount != 0) {
                fileProgressValue = currFileIndex * pbFileMax / fileCount;
                fileProgressValue = fileProgressValue <= pbFileMax ? fileProgressValue : pbFileMax;
                this.getPBFile().setValue(fileProgressValue);
                this.LblFile.setText("\u6b63\u5728\u590d\u5236\uff1a" + fileName);
                int percent = fileProgressValue * 100 / pbFileMax;
                this.getPBFile().setString(percent + "%");
            } else {
                this.getPBFile().setValue(this.getPBFile().getMinimum());
                this.LblFile.setText("");
            }
            return;
        }
    }

    public InstallJrePanel() {
        this.initialize();
    }

    public String getTitle() {
        return "\u25a0 \u5b89\u88c5\u8fd0\u884c\u73af\u5883(JRE)";
    }

    public String getImagePath() {
        return "";
    }

    public boolean doLastStep() throws Exception {
        this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
        return true;
    }

    private void showUpdateDBHint() {
    }

    public boolean doNextStep() throws Exception {
        if (this.hasInstallFinished) {
            return true;
        }
        this.setGuideButnState("btn_last_step", false);
        this.setGuideButnState("btn_next_step", false);
        new Thread(new MonitorRunnable()).start();
        new Thread(new InstallRunnable()).start();
        return false;
    }

    public void start() {
        this.setGuideButnState("btn_last_step", true);
        this.setGuideButnState("btn_next_step", false);
        this.hasInstallFinished = false;
        this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
        try {
            boolean b = this.doNextStep();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonTools.showMessageDialog(this, e.getMessage(), "\u5f02\u5e38", 0);
        }
    }

    public String getName() {
        return "Install jre-everinment panel";
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(451, 380);
        this.add((Component)this.getProgressPanel(), null);
    }

    private JPanel getProgressPanel() {
        if (this.ProgressPanel == null) {
            this.LblFile = new JLabel();
            this.ProgressPanel = new JPanel();
            this.ProgressPanel.setOpaque(false);
            this.ProgressPanel.setLayout(null);
            this.ProgressPanel.setBounds(15, 13, 423, 354);
            this.LblProduct = new JLabel();
            this.LblProduct.setBounds(21, 120, 391, 22);
            this.LblProduct.setText("\u5b89\u88c5\u8fd0\u884c\u73af\u5883JRE\uff1a");
            Font font = new Font("\u5b8b\u4f53", 0, 14);
            this.LblFile.setBounds(21, 220, 381, 22);
            this.LblFile.setText("\u6b63\u5728\u590d\u5236\uff1a");
            this.LblFile.setFont(font);
            this.ProgressPanel.add((Component)this.LblProduct, null);
            this.ProgressPanel.add((Component)this.getPBFile(), null);
            this.ProgressPanel.add((Component)this.LblFile, null);
        }
        return this.ProgressPanel;
    }

    private JProgressBar getPBFile() {
        if (this.PBFile == null) {
            this.PBFile = new JProgressBar();
            this.PBFile.setForeground(this.pbFGColor);
            this.PBFile.setBackground(this.pbBGColor);
            this.PBFile.setBorder(BorderFactory.createLineBorder(this.pbBorderColor));
            this.PBFile.setStringPainted(true);
            this.PBFile.setBounds(21, 160, 362, 20);
        }
        return this.PBFile;
    }

    private class InstallRunnable
    implements Runnable {
        private InstallRunnable() {
        }

        public void run() {
            try {
                InstallJrePanel.this.errorStop = false;
                new InstallJreWork(InstallJrePanel.this).install();
                InstallJrePanel.this.hasInstallFinished = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                InstallJrePanel.this.errorStop = true;
                this.showErrorMsg("\u5b89\u88c5\u6e90\u6587\u4ef6\u6216\u5b89\u88c5\u76ee\u6807\u4f4d\u7f6e\u8def\u5f84\u4e2d\u53ef\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\uff0c\u5b89\u88c5\u65e0\u6cd5\u7ee7\u7eed\uff01");
            }
        }

        private void showErrorMsg(String msg) {
            CommonTools.showMessageDialog(InstallJrePanel.this, msg, "\u5f02\u5e38", 0);
        }
    }

    private class MonitorRunnable
    implements Runnable {
        private MonitorRunnable() {
        }

        public void run() {
            while (!InstallJrePanel.this.hasInstallFinished && !InstallJrePanel.this.errorStop) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InstallJrePanel.this.refreshInstallProgressUI();
            }
            if (InstallJrePanel.this.hasInstallFinished && !InstallJrePanel.this.errorStop) {
                InstallJrePanel.this.getPBFile().setValue(InstallJrePanel.this.getPBFile().getMaximum());
                InstallJrePanel.this.setGuideButnState("btn_next_step", true);
                InstallJrePanel.this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
                InstallJrePanel.this.setIsOK(true);
                InstallJrePanel.this.LblFile.setText("JRE\u73af\u5883\u5b89\u88c5\u5b8c\u6bd5\uff0c\u8bf7\u70b9[\u4e0b\u4e00\u6b65]\uff01");
                Color c1 = new Color(240);
                InstallJrePanel.this.LblFile.setForeground(c1);
            } else {
                InstallJrePanel.this.setIsOK(false);
                InstallJreWorkval.reset();
                InstallJrePanel.this.refreshInstallProgressUI();
                InstallJrePanel.this.errorStop = false;
                InstallJrePanel.this.setGuideButnState("btn_last_step", false);
                InstallJrePanel.this.setGuideButnState("btn_next_step", true);
            }
        }
    }
}

