/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.cfg.InstallPrdWork;
import fds.setup.cfg.InstallPrdWorkval;
import fds.setup.cfg.ProductIni;
import fds.setup.ui.StepPanel;
import fds.setup.util.CommonTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class InstallPrdPanel
extends StepPanel {
    private boolean errorStop = false;
    private boolean hasInstallFinished = false;
    private JPanel ProgressPanel = null;
    private JProgressBar PBProduct = null;
    private JLabel LblProduct = null;
    private JProgressBar PBFile = null;
    private JLabel LblFile = null;
    private Color pbFGColor = new Color(16746767);
    private Color pbBGColor = Color.white;
    private Color pbBorderColor = Color.black;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInstallProgressUI() {
        int currFileIndex = 0;
        int currProductIndex = 0;
        int fileCount = 0;
        String fileName = null;
        ProductIni currProduct = null;
        int productCount = 0;
        Class<InstallPrdWorkval> clazz = InstallPrdWorkval.class;
        synchronized (InstallPrdWorkval.class) {
            currFileIndex = InstallPrdWorkval.getCurrFileIndex();
            currProduct = InstallPrdWorkval.getCurrProduct();
            currProductIndex = InstallPrdWorkval.getCurrProductIndex();
            fileCount = InstallPrdWorkval.getFileCount();
            fileName = InstallPrdWorkval.getFileName();
            productCount = InstallPrdWorkval.getProductCount();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            int pbFileMax = this.getPBFile().getMaximum();
            int fileProgressValue = 0;
            if (fileCount != 0) {
                fileProgressValue = currFileIndex * pbFileMax / fileCount;
                fileProgressValue = fileProgressValue <= pbFileMax ? fileProgressValue : pbFileMax;
                this.getPBFile().setValue(fileProgressValue);
                String name = fileName != null ? fileName : "";
                this.LblFile.setText("\u6b63\u5728\u89e3\u538b\uff1a" + name);
                int percent = fileProgressValue * 100 / pbFileMax;
                this.getPBFile().setString(percent + "%");
            } else {
                this.getPBFile().setValue(this.getPBFile().getMinimum());
                this.LblFile.setText("");
            }
            int productProgressValue = 0;
            int pbProductMax = this.getPBProduct().getMaximum();
            if (productCount != 0) {
                productProgressValue = currProductIndex * pbProductMax / productCount;
                this.getPBProduct().setValue(productProgressValue);
                String name = currProduct != null ? currProduct.getPrdName() : "";
                this.LblProduct.setText("\u6b63\u5728\u5b89\u88c5\uff1a" + name);
                int percent = productProgressValue * 100 / pbProductMax;
                this.getPBProduct().setString(percent + "%");
            } else {
                this.getPBProduct().setValue(this.getPBProduct().getMinimum());
                this.LblProduct.setText("");
            }
            return;
        }
    }

    public InstallPrdPanel() {
        this.initialize();
    }

    public String getTitle() {
        return "\u25a0 \u5b89\u88c5\u7cfb\u7edf\u6587\u4ef6";
    }

    public String getImagePath() {
        return "";
    }

    public boolean doLastStep() throws Exception {
        this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
        return true;
    }

    private void showUpdateDBHint() {
    }

    public boolean doNextStep() throws Exception {
        if (this.hasInstallFinished) {
            this.showUpdateDBHint();
            return true;
        }
        this.setGuideButnState("btn_last_step", false);
        this.setGuideButnState("btn_next_step", false);
        new Thread(new MonitorRunnable()).start();
        new Thread(new InstallRunnable()).start();
        return false;
    }

    public void start() {
        this.setGuideButnState("btn_last_step", false);
        this.setGuideButnState("btn_next_step", true);
        this.hasInstallFinished = false;
        this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
        try {
            boolean b = this.doNextStep();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonTools.showMessageDialog(this, e.getMessage(), "\u5f02\u5e38", 0);
        }
    }

    public String getName() {
        return "Install product panel";
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(451, 380);
        this.add((Component)this.getProgressPanel(), null);
    }

    private JPanel getProgressPanel() {
        if (this.ProgressPanel == null) {
            this.LblFile = new JLabel();
            this.ProgressPanel = new JPanel();
            this.ProgressPanel.setOpaque(false);
            this.ProgressPanel.setLayout(null);
            this.ProgressPanel.setBounds(15, 13, 423, 354);
            this.LblProduct = new JLabel();
            this.LblProduct.setBounds(21, 120, 391, 22);
            this.LblProduct.setText("\u5b89\u88c5\u4ea7\u54c1\uff1a");
            this.LblFile.setBounds(21, 220, 381, 22);
            this.LblFile.setText("\u6b63\u5728\u89e3\u538b\uff1a");
            Font font = new Font("\u5b8b\u4f53", 0, 14);
            this.LblFile.setFont(font);
            this.ProgressPanel.add((Component)this.getPBProduct(), null);
            this.ProgressPanel.add((Component)this.LblProduct, null);
            this.ProgressPanel.add((Component)this.getPBFile(), null);
            this.ProgressPanel.add((Component)this.LblFile, null);
        }
        return this.ProgressPanel;
    }

    private JProgressBar getPBProduct() {
        if (this.PBProduct == null) {
            this.PBProduct = new JProgressBar();
            this.PBProduct.setStringPainted(true);
            this.PBProduct.setForeground(this.pbFGColor);
            this.PBProduct.setBackground(this.pbBGColor);
            this.PBProduct.setBorder(BorderFactory.createLineBorder(this.pbBorderColor));
            this.PBProduct.setBounds(21, 150, 362, 20);
        }
        return this.PBProduct;
    }

    private JProgressBar getPBFile() {
        if (this.PBFile == null) {
            this.PBFile = new JProgressBar();
            this.PBFile.setForeground(this.pbFGColor);
            this.PBFile.setBackground(this.pbBGColor);
            this.PBFile.setBorder(BorderFactory.createLineBorder(this.pbBorderColor));
            this.PBFile.setStringPainted(true);
            this.PBFile.setBounds(21, 250, 362, 20);
        }
        return this.PBFile;
    }

    private class InstallRunnable
    implements Runnable {
        private InstallRunnable() {
        }

        public void run() {
            try {
                InstallPrdPanel.this.errorStop = false;
                new InstallPrdWork(InstallPrdPanel.this).install();
                InstallPrdPanel.this.hasInstallFinished = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                InstallPrdPanel.this.errorStop = true;
                this.showErrorMsg(e.getMessage());
            }
        }

        private void showErrorMsg(String msg) {
            CommonTools.showMessageDialog(InstallPrdPanel.this, msg, "\u5f02\u5e38", 0);
        }
    }

    private class MonitorRunnable
    implements Runnable {
        private MonitorRunnable() {
        }

        public void run() {
            while (!InstallPrdPanel.this.hasInstallFinished && !InstallPrdPanel.this.errorStop) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InstallPrdPanel.this.refreshInstallProgressUI();
            }
            if (InstallPrdPanel.this.hasInstallFinished && !InstallPrdPanel.this.errorStop) {
                InstallPrdPanel.this.getPBFile().setValue(InstallPrdPanel.this.getPBFile().getMaximum());
                InstallPrdPanel.this.getPBProduct().setValue(InstallPrdPanel.this.getPBProduct().getMaximum());
                InstallPrdPanel.this.setGuideButnState("btn_next_step", true);
                InstallPrdPanel.this.setGuideButnText("btn_next_step", "\u4e0b\u4e00\u6b65");
                InstallPrdPanel.this.setIsOK(true);
                InstallPrdPanel.this.LblFile.setText("\u7cfb\u7edf\u7a0b\u5e8f\u6587\u4ef6\u5b89\u88c5\u5b8c\u6bd5\uff0c\u8bf7\u70b9[\u4e0b\u4e00\u6b65]\u5b89\u88c5\u6570\u636e\uff01");
                Color c1 = new Color(240);
                InstallPrdPanel.this.LblFile.setForeground(c1);
            } else {
                InstallPrdPanel.this.setIsOK(false);
                InstallPrdWorkval.reset();
                InstallPrdPanel.this.refreshInstallProgressUI();
                InstallPrdPanel.this.errorStop = false;
                InstallPrdPanel.this.setGuideButnState("btn_last_step", true);
                InstallPrdPanel.this.setGuideButnState("btn_next_step", true);
            }
        }
    }
}

