/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.util.UtilImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class IntoWin
extends JWindow
implements Runnable {
    private JPanel jContentPane = null;
    private JProgressBar jProgressBar = null;
    private JPanel ImgPanel = null;
    Image backImage = null;
    Point2D start = new Point2D.Double(0.0, 0.0);
    double stepX = 5.0;

    public IntoWin() {
        this.initialize();
    }

    public IntoWin(Frame owner) {
        super(owner);
        this.initialize();
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            Border border = BorderFactory.createLineBorder(new Color(35072));
            this.jProgressBar.setBorder(border);
            this.jProgressBar.setForeground(new Color(16746767));
        }
        return this.jProgressBar;
    }

    private JPanel getImgPanel() {
        if (this.ImgPanel == null) {
            this.ImgPanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Dimension size = this.getSize();
                    if (IntoWin.this.backImage != null) {
                        g.drawImage(IntoWin.this.backImage, 0, 0, size.width, size.height, this);
                    }
                }
            };
        }
        return this.ImgPanel;
    }

    public void run() {
        UtilImage.preLoadImg();
        this.getJProgressBar().setValue(0);
        this.getJProgressBar().setMaximum(4);
        while (true) {
            try {
                do {
                    Thread.sleep(400L);
                    this.getJProgressBar().setValue(this.getJProgressBar().getValue() + 1);
                    this.getJProgressBar().repaint();
                } while (!this.isStop());
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public boolean isStop() {
        return this.getJProgressBar().getValue() >= this.getJProgressBar().getMaximum();
    }

    private void initialize() {
        this.backImage = UtilImage.getIntoImg();
        this.setSize(400, 300);
        if (this.backImage != null) {
            this.setSize(this.backImage.getWidth(this), this.backImage.getHeight(this) + this.getJProgressBar().getPreferredSize().height);
        }
        this.setContentPane(this.getJContentPane());
        this.getImgPanel().repaint();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJProgressBar(), "South");
            this.jContentPane.add((Component)this.getImgPanel(), "Center");
        }
        return this.jContentPane;
    }
}

