/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.ui;

import fds.setup.ui.GuideWin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public abstract class StepPanel
extends JPanel {
    private GuideWin parentGuide;
    protected static final String BTN_CANCEL = "btn_cancel";
    protected static final String BTN_NEXTSTEP = "btn_next_step";
    protected static final String BTN_LASTSTEP = "btn_last_step";
    private Image bgImg;

    public StepPanel() {
        this.setOpaque(false);
        this.parentGuide = null;
        this.bgImg = null;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(300, 200);
    }

    protected GuideWin getParentGuide() {
        return this.parentGuide;
    }

    protected void setParentGuide(GuideWin parentGuide) {
        this.parentGuide = parentGuide;
    }

    protected void setGuideButnState(String btnTag, boolean enable) {
        if (BTN_CANCEL.equals(btnTag)) {
            this.getParentGuide().getBtnCancel().setEnabled(enable);
        } else if (BTN_LASTSTEP.equals(btnTag)) {
            this.getParentGuide().getBtnLastStep().setEnabled(enable);
        } else if (BTN_NEXTSTEP.equals(btnTag)) {
            this.getParentGuide().getBtnNextStep().setEnabled(enable);
        }
    }

    protected void setGuideButnText(String btnTag, String text) {
        if (BTN_CANCEL.equals(btnTag)) {
            this.getParentGuide().getBtnCancel().setText(text);
        } else if (BTN_LASTSTEP.equals(btnTag)) {
            this.getParentGuide().getBtnLastStep().setText(text);
        } else if (BTN_NEXTSTEP.equals(btnTag)) {
            this.getParentGuide().getBtnNextStep().setText(text);
        }
    }

    protected int lastPanelIndexIncrement() {
        return 1;
    }

    protected int nextPanelIndexIncrement() {
        return 1;
    }

    protected void registeObject(String key, Object obj) {
        this.putClientProperty(key, obj);
    }

    protected Object getRegistedObject(String key) {
        return this.getClientProperty(key);
    }

    protected void setIsOK(boolean isOK) {
        this.getParentGuide().setIsOK(isOK);
    }

    public abstract String getTitle();

    public abstract String getImagePath();

    public abstract boolean doLastStep() throws Exception;

    public abstract boolean doNextStep() throws Exception;

    public abstract void start();

    public abstract String getName();

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bgImg != null) {
            Dimension d = this.getSize();
            g.drawImage(this.bgImg, 0, 0, d.width, d.height, this);
        }
    }
}

