/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.util;

import fds.setup.util.ToolZip;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipFile;

public class UtilFile {
    public static boolean createParenFileAsNeeded(File file) {
        boolean b = true;
        File parent = file.getParentFile();
        if (!parent.exists()) {
            b = parent.mkdirs();
        }
        return b;
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            int count = childFiles != null ? childFiles.length : 0;
            int i = 0;
            while (i < count) {
                UtilFile.deleteFile(childFiles[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            System.out.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + file.getAbsolutePath());
        }
    }

    public static void deleteAllSubFile(File file) {
        if (file.isDirectory()) {
            File[] childs = file.listFiles();
            int count = childs != null ? childs.length : 0;
            int i = 0;
            while (i < count) {
                File child = childs[i];
                UtilFile.deleteFile(child);
                ++i;
            }
        }
    }

    public static boolean createDirFile(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static long calcFileSizeInfact(File file) {
        long size = 0L;
        if (UtilFile.isZipfile(file)) {
            size = UtilFile.calcZipFileSizeInFact(file);
        } else if (file.isFile()) {
            size = file.length();
        }
        return size;
    }

    private static long calcZipFileSizeInFact(File file) {
        long size = 0L;
        ToolZip zipTool = null;
        try {
            zipTool = new ToolZip(file);
            size = zipTool.calcZipFilSizeInFact();
            if (zipTool != null) {
                zipTool.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    public static boolean isZipfile(File file) {
        ZipFile zipfile = null;
        boolean isZipFile = true;
        try {
            zipfile = new ZipFile(file);
            if (zipfile != null) {
                zipfile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isZipFile;
    }

    public static void copyFile(String src, String dest) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        File destFile = new File(dest);
        File parentFile = destFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        byte[] buf = new byte[2048];
        int len = -1;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            while ((len = fis.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File sour = new File(src);
        destFile.setLastModified(sour.lastModified());
    }

    public static File[] getChildDirAndSqlFiles(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".sql") || f.isDirectory();
            }
        });
        return files;
    }

    public static File[] getChildDir(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        return files;
    }

    public static File[] sortFileByName(File[] files) {
        if (files == null) {
            return new File[0];
        }
        List<File> list = Arrays.asList(files);
        ArrayList<File> al = new ArrayList<File>(list);
        Collections.sort(al, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f1.getName().compareTo(f2.getName());
            }
        });
        return al.toArray(new File[0]);
    }

    public static void createNullFile(String filePath) {
        FileOutputStream fos = null;
        UtilFile.createParenFileAsNeeded(new File(filePath));
        try {
            fos = new FileOutputStream(filePath);
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void createFileWithText(String text, String filePath) {
        PrintWriter pw = null;
        UtilFile.createParenFileAsNeeded(new File(filePath));
        try {
            pw = new PrintWriter(new FileOutputStream(filePath));
            pw.println(text);
            if (pw != null) {
                pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String readFileToString(String filepath) {
        File file = new File(filepath);
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK")));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        UtilFile test = new UtilFile();
        String s = UtilFile.readFileToString("c:\\test.sql");
        System.out.println(s);
    }
}

