/*
 * Decompiled with CFR 0.152.
 */
package fds.setup.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class dataConvert {
    public static String[] chineseDigits = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};

    public static String getParaValueStr(String sname) {
        if (sname == null) {
            return "";
        }
        String s = null;
        try {
            s = new String(sname.getBytes("iso-8859-1"), "GBK");
        }
        catch (Exception e) {
            s = "";
        }
        return s.trim();
    }

    public static Integer getParaValueInt(String sname) {
        Integer id = 0;
        String sid = sname != null ? sname : "0";
        try {
            id = Integer.parseInt(sid);
        }
        catch (NumberFormatException ex) {
            id = 0;
        }
        return id;
    }

    public static Short getParaValueShort(String sname) {
        Short id;
        String sid = sname != null ? sname : "0";
        try {
            id = Short.parseShort(sid);
        }
        catch (NumberFormatException ex) {
            id = 0;
        }
        return id;
    }

    public static Double getParaValueDouble(String sname) {
        Double id;
        String sid = sname != null ? sname : "0";
        try {
            id = Double.parseDouble(sid);
        }
        catch (NumberFormatException ex) {
            id = 0.0;
        }
        return id;
    }

    public static Date getParaValueDate(String sname) {
        if (sname == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (sname.trim().length() == 0) {
            return null;
        }
        try {
            return df.parse(sname);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getParaValueDTOS(Date ddate) {
        if (ddate == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.format(ddate);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getParaValueDTOS2(Date ddate) {
        if (ddate == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.format(ddate);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String amountToChinese(double amount) {
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("\u53c2\u6570\u503c\u8d85\u51fa\u5141\u8bb8\u8303\u56f4 (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount *= -1.0;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        String chineseStr = "";
        int i2 = 0;
        while (i2 < numParts) {
            String partChinese = dataConvert.partTranslate(parts[i2]);
            if (i2 % 2 == 0) {
                beforeWanIsZero = "".equals(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr = "\u4ebf" + chineseStr;
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr = "\u96f6" + chineseStr;
                    }
                    chineseStr = "\u4e07" + chineseStr;
                }
            }
            chineseStr = String.valueOf(partChinese) + chineseStr;
            ++i2;
        }
        if ("".equals(chineseStr)) {
            chineseStr = chineseDigits[0];
        } else if (negative) {
            chineseStr = "\u8d1f" + chineseStr;
        }
        chineseStr = String.valueOf(chineseStr) + "\u5143";
        chineseStr = numFen == 0 && numJiao == 0 ? String.valueOf(chineseStr) + "\u6574" : (numFen == 0 ? String.valueOf(chineseStr) + chineseDigits[numJiao] + "\u89d2" : (numJiao == 0 ? String.valueOf(chineseStr) + "\u96f6" + chineseDigits[numFen] + "\u5206" : String.valueOf(chineseStr) + chineseDigits[numJiao] + "\u89d2" + chineseDigits[numFen] + "\u5206"));
        return chineseStr;
    }

    private static String partTranslate(int amountPart) {
        if (amountPart < 0 || amountPart > 10000) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u662f\u5927\u4e8e\u7b49\u4e8e 0\uff0c\u5c0f\u4e8e 10000 \u7684\u6574\u6570\uff01");
        }
        String[] units = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
        int temp = amountPart;
        String amountStr = new Integer(amountPart).toString();
        int amountStrLength = amountStr.length();
        boolean lastIsZero = true;
        String chineseStr = "";
        int i = 0;
        while (i < amountStrLength) {
            if (temp == 0) break;
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
            } else {
                chineseStr = String.valueOf(chineseDigits[digit]) + units[i] + chineseStr;
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr;
    }

    public static String[] gb2Unicode(String[] srcAry) {
        String[] strOut = new String[srcAry.length];
        int i = 0;
        while (i < srcAry.length) {
            strOut[i] = dataConvert.gb2Unicode(srcAry[i]);
            ++i;
        }
        return strOut;
    }

    public static String gb2Unicode(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        char[] c = src.toCharArray();
        int n = c.length;
        byte[] b = new byte[n];
        int i = 0;
        while (i < n) {
            b[i] = (byte)c[i];
            ++i;
        }
        return new String(b);
    }

    public static String[] unicode2Gb(String[] srcAry) {
        String[] strOut = new String[srcAry.length];
        int i = 0;
        while (i < srcAry.length) {
            strOut[i] = dataConvert.uniCode2Gb(srcAry[i]);
            ++i;
        }
        return strOut;
    }

    public static String uniCode2Gb(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        byte[] b = src.getBytes();
        int n = b.length;
        char[] c = new char[n];
        int i = 0;
        while (i < n) {
            c[i] = (char)((short)b[i] & 0xFF);
            ++i;
        }
        return new String(c);
    }

    public static String replaceStr(String origStr, String strOld, String strNew) {
        String result = origStr;
        int index = origStr.lastIndexOf(strOld);
        if (index != -1) {
            result = origStr.substring(0, index) + strNew + origStr.substring(index + strOld.length());
        }
        return result;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replaceAllString(String source, String strReplace, String strReplaced) {
        if (dataConvert.isEmpty(source) || dataConvert.isEmpty(strReplace) || strReplaced == null) {
            return source;
        }
        StringBuffer buf = new StringBuffer(source.length());
        int start = 0;
        int end = 0;
        while ((end = source.indexOf(strReplace, start)) != -1) {
            buf.append(source.substring(start, end)).append(strReplaced);
            start = end + strReplace.length();
        }
        buf.append(source.substring(start));
        return buf.toString();
    }
}

