/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RSACipher;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

final class PreMasterSecret
extends HandshakeMessage {
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = Debug.getBooleanProperty("com.sun.net.ssl.rsaPreMasterSecretFix", false);
    ProtocolVersion protocolVersion;
    byte[] preMaster;
    byte[] encrypted;

    int messageType() {
        return 16;
    }

    PreMasterSecret(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, PublicKey publicKey) throws IOException {
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        this.preMaster = new byte[48];
        secureRandom.nextBytes(this.preMaster);
        if (rsaPreMasterSecretFix) {
            this.preMaster[0] = protocolVersion2.major;
            this.preMaster[1] = protocolVersion2.minor;
        } else {
            this.preMaster[0] = protocolVersion.major;
            this.preMaster[1] = protocolVersion.minor;
        }
        try {
            RSACipher rSACipher = RSACipher.getInstance();
            rSACipher.encryptInit(publicKey, secureRandom);
            this.encrypted = rSACipher.doEncrypt(this.preMaster, 0, this.preMaster.length);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(generalSecurityException);
        }
    }

    PreMasterSecret(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, int n, PrivateKey privateKey) throws IOException {
        boolean bl;
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = handshakeInStream.getBytes16();
        } else {
            this.encrypted = new byte[n];
            if (handshakeInStream.read(this.encrypted) != n) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            RSACipher rSACipher = RSACipher.getInstance();
            rSACipher.decryptInit(privateKey);
            this.preMaster = rSACipher.doDecrypt(this.encrypted, 0, this.encrypted.length);
            this.protocolVersion = ProtocolVersion.valueOf(this.preMaster[0], this.preMaster[1]);
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA PreMasterSecret version: " + this.protocolVersion);
            }
        }
        catch (Exception exception) {
            this.preMaster = null;
            this.protocolVersion = protocolVersion;
        }
        boolean bl2 = bl = this.protocolVersion != protocolVersion && this.protocolVersion.v != protocolVersion2.v;
        if (this.preMaster == null || this.preMaster.length != 48 || bl) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA PreMasterSecret error, generating random secret");
                if (this.preMaster != null) {
                    Debug.println(System.out, "Invalid secret", this.preMaster);
                }
            }
            this.preMaster = new byte[48];
            secureRandom.nextBytes(this.preMaster);
            this.protocolVersion = protocolVersion;
            this.preMaster[0] = protocolVersion.major;
            this.preMaster[1] = protocolVersion.minor;
        }
    }

    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            handshakeOutStream.putBytes16(this.encrypted);
        } else {
            handshakeOutStream.write(this.encrypted);
        }
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "Random Secret", this.preMaster);
        }
    }
}

