/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class JREInfo {
    private static ArrayList _jres = new ArrayList();
    private String _platform;
    private String _product;
    private String _location;
    private String _path;
    private String _osname;
    private String _osarch;
    private boolean _enabled;
    private boolean _registered;
    private boolean _system;

    public String getPlatform() {
        return this._platform;
    }

    public String getProduct() {
        return this._product;
    }

    public String getLocation() {
        return this._location;
    }

    public String getPath() {
        return this._path;
    }

    public String getDebugJavaPath() {
        return Config.getInstance().getDebugJavaPath(this._path);
    }

    public String getOSName() {
        return this._osname;
    }

    public String getOSArch() {
        return this._osarch;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isRegistered() {
        return this._registered;
    }

    public boolean isSystemJRE() {
        return this._system;
    }

    public void setPlatform(String string) {
        this._platform = string;
    }

    public void setProduct(String string) {
        this._product = string;
    }

    public void setLocation(String string) {
        this._location = string;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public void setOSName(String string) {
        this._osname = string;
    }

    public void setOSArch(String string) {
        this._osarch = string;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void setRegistered(boolean bl) {
        this._registered = bl;
    }

    public void setSystemJRE(boolean bl) {
        this._system = bl;
    }

    public JREInfo(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        this._platform = string;
        this._product = string2;
        this._location = string3;
        this._path = string4;
        this._osname = string5;
        this._osarch = string6;
        this._enabled = bl;
        this._registered = bl2;
        this._system = false;
        if (this._osname == null && this._osarch == null) {
            this._osname = Config.getOSName();
            this._osarch = Config.getOSArch();
        }
        if (this._location == null) {
            this._location = Config.getProperty("deployment.javaws.installURL");
        }
    }

    public JREInfo(int n, Properties properties, boolean bl) {
        this(properties.getProperty("deployment.javaws.jre." + n + ".platform"), properties.getProperty("deployment.javaws.jre." + n + ".product"), properties.getProperty("deployment.javaws.jre." + n + ".location"), properties.getProperty("deployment.javaws.jre." + n + ".path"), properties.getProperty("deployment.javaws.jre." + n + ".osname"), properties.getProperty("deployment.javaws.jre." + n + ".osarch"), false, false);
        String string = properties.getProperty("deployment.javaws.jre." + n + ".enabled");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            this.setEnabled(true);
        }
        if ((string = properties.getProperty("deployment.javaws.jre." + n + ".registered")) != null && Boolean.valueOf(string).booleanValue()) {
            this.setRegistered(true);
        }
        this.setSystemJRE(bl);
    }

    public JREInfo(JREInfo jREInfo) {
        this(jREInfo.getPlatform(), jREInfo.getProduct(), jREInfo.getLocation(), jREInfo.getPath(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered());
        this.setSystemJRE(jREInfo.isSystemJRE());
    }

    public static void addJRE(JREInfo jREInfo) {
        _jres.add(jREInfo);
    }

    public static void removeJRE(int n) {
        _jres.remove(n);
    }

    public static JREInfo getJREInfo(int n) {
        return (JREInfo)_jres.get(n);
    }

    public static void setJREInfo(int n, JREInfo jREInfo) {
        _jres.set(n, jREInfo);
    }

    public static void clear() {
        _jres.clear();
    }

    public static JREInfo[] get() {
        return _jres.toArray(new JREInfo[0]);
    }

    public static void initialize(Properties properties, Properties properties2) {
        Integer n;
        int n2;
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = -1;
        _jres.clear();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("deployment.javaws.jre.") || (n2 = JREInfo.getJREIndex((String)object)) < 0 || n2 == n3) continue;
            n = new Integer(n2);
            if (!arrayList.contains(n)) {
                arrayList.add(n);
                JREInfo.addJRE(new JREInfo(n2, properties2, false));
            }
            n3 = n2;
        }
        enumeration = properties.keys();
        n3 = -1;
        arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("deployment.javaws.jre.") || (n2 = JREInfo.getJREIndex((String)object)) < 0 || n2 == n3) continue;
            n = new Integer(n2);
            if (!arrayList.contains(n)) {
                arrayList.add(n);
                JREInfo.addJRE(new JREInfo(n2, properties, true));
            }
            n3 = n2;
        }
        object = JREInfo.getHomeJRE();
        if (object != null) {
            Object object2;
            n2 = 0;
            for (int i = 0; i < _jres.size(); ++i) {
                object2 = (JREInfo)_jres.get(i);
                if (!((JREInfo)object2).isSystemJRE() || ((JREInfo)object2).getPath() == null || !((JREInfo)object2).getPath().equals(((JREInfo)object).getPath())) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                JREInfo jREInfo = new JREInfo((JREInfo)object);
                jREInfo.setEnabled(true);
                jREInfo.setLocation(Config.getProperty("deployment.javaws.installURL"));
                jREInfo.setRegistered(true);
                jREInfo.setSystemJRE(true);
                object2 = Config.getProperty("deployment.version");
                if (object2 != null && ((String)object2).length() >= 3) {
                    jREInfo.setPlatform(((String)object2).substring(0, 3));
                    jREInfo.setProduct((String)object2);
                }
                JREInfo.addJRE(jREInfo);
            }
        }
    }

    private static int getJREIndex(String string) {
        int n = "deployment.javaws.jre.".length();
        int n2 = string.indexOf(".", n);
        if (n2 > n) {
            String string2 = string.substring(n, n2);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isOsInfoMatch(String string, String string2) {
        if (this._osname == null || this._osarch == null) {
            return true;
        }
        if (this._osname.equals("SunOS")) {
            return this._osname.equals(string) && this._osarch.equals(string2);
        }
        return this._osname.equals(string);
    }

    public String toString() {
        int n;
        for (n = 0; n < _jres.size() && !this.equals(_jres.get(n)); ++n) {
        }
        return (n < _jres.size() ? "JREInfo for index " + n + ":\n" : "JREInfo (not in list):\n") + "    platform is: " + this._platform + "\n" + "    product is: " + this._product + "\n" + "    location is: " + this._location + "\n" + "    path is: " + this._path + "\n" + "    osname is: " + this._osname + "\n" + "    osarch is: " + this._osarch + "\n" + "    enabled is: " + this._enabled + "\n" + "    registered is: " + this._registered + "\n" + "    system is: " + this._system + "\n" + "";
    }

    public static void printJREs() {
        for (int i = 0; i < _jres.size(); ++i) {
            Trace.println(_jres.get(i).toString());
        }
    }

    public static String getKnownPlatforms() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < _jres.size(); ++i) {
            JREInfo jREInfo = (JREInfo)_jres.get(i);
            stringBuffer.append(jREInfo.getPlatform());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getDefaultJavaPath() {
        JREInfo jREInfo = JREInfo.getHomeJRE();
        if (jREInfo != null) {
            return jREInfo.getPath();
        }
        return ((JREInfo)_jres.get(0)).getPath();
    }

    public static JREInfo getHomeJRE() {
        String string = Config.getJavaHome();
        File file = new File(string);
        for (int i = 0; i < _jres.size(); ++i) {
            File file2;
            JREInfo jREInfo = (JREInfo)_jres.get(i);
            String string2 = jREInfo.getPath();
            if (string2 == null || (file2 = new File(string2).getParentFile()) == null || !file2.getParentFile().equals(file)) continue;
            return jREInfo;
        }
        return null;
    }

    public static void removeJREsIn(String string) {
        Iterator iterator = _jres.iterator();
        while (iterator.hasNext()) {
            JREInfo jREInfo = (JREInfo)iterator.next();
            String string2 = jREInfo.getPath();
            if (string2 == null || !string2.startsWith(string)) continue;
            iterator.remove();
        }
    }
}

