/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class AdaptiveCoding
implements Constants,
CodingMethod {
    CodingMethod headCoding;
    int headLength;
    CodingMethod tailCoding;
    public static final int KX_MIN = 0;
    public static final int KX_MAX = 3;
    public static final int KX_LG2BASE = 4;
    public static final int KX_BASE = 16;
    public static final int KB_MIN = 0;
    public static final int KB_MAX = 255;
    public static final int KB_OFFSET = 1;
    public static final int KB_DEFAULT = 3;

    public AdaptiveCoding(int n, CodingMethod codingMethod, CodingMethod codingMethod2) {
        assert (AdaptiveCoding.isCodableLength(n));
        this.headLength = n;
        this.headCoding = codingMethod;
        this.tailCoding = codingMethod2;
    }

    public void setHeadCoding(CodingMethod codingMethod) {
        this.headCoding = codingMethod;
    }

    public void setHeadLength(int n) {
        assert (AdaptiveCoding.isCodableLength(n));
        this.headLength = n;
    }

    public void setTailCoding(CodingMethod codingMethod) {
        this.tailCoding = codingMethod;
    }

    public boolean isTrivial() {
        return this.headCoding == this.tailCoding;
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        int n3 = n + this.headLength;
        assert (n3 <= n2);
        this.headCoding.writeArrayTo(outputStream, nArray, n, n3);
        this.tailCoding.writeArrayTo(outputStream, nArray, n3, n2);
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        int n3 = n + this.headLength;
        assert (n3 <= n2);
        this.headCoding.readArrayFrom(inputStream, nArray, n, n3);
        this.tailCoding.readArrayFrom(inputStream, nArray, n3, n2);
    }

    static int getKXOf(int n) {
        for (int i = 0; i <= 3; ++i) {
            if ((n - 1 & 0xFFFFFF00) == 0) {
                return i;
            }
            n >>>= 4;
        }
        return -1;
    }

    static int getKBOf(int n) {
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return -1;
        }
        return (n >>>= n2 * 4) - 1;
    }

    static int decodeK(int n, int n2) {
        assert (0 <= n && n <= 3);
        assert (0 <= n2 && n2 <= 255);
        return n2 + 1 << n * 4;
    }

    static int getNextK(int n) {
        if (n <= 0) {
            return 1;
        }
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return Integer.MAX_VALUE;
        }
        int n3 = 1 << n2 * 4;
        int n4 = 255 << n2 * 4;
        int n5 = n + n3;
        if (((n5 &= ~(n3 - 1)) - n3 & ~n4) == 0) {
            assert (AdaptiveCoding.getKXOf(n5) == n2);
            return n5;
        }
        if (n2 == 3) {
            return Integer.MAX_VALUE;
        }
        int n6 = 1 << ++n2 * 4;
        int n7 = 255 << n2 * 4;
        n5 |= n4 & ~n7;
        assert (AdaptiveCoding.getKXOf(n5 += n3) == n2);
        return n5;
    }

    public static boolean isCodableLength(int n) {
        int n2 = AdaptiveCoding.getKXOf(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = 1 << n2 * 4;
        int n4 = 255 << n2 * 4;
        return (n - n3 & ~n4) == 0;
    }

    public byte[] getMetaCoding(Coding coding) {
        int n;
        int n2 = this.headLength;
        assert (AdaptiveCoding.isCodableLength(n2));
        int n3 = this.headCoding == coding ? 1 : 0;
        int n4 = n = this.tailCoding == coding ? 1 : 0;
        if (n3 + n > 1) {
            n = 0;
        }
        int n5 = 1 * n3 + 2 * n;
        assert (n5 < 3);
        int n6 = AdaptiveCoding.getKXOf(n2);
        int n7 = AdaptiveCoding.getKBOf(n2);
        assert (AdaptiveCoding.decodeK(n6, n7) == n2);
        int n8 = n7 != 3 ? 1 : 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(117 + n6 + 4 * n8 + 8 * n5);
        if (n8 != 0) {
            byteArrayOutputStream.write(n7);
        }
        try {
            if (n3 == 0) {
                byteArrayOutputStream.write(this.headCoding.getMetaCoding(coding));
            }
            if (n == 0) {
                byteArrayOutputStream.write(this.tailCoding.getMetaCoding(coding));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int parseMetaCoding(byte[] byArray, int n, Coding coding, CodingMethod[] codingMethodArray) {
        int n2;
        if ((n2 = byArray[n++] & 0xFF) < 117) {
            return n - 1;
        }
        int n3 = (n2 -= 117) % 4;
        int n4 = n2 / 4 % 2;
        int n5 = n2 / 8;
        if (n5 >= 3) {
            return n - 1;
        }
        int n6 = n5 & 1;
        int n7 = n5 & 2;
        CodingMethod[] codingMethodArray2 = new CodingMethod[]{coding};
        CodingMethod[] codingMethodArray3 = new CodingMethod[]{coding};
        int n8 = 3;
        if (n4 != 0) {
            n8 = byArray[n++] & 0xFF;
        }
        if (n6 == 0) {
            n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray2);
        }
        if (n7 == 0) {
            n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray3);
        }
        codingMethodArray[0] = new AdaptiveCoding(AdaptiveCoding.decodeK(n3, n8), codingMethodArray2[0], codingMethodArray3[0]);
        return n;
    }

    private String keyString(CodingMethod codingMethod) {
        if (codingMethod instanceof Coding) {
            return ((Coding)codingMethod).keyString();
        }
        return codingMethod.toString();
    }

    public String toString() {
        return "run(K=" + this.headLength + " A=" + this.keyString(this.headCoding) + " B=" + this.keyString(this.tailCoding) + ")";
    }
}

