/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable<Component, GridBagConstraints> comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient boolean rightToLeft = false;
    static final long serialVersionUID = 8838754796412211005L;

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private void removeConstraints(Component component) {
        this.comptable.remove(component);
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArrayArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArrayArray[1], 0, this.layoutInfo.height);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArrayArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArrayArray[1], 0, this.layoutInfo.height);
        return dArrayArray;
    }

    public Point location(int n, int n2) {
        int n3;
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n4 = this.layoutInfo.startx;
        if (!this.rightToLeft) {
            for (n3 = 0; n3 < this.layoutInfo.width && (n4 += this.layoutInfo.minWidth[n3]) <= n; ++n3) {
            }
        } else {
            for (n3 = this.layoutInfo.width - 1; n3 >= 0 && n4 <= n; n4 += this.layoutInfo.minWidth[n3], --n3) {
            }
            ++n3;
        }
        point.x = n3;
        n4 = this.layoutInfo.starty;
        for (n3 = 0; n3 < this.layoutInfo.height && (n4 += this.layoutInfo.minHeight[n3]) <= n2; ++n3) {
        }
        point.y = n3;
        return point;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a GridBagConstraint");
        }
    }

    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension minimumLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n) {
        return this.GetLayoutInfo(container, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            GridBagConstraints gridBagConstraints;
            Component component;
            int n9;
            GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo();
            Component[] componentArray = container.getComponents();
            gridBagLayoutInfo.height = 0;
            gridBagLayoutInfo.width = 0;
            int n10 = -1;
            int n11 = -1;
            int[] nArray = new int[512];
            int[] nArray2 = new int[512];
            for (n9 = 0; n9 < componentArray.length; ++n9) {
                component = componentArray[n9];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n8 = gridBagConstraints.gridx;
                n7 = gridBagConstraints.gridy;
                n6 = gridBagConstraints.gridwidth;
                if (n6 <= 0) {
                    n6 = 1;
                }
                if ((n5 = gridBagConstraints.gridheight) <= 0) {
                    n5 = 1;
                }
                if (n8 < 0 && n7 < 0) {
                    if (n11 >= 0) {
                        n7 = n11;
                    } else if (n10 >= 0) {
                        n8 = n10;
                    } else {
                        n7 = 0;
                    }
                }
                if (n8 < 0) {
                    n4 = 0;
                    for (n3 = n7; n3 < n7 + n5; ++n3) {
                        n4 = Math.max(n4, nArray[n3]);
                    }
                    if ((n8 = n4 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                } else if (n7 < 0) {
                    n2 = 0;
                    for (n3 = n8; n3 < n8 + n6; ++n3) {
                        n2 = Math.max(n2, nArray2[n3]);
                    }
                    if ((n7 = n2 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                }
                n4 = n8 + n6;
                while (gridBagLayoutInfo.width < n4) {
                    ++gridBagLayoutInfo.width;
                }
                n2 = n7 + n5;
                while (gridBagLayoutInfo.height < n2) {
                    ++gridBagLayoutInfo.height;
                }
                for (n3 = n8; n3 < n8 + n6; ++n3) {
                    nArray2[n3] = n2;
                }
                for (n3 = n7; n3 < n7 + n5; ++n3) {
                    nArray[n3] = n4;
                }
                Dimension dimension = n == 2 ? component.getPreferredSize() : component.getMinimumSize();
                gridBagConstraints.minWidth = dimension.width;
                gridBagConstraints.minHeight = dimension.height;
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n10 = -1;
                    n11 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                    n10 = n8 + n6;
                    continue;
                }
                if (gridBagConstraints.gridwidth != 0 || n10 >= 0) continue;
                n11 = n7 + n5;
            }
            if (this.columnWidths != null && gridBagLayoutInfo.width < this.columnWidths.length) {
                gridBagLayoutInfo.width = this.columnWidths.length;
            }
            if (this.rowHeights != null && gridBagLayoutInfo.height < this.rowHeights.length) {
                gridBagLayoutInfo.height = this.rowHeights.length;
            }
            n10 = -1;
            n11 = -1;
            nArray = new int[512];
            nArray2 = new int[512];
            for (n9 = 0; n9 < componentArray.length; ++n9) {
                component = componentArray[n9];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n8 = gridBagConstraints.gridx;
                n7 = gridBagConstraints.gridy;
                n6 = gridBagConstraints.gridwidth;
                n5 = gridBagConstraints.gridheight;
                if (n8 < 0 && n7 < 0) {
                    if (n11 >= 0) {
                        n7 = n11;
                    } else if (n10 >= 0) {
                        n8 = n10;
                    } else {
                        n7 = 0;
                    }
                }
                if (n8 < 0) {
                    if (n5 <= 0 && (n5 += gridBagLayoutInfo.height - n7) < 1) {
                        n5 = 1;
                    }
                    n4 = 0;
                    for (n3 = n7; n3 < n7 + n5; ++n3) {
                        n4 = Math.max(n4, nArray[n3]);
                    }
                    if ((n8 = n4 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                } else if (n7 < 0) {
                    if (n6 <= 0 && (n6 += gridBagLayoutInfo.width - n8) < 1) {
                        n6 = 1;
                    }
                    n2 = 0;
                    for (n3 = n8; n3 < n8 + n6; ++n3) {
                        n2 = Math.max(n2, nArray2[n3]);
                    }
                    if ((n7 = n2 - n7 - 1) < 0) {
                        n7 = 0;
                    }
                }
                if (n6 <= 0 && (n6 += gridBagLayoutInfo.width - n8) < 1) {
                    n6 = 1;
                }
                if (n5 <= 0 && (n5 += gridBagLayoutInfo.height - n7) < 1) {
                    n5 = 1;
                }
                n4 = n8 + n6;
                n2 = n7 + n5;
                for (n3 = n8; n3 < n8 + n6; ++n3) {
                    nArray2[n3] = n2;
                }
                for (n3 = n7; n3 < n7 + n5; ++n3) {
                    nArray[n3] = n4;
                }
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n10 = -1;
                    n11 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                    n10 = n8 + n6;
                } else if (gridBagConstraints.gridwidth == 0 && n10 < 0) {
                    n11 = n7 + n5;
                }
                gridBagConstraints.tempX = n8;
                gridBagConstraints.tempY = n7;
                gridBagConstraints.tempWidth = n6;
                gridBagConstraints.tempHeight = n5;
            }
            if (this.columnWidths != null) {
                System.arraycopy(this.columnWidths, 0, gridBagLayoutInfo.minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy(this.rowHeights, 0, gridBagLayoutInfo.minHeight, 0, this.rowHeights.length);
            }
            if (this.columnWeights != null) {
                System.arraycopy(this.columnWeights, 0, gridBagLayoutInfo.weightX, 0, Math.min(gridBagLayoutInfo.weightX.length, this.columnWeights.length));
            }
            if (this.rowWeights != null) {
                System.arraycopy(this.rowWeights, 0, gridBagLayoutInfo.weightY, 0, Math.min(gridBagLayoutInfo.weightY.length, this.rowWeights.length));
            }
            int n12 = Integer.MAX_VALUE;
            n3 = 1;
            while (n3 != Integer.MAX_VALUE) {
                for (n9 = 0; n9 < componentArray.length; ++n9) {
                    int n13;
                    double d;
                    double d2;
                    int n14;
                    double d3;
                    component = componentArray[n9];
                    if (!component.isVisible()) continue;
                    gridBagConstraints = this.lookupConstraints(component);
                    if (gridBagConstraints.tempWidth == n3) {
                        n4 = gridBagConstraints.tempX + gridBagConstraints.tempWidth;
                        d3 = gridBagConstraints.weightx;
                        for (n14 = gridBagConstraints.tempX; n14 < n4; ++n14) {
                            d3 -= gridBagLayoutInfo.weightX[n14];
                        }
                        if (d3 > 0.0) {
                            d2 = 0.0;
                            for (n14 = gridBagConstraints.tempX; n14 < n4; ++n14) {
                                d2 += gridBagLayoutInfo.weightX[n14];
                            }
                            n14 = gridBagConstraints.tempX;
                            while (d2 > 0.0 && n14 < n4) {
                                d = gridBagLayoutInfo.weightX[n14];
                                double d4 = d * d3 / d2;
                                int n15 = n14++;
                                gridBagLayoutInfo.weightX[n15] = gridBagLayoutInfo.weightX[n15] + d4;
                                d3 -= d4;
                                d2 -= d;
                            }
                            int n16 = n4 - 1;
                            gridBagLayoutInfo.weightX[n16] = gridBagLayoutInfo.weightX[n16] + d3;
                        }
                        n13 = gridBagConstraints.minWidth + gridBagConstraints.ipadx + gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                        for (n14 = gridBagConstraints.tempX; n14 < n4; ++n14) {
                            n13 -= gridBagLayoutInfo.minWidth[n14];
                        }
                        if (n13 > 0) {
                            d2 = 0.0;
                            for (n14 = gridBagConstraints.tempX; n14 < n4; ++n14) {
                                d2 += gridBagLayoutInfo.weightX[n14];
                            }
                            n14 = gridBagConstraints.tempX;
                            while (d2 > 0.0 && n14 < n4) {
                                d = gridBagLayoutInfo.weightX[n14];
                                int n17 = (int)(d * (double)n13 / d2);
                                int n18 = n14++;
                                gridBagLayoutInfo.minWidth[n18] = gridBagLayoutInfo.minWidth[n18] + n17;
                                n13 -= n17;
                                d2 -= d;
                            }
                            int n19 = n4 - 1;
                            gridBagLayoutInfo.minWidth[n19] = gridBagLayoutInfo.minWidth[n19] + n13;
                        }
                    } else if (gridBagConstraints.tempWidth > n3 && gridBagConstraints.tempWidth < n12) {
                        n12 = gridBagConstraints.tempWidth;
                    }
                    if (gridBagConstraints.tempHeight == n3) {
                        n2 = gridBagConstraints.tempY + gridBagConstraints.tempHeight;
                        d3 = gridBagConstraints.weighty;
                        for (n14 = gridBagConstraints.tempY; n14 < n2; ++n14) {
                            d3 -= gridBagLayoutInfo.weightY[n14];
                        }
                        if (d3 > 0.0) {
                            d2 = 0.0;
                            for (n14 = gridBagConstraints.tempY; n14 < n2; ++n14) {
                                d2 += gridBagLayoutInfo.weightY[n14];
                            }
                            n14 = gridBagConstraints.tempY;
                            while (d2 > 0.0 && n14 < n2) {
                                d = gridBagLayoutInfo.weightY[n14];
                                double d5 = d * d3 / d2;
                                int n20 = n14++;
                                gridBagLayoutInfo.weightY[n20] = gridBagLayoutInfo.weightY[n20] + d5;
                                d3 -= d5;
                                d2 -= d;
                            }
                            int n21 = n2 - 1;
                            gridBagLayoutInfo.weightY[n21] = gridBagLayoutInfo.weightY[n21] + d3;
                        }
                        n13 = gridBagConstraints.minHeight + gridBagConstraints.ipady + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                        for (n14 = gridBagConstraints.tempY; n14 < n2; ++n14) {
                            n13 -= gridBagLayoutInfo.minHeight[n14];
                        }
                        if (n13 <= 0) continue;
                        d2 = 0.0;
                        for (n14 = gridBagConstraints.tempY; n14 < n2; ++n14) {
                            d2 += gridBagLayoutInfo.weightY[n14];
                        }
                        n14 = gridBagConstraints.tempY;
                        while (d2 > 0.0 && n14 < n2) {
                            d = gridBagLayoutInfo.weightY[n14];
                            int n22 = (int)(d * (double)n13 / d2);
                            int n23 = n14++;
                            gridBagLayoutInfo.minHeight[n23] = gridBagLayoutInfo.minHeight[n23] + n22;
                            n13 -= n22;
                            d2 -= d;
                        }
                        int n24 = n2 - 1;
                        gridBagLayoutInfo.minHeight[n24] = gridBagLayoutInfo.minHeight[n24] + n13;
                        continue;
                    }
                    if (gridBagConstraints.tempHeight <= n3 || gridBagConstraints.tempHeight >= n12) continue;
                    n12 = gridBagConstraints.tempHeight;
                }
                n3 = n12;
                n12 = Integer.MAX_VALUE;
            }
            return gridBagLayoutInfo;
        }
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        rectangle.x = !this.rightToLeft ? (rectangle.x += gridBagConstraints.insets.left) : (rectangle.x -= rectangle.width - gridBagConstraints.insets.right);
        rectangle.width -= gridBagConstraints.insets.left + gridBagConstraints.insets.right;
        rectangle.y += gridBagConstraints.insets.top;
        rectangle.height -= gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
        int n = 0;
        if (gridBagConstraints.fill != 2 && gridBagConstraints.fill != 1 && rectangle.width > gridBagConstraints.minWidth + gridBagConstraints.ipadx) {
            n = rectangle.width - (gridBagConstraints.minWidth + gridBagConstraints.ipadx);
            rectangle.width = gridBagConstraints.minWidth + gridBagConstraints.ipadx;
        }
        int n2 = 0;
        if (gridBagConstraints.fill != 3 && gridBagConstraints.fill != 1 && rectangle.height > gridBagConstraints.minHeight + gridBagConstraints.ipady) {
            n2 = rectangle.height - (gridBagConstraints.minHeight + gridBagConstraints.ipady);
            rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
        }
        switch (gridBagConstraints.anchor) {
            case 10: {
                rectangle.x += n / 2;
                rectangle.y += n2 / 2;
                break;
            }
            case 11: 
            case 19: {
                rectangle.x += n / 2;
                break;
            }
            case 12: {
                rectangle.x += n;
                break;
            }
            case 13: {
                rectangle.x += n;
                rectangle.y += n2 / 2;
                break;
            }
            case 14: {
                rectangle.x += n;
                rectangle.y += n2;
                break;
            }
            case 15: 
            case 20: {
                rectangle.x += n / 2;
                rectangle.y += n2;
                break;
            }
            case 16: {
                rectangle.y += n2;
                break;
            }
            case 17: {
                rectangle.y += n2 / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    rectangle.x += n;
                }
                rectangle.y += n2 / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    rectangle.x += n;
                }
                rectangle.y += n2 / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                rectangle.x += n;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                rectangle.x += n;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    rectangle.x += n;
                }
                rectangle.y += n2;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    rectangle.x += n;
                }
                rectangle.y += n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        int n;
        Dimension dimension = new Dimension();
        Insets insets = container.getInsets();
        int n2 = 0;
        for (n = 0; n < gridBagLayoutInfo.width; ++n) {
            n2 += gridBagLayoutInfo.minWidth[n];
        }
        dimension.width = n2 + insets.left + insets.right;
        n2 = 0;
        for (n = 0; n < gridBagLayoutInfo.height; ++n) {
            n2 += gridBagLayoutInfo.minHeight[n];
        }
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected void ArrangeGrid(Container container) {
        int n;
        int n2;
        double d;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        boolean bl = this.rightToLeft = !container.getComponentOrientation().isLeftToRight();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        Dimension dimension = this.getMinSize(container, gridBagLayoutInfo);
        if (container.width < dimension.width || container.height < dimension.height) {
            gridBagLayoutInfo = this.getLayoutInfo(container, 1);
            dimension = this.getMinSize(container, gridBagLayoutInfo);
        }
        this.layoutInfo = gridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n3 = container.width - rectangle.width;
        if (n3 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gridBagLayoutInfo.width; ++n2) {
                d += gridBagLayoutInfo.weightX[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gridBagLayoutInfo.width; ++n2) {
                    n = (int)((double)n3 * gridBagLayoutInfo.weightX[n2] / d);
                    int n4 = n2;
                    gridBagLayoutInfo.minWidth[n4] = gridBagLayoutInfo.minWidth[n4] + n;
                    rectangle.width += n;
                    if (gridBagLayoutInfo.minWidth[n2] >= 0) continue;
                    rectangle.width -= gridBagLayoutInfo.minWidth[n2];
                    gridBagLayoutInfo.minWidth[n2] = 0;
                }
            }
            n3 = container.width - rectangle.width;
        } else {
            n3 = 0;
        }
        int n5 = container.height - rectangle.height;
        if (n5 != 0) {
            d = 0.0;
            for (n2 = 0; n2 < gridBagLayoutInfo.height; ++n2) {
                d += gridBagLayoutInfo.weightY[n2];
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < gridBagLayoutInfo.height; ++n2) {
                    n = (int)((double)n5 * gridBagLayoutInfo.weightY[n2] / d);
                    int n6 = n2;
                    gridBagLayoutInfo.minHeight[n6] = gridBagLayoutInfo.minHeight[n6] + n;
                    rectangle.height += n;
                    if (gridBagLayoutInfo.minHeight[n2] >= 0) continue;
                    rectangle.height -= gridBagLayoutInfo.minHeight[n2];
                    gridBagLayoutInfo.minHeight[n2] = 0;
                }
            }
            n5 = container.height - rectangle.height;
        } else {
            n5 = 0;
        }
        gridBagLayoutInfo.startx = n3 / 2 + insets.left;
        gridBagLayoutInfo.starty = n5 / 2 + insets.top;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (!this.rightToLeft) {
                rectangle.x = gridBagLayoutInfo.startx;
                for (n2 = 0; n2 < gridBagConstraints.tempX; ++n2) {
                    rectangle.x += gridBagLayoutInfo.minWidth[n2];
                }
            } else {
                rectangle.x = container.width - (n3 / 2 + insets.right);
                for (n2 = 0; n2 < gridBagConstraints.tempX; ++n2) {
                    rectangle.x -= gridBagLayoutInfo.minWidth[n2];
                }
            }
            rectangle.y = gridBagLayoutInfo.starty;
            for (n2 = 0; n2 < gridBagConstraints.tempY; ++n2) {
                rectangle.y += gridBagLayoutInfo.minHeight[n2];
            }
            rectangle.width = 0;
            for (n2 = gridBagConstraints.tempX; n2 < gridBagConstraints.tempX + gridBagConstraints.tempWidth; ++n2) {
                rectangle.width += gridBagLayoutInfo.minWidth[n2];
            }
            rectangle.height = 0;
            for (n2 = gridBagConstraints.tempY; n2 < gridBagConstraints.tempY + gridBagConstraints.tempHeight; ++n2) {
                rectangle.height += gridBagLayoutInfo.minHeight[n2];
            }
            this.adjustForGravity(gridBagConstraints, rectangle);
            if (rectangle.x < 0) {
                rectangle.width += rectangle.x;
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.height += rectangle.y;
                rectangle.y = 0;
            }
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                component.setBounds(0, 0, 0, 0);
                continue;
            }
            if (component.x == rectangle.x && component.y == rectangle.y && component.width == rectangle.width && component.height == rectangle.height) continue;
            component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

