/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;
    private transient boolean wildcard;
    private transient String path;

    private void init(String string) {
        if (string == null) {
            throw new NullPointerException("name can't be null");
        }
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        char c = string.charAt(n - 1);
        if (c == '*' && (n == 1 || string.charAt(n - 2) == '.')) {
            this.wildcard = true;
            this.path = n == 1 ? "" : string.substring(0, n - 1);
        } else {
            this.path = string;
        }
    }

    public BasicPermission(String string) {
        super(string);
        this.init(string);
    }

    public BasicPermission(String string, String string2) {
        super(string);
        this.init(string);
    }

    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.wildcard) {
            if (basicPermission.wildcard) {
                return basicPermission.path.startsWith(this.path);
            }
            return basicPermission.path.length() > this.path.length() && basicPermission.path.startsWith(this.path);
        }
        if (basicPermission.wildcard) {
            return false;
        }
        return this.path.equals(basicPermission.path);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)object;
        return this.getName().equals(basicPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }
}

