/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLOutputImpl
implements SQLOutput {
    private Vector attribs;
    private Map map;

    public SQLOutputImpl(Vector<?> vector, Map<String, ?> map) throws SQLException {
        if (vector == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLOutputImpl instance with null parameters");
        }
        this.attribs = vector;
        this.map = map;
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.attribs.add(string);
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.attribs.add(new Boolean(bl));
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.attribs.add(new Byte(by));
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.attribs.add(new Short(s));
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.attribs.add(new Integer(n));
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.attribs.add(new Long(l));
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.attribs.add(new Float(f));
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.attribs.add(new Double(d));
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attribs.add(bigDecimal);
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.attribs.add(byArray);
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.attribs.add(date);
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.attribs.add(time);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attribs.add(timestamp);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                String string = new String(stringBuffer);
                String string2 = bufferedReader.readLine();
                this.writeString(string.concat(string2));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                String string = new String(stringBuffer);
                String string2 = bufferedReader.readLine();
                this.writeString(string.concat(string2));
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                char c = (char)n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                String string = new String(stringBuffer);
                String string2 = bufferedReader.readLine();
                this.writeString(string.concat(string2));
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        if (sQLData == null) {
            this.attribs.add(sQLData);
            return;
        }
        this.attribs.add(new SerialStruct(sQLData, this.map));
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        if (ref == null) {
            this.attribs.add(ref);
            return;
        }
        this.attribs.add(new SerialRef(ref));
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.attribs.add(blob);
            return;
        }
        this.attribs.add(new SerialBlob(blob));
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.attribs.add(clob);
            return;
        }
        this.attribs.add(new SerialClob(clob));
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        SerialStruct serialStruct = new SerialStruct(struct, this.map);
        this.attribs.add(serialStruct);
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        if (array == null) {
            this.attribs.add(array);
            return;
        }
        this.attribs.add(new SerialArray(array, this.map));
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        if (uRL == null) {
            this.attribs.add(uRL);
            return;
        }
        this.attribs.add(new SerialDatalink(uRL));
    }
}

