/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.SwingContainerOrderFocusTraversalPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private Comparator<? super Component> comparator;
    private boolean implicitDownCycleTraversal = true;
    private Logger log = Logger.getLogger("javax.swing.SortingFocusTraversalPolicy");
    private Container cachedRoot;
    private List cachedCycle;
    private static final SwingContainerOrderFocusTraversalPolicy fitnessTestPolicy = new SwingContainerOrderFocusTraversalPolicy();

    protected SortingFocusTraversalPolicy() {
    }

    public SortingFocusTraversalPolicy(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    private void enumerateAndSortCycle(Container container, List list, Map map) {
        boolean bl;
        ArrayList<Component> arrayList = null;
        if (!container.isShowing()) {
            return;
        }
        this.enumerateCycle(container, list);
        boolean bl2 = bl = map != null && this.getImplicitDownCycleTraversal();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Will add defaults: " + bl);
        }
        if (bl) {
            arrayList = new ArrayList<Component>();
            for (Component component : list) {
                if (!(component instanceof Container) || !((Container)component).isFocusCycleRoot()) continue;
                arrayList.add(component);
            }
            Collections.sort(arrayList, this.comparator);
        }
        Collections.sort(list, this.comparator);
        if (bl) {
            Iterator iterator = arrayList.listIterator(arrayList.size());
            while (iterator.hasPrevious()) {
                Component component;
                component = (Container)iterator.previous();
                Component component2 = ((Container)component).getFocusTraversalPolicy().getDefaultComponent((Container)component);
                if (component2 == null || !component2.isShowing()) continue;
                int n = Collections.binarySearch(list, component, this.comparator);
                if (n < 0) {
                    n = -n - 2;
                }
                map.put(new Integer(n), component2);
            }
        }
    }

    private void enumerateCycle(Container container, List list) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        list.add(container);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(!(component instanceof Container) || ((Container)component).isFocusTraversalPolicyProvider() || ((Container)component).isFocusCycleRoot() || component instanceof JComponent && ((JComponent)component).isManagingFocus())) {
                this.enumerateCycle((Container)component, list);
                continue;
            }
            list.add(component);
        }
    }

    Container getTopmostProvider(Container container, Component component) {
        Container container2;
        Container container3 = null;
        for (container2 = component.getParent(); container2 != container && container2 != null; container2 = container2.getParent()) {
            if (!container2.isFocusTraversalPolicyProvider()) continue;
            container3 = container2;
        }
        if (container2 == null) {
            return null;
        }
        return container3;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        Component component2;
        Component component3;
        int n;
        Object object;
        Serializable serializable;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Searching in " + container.getName() + " for component after " + component.getName());
        }
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container container2 = this.getTopmostProvider(container, component);
        if (container2 != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Asking FTP " + container2.getName() + " for component after " + component.getName());
            }
            if ((serializable = ((FocusTraversalPolicy)(object = container2.getFocusTraversalPolicy())).getComponentAfter(container2, component)) == ((FocusTraversalPolicy)object).getFirstComponent(container2)) {
                serializable = null;
            }
            if (serializable != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("### FTP returned " + ((Component)serializable).getName());
                }
                return serializable;
            }
            component = container2;
        }
        object = new ArrayList();
        serializable = new HashMap();
        this.enumerateAndSortCycle(container, (List)object, (Map)((Object)serializable));
        try {
            n = Collections.binarySearch(object, component, this.comparator);
        }
        catch (ClassCastException classCastException) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Didn't find component " + component.getName() + " in a cycle " + container.getName());
            }
            return this.getFirstComponent(container);
        }
        if (n < 0) {
            n = -n - 2;
        }
        if ((component3 = (Component)serializable.get(new Integer(n))) != null) {
            return component3;
        }
        do {
            if (++n >= object.size()) {
                if (container.isFocusCycleRoot()) {
                    this.cachedRoot = container;
                    this.cachedCycle = object;
                    component2 = this.getFirstComponent(container);
                    this.cachedRoot = null;
                    this.cachedCycle = null;
                    return component2;
                }
                return null;
            }
            component2 = (Component)object.get(n);
            if (!this.accept(component2)) continue;
            return component2;
        } while (!(component2 instanceof Container) || !((Container)component2).isFocusTraversalPolicyProvider());
        return ((Container)component2).getFocusTraversalPolicy().getDefaultComponent((Container)component2);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        Component component2;
        int n;
        Object object;
        Serializable serializable;
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container container2 = this.getTopmostProvider(container, component);
        if (container2 != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Asking FTP " + container2.getName() + " for component after " + component.getName());
            }
            if ((serializable = ((FocusTraversalPolicy)(object = container2.getFocusTraversalPolicy())).getComponentBefore(container2, component)) == ((FocusTraversalPolicy)object).getLastComponent(container2)) {
                serializable = null;
            }
            if (serializable != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("### FTP returned " + ((Component)serializable).getName());
                }
                return serializable;
            }
            component = container2;
        }
        object = new ArrayList();
        serializable = new HashMap();
        this.enumerateAndSortCycle(container, (List)object, (Map)((Object)serializable));
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Cycle is " + object + ", component is " + component);
        }
        try {
            n = Collections.binarySearch(object, component, this.comparator);
        }
        catch (ClassCastException classCastException) {
            return this.getLastComponent(container);
        }
        n = n < 0 ? -n - 2 : --n;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Index is " + n);
        }
        if (n >= 0 && (component2 = (Component)serializable.get(new Integer(n))) != null && object.get(n) != container) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Returning default " + component2.getName() + " at " + n);
            }
            return component2;
        }
        while (true) {
            if (n < 0) {
                this.cachedRoot = container;
                this.cachedCycle = object;
                component2 = this.getLastComponent(container);
                this.cachedRoot = null;
                this.cachedCycle = null;
                return component2;
            }
            component2 = (Component)object.get(n);
            if (this.accept(component2)) {
                return component2;
            }
            if (component2 instanceof Container && ((Container)component2).isFocusTraversalPolicyProvider()) {
                return ((Container)component2).getFocusTraversalPolicy().getLastComponent((Container)component2);
            }
            --n;
        }
    }

    @Override
    public Component getFirstComponent(Container container) {
        ArrayList arrayList;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Getting first component in " + container.getName());
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (this.cachedRoot == container) {
            arrayList = this.cachedCycle;
        } else {
            arrayList = new ArrayList();
            this.enumerateAndSortCycle(container, arrayList, null);
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = (Component)arrayList.get(i);
            if (this.accept(component)) {
                return component;
            }
            if (!(component instanceof Container) || component == container || !((Container)component).isFocusTraversalPolicyProvider()) continue;
            return ((Container)component).getFocusTraversalPolicy().getDefaultComponent((Container)component);
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container container) {
        ArrayList arrayList;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Getting last component in " + container.getName());
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (this.cachedRoot == container) {
            arrayList = this.cachedCycle;
        } else {
            arrayList = new ArrayList();
            this.enumerateAndSortCycle(container, arrayList, null);
        }
        int n = arrayList.size();
        if (n == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("### Cycle is " + arrayList);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Component component = (Component)arrayList.get(i);
            if (this.accept(component)) {
                return component;
            }
            if (!(component instanceof Container) || component == container || !((Container)component).isFocusTraversalPolicyProvider()) continue;
            return ((Container)component).getFocusTraversalPolicy().getLastComponent((Container)component);
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected void setComparator(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    protected Comparator<? super Component> getComparator() {
        return this.comparator;
    }

    protected boolean accept(Component component) {
        return fitnessTestPolicy.accept(component);
    }
}

