/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    private int justification;
    private float lineSpacing;
    protected int firstLineIndent = 0;
    private int tabBase;
    static Class i18nStrategy;
    static char[] tabChars;
    static char[] tabDecimalChars;

    public ParagraphView(Element element) {
        super(element, 1);
        this.setPropertiesFromAttributes();
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE)) {
            try {
                String string;
                if (i18nStrategy == null) {
                    string = "javax.swing.text.TextLayoutStrategy";
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    i18nStrategy = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                }
                if ((string = i18nStrategy.newInstance()) instanceof FlowView.FlowStrategy) {
                    this.strategy = (FlowView.FlowStrategy)((Object)string);
                }
            }
            catch (Throwable throwable) {
                throw new StateInvariantError("ParagraphView: Can't create i18n strategy: " + throwable.getMessage());
            }
        }
    }

    protected void setJustification(int n) {
        this.justification = n;
    }

    protected void setLineSpacing(float f) {
        this.lineSpacing = f;
    }

    protected void setFirstLineIndent(float f) {
        this.firstLineIndent = (int)f;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            Document document;
            Object object;
            this.setParagraphInsets(attributeSet);
            Integer n = (Integer)attributeSet.getAttribute(StyleConstants.Alignment);
            int n2 = n == null ? ((object = (document = this.getElement().getDocument()).getProperty(TextAttribute.RUN_DIRECTION)) != null && object.equals(TextAttribute.RUN_DIRECTION_RTL) ? 2 : 0) : n;
            this.setJustification(n2);
            this.setLineSpacing(StyleConstants.getLineSpacing(attributeSet));
            this.setFirstLineIndent(StyleConstants.getFirstLineIndent(attributeSet));
        }
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.getViewCount();
    }

    protected View getLayoutView(int n) {
        return this.layoutPool.getView(n);
    }

    protected void adjustRow(Row row, int n, int n2) {
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        Point point;
        int n4;
        if (n == -1) {
            n4 = n2 == 1 ? this.getViewCount() - 1 : 0;
        } else {
            n4 = bias == Position.Bias.Backward && n > 0 ? this.getViewIndexAtPosition(n - 1) : this.getViewIndexAtPosition(n);
            if (n2 == 1) {
                if (n4 == 0) {
                    return -1;
                }
                --n4;
            } else if (++n4 >= this.getViewCount()) {
                return -1;
            }
        }
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Caret caret = jTextComponent.getCaret();
        Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
        if (point == null) {
            Rectangle rectangle;
            try {
                rectangle = jTextComponent.getUI().modelToView(jTextComponent, n, bias);
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            n3 = rectangle == null ? 0 : rectangle.getBounds().x;
        } else {
            n3 = point.x;
        }
        return this.getClosestPositionTo(n, bias, shape, n2, biasArray, n4, n3);
    }

    protected int getClosestPositionTo(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Document document = this.getDocument();
        AbstractDocument abstractDocument = document instanceof AbstractDocument ? (AbstractDocument)document : null;
        View view = this.getView(n3);
        int n5 = -1;
        biasArray[0] = Position.Bias.Forward;
        int n6 = view.getViewCount();
        for (int i = 0; i < n6; ++i) {
            boolean bl;
            View view2 = view.getView(i);
            int n7 = view2.getStartOffset();
            boolean bl2 = bl = abstractDocument != null ? abstractDocument.isLeftToRight(n7, n7 + 1) : true;
            if (bl) {
                int n8 = view2.getEndOffset();
                for (n5 = n7; n5 < n8; ++n5) {
                    float f = jTextComponent.modelToView((int)n5).getBounds().x;
                    if (!(f >= (float)n4)) continue;
                    while (++n5 < n8 && (float)jTextComponent.modelToView((int)n5).getBounds().x == f) {
                    }
                    return --n5;
                }
                --n5;
                continue;
            }
            for (n5 = view2.getEndOffset() - 1; n5 >= n7; --n5) {
                float f = jTextComponent.modelToView((int)n5).getBounds().x;
                if (!(f >= (float)n4)) continue;
                while (--n5 >= n7 && (float)jTextComponent.modelToView((int)n5).getBounds().x == f) {
                }
                return ++n5;
            }
            ++n5;
        }
        if (n5 == -1) {
            return this.getStartOffset();
        }
        return n5;
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        Document document = this.getDocument();
        return document instanceof AbstractDocument && !((AbstractDocument)document).isLeftToRight(this.getStartOffset(), this.getStartOffset() + 1);
    }

    public int getFlowSpan(int n) {
        View view = this.getView(n);
        int n2 = 0;
        if (view instanceof Row) {
            Row row = (Row)view;
            n2 = row.getLeftInset() + row.getRightInset();
        }
        int n3 = this.layoutSpan - n2;
        return n3;
    }

    public int getFlowStart(int n) {
        View view = this.getView(n);
        int n2 = 0;
        if (view instanceof Row) {
            Row row = (Row)view;
            n2 = row.getLeftInset();
        }
        return this.tabBase + n2;
    }

    protected View createRow() {
        return new Row(this.getElement());
    }

    public float nextTabStop(float f, int n) {
        int n2;
        if (this.justification != 0) {
            return f + 10.0f;
        }
        f -= (float)this.tabBase;
        TabSet tabSet = this.getTabSet();
        if (tabSet == null) {
            return this.tabBase + ((int)f / 72 + 1) * 72;
        }
        TabStop tabStop = tabSet.getTabAfter(f + 0.01f);
        if (tabStop == null) {
            return (float)this.tabBase + f + 5.0f;
        }
        int n3 = tabStop.getAlignment();
        switch (n3) {
            default: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 5: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 1: 
            case 2: {
                n2 = this.findOffsetToCharactersInString(tabChars, n + 1);
                break;
            }
            case 4: {
                n2 = this.findOffsetToCharactersInString(tabDecimalChars, n + 1);
            }
        }
        if (n2 == -1) {
            n2 = this.getEndOffset();
        }
        float f2 = this.getPartialSize(n + 1, n2);
        switch (n3) {
            case 1: 
            case 4: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2);
            }
            case 2: {
                return (float)this.tabBase + Math.max(f, tabStop.getPosition() - f2 / 2.0f);
            }
        }
        return f;
    }

    protected TabSet getTabSet() {
        return StyleConstants.getTabSet(this.getElement().getAttributes());
    }

    protected float getPartialSize(int n, int n2) {
        float f = 0.0f;
        int n3 = this.getViewCount();
        int n4 = this.getElement().getElementIndex(n);
        n3 = this.layoutPool.getViewCount();
        while (n < n2 && n4 < n3) {
            View view = this.layoutPool.getView(n4++);
            int n5 = view.getEndOffset();
            int n6 = Math.min(n2, n5);
            if (view instanceof TabableView) {
                f += ((TabableView)((Object)view)).getPartialSpan(n, n6);
            } else if (n == view.getStartOffset() && n6 == view.getEndOffset()) {
                f += view.getPreferredSpan(0);
            } else {
                return 0.0f;
            }
            n = n5;
        }
        return f;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n) {
        int n2 = cArray.length;
        int n3 = this.getEndOffset();
        Segment segment = new Segment();
        try {
            this.getDocument().getText(n, n3 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int n4 = segment.offset + segment.count;
        for (int i = segment.offset; i < n4; ++i) {
            char c = segment.array[i];
            for (int j = 0; j < n2; ++j) {
                if (c != cArray[j]) continue;
                return i - segment.offset + n;
            }
        }
        return -1;
    }

    protected float getTabBase() {
        return this.tabBase;
    }

    public void paint(Graphics graphics, Shape shape) {
        Shape shape2;
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.tabBase = rectangle.x + this.getLeftInset();
        super.paint(graphics, shape);
        if (this.firstLineIndent < 0 && (shape2 = this.getChildAllocation(0, shape)) != null && shape2.intersects(rectangle)) {
            int n = rectangle.x + this.getLeftInset() + this.firstLineIndent;
            int n2 = rectangle.y + this.getTopInset();
            Rectangle rectangle2 = graphics.getClipBounds();
            this.tempRect.x = n + this.getOffset(0, 0);
            this.tempRect.y = n2 + this.getOffset(1, 0);
            this.tempRect.width = this.getSpan(0, 0) - this.firstLineIndent;
            this.tempRect.height = this.getSpan(1, 0);
            if (this.tempRect.intersects(rectangle2)) {
                this.tempRect.x -= this.firstLineIndent;
                this.paintChild(graphics, this.tempRect, 0);
            }
        }
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                float f = 0.5f;
                if (this.getViewCount() != 0) {
                    int n2 = (int)this.getPreferredSpan(1);
                    View view = this.getView(0);
                    int n3 = (int)view.getPreferredSpan(1);
                    f = n2 != 0 ? (float)(n3 / 2) / (float)n2 : 0.0f;
                }
                return f;
            }
            case 0: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public View breakView(int n, float f, Shape shape) {
        if (n == 1) {
            if (shape != null) {
                Rectangle rectangle = shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
            }
            return this;
        }
        return this;
    }

    public int getBreakWeight(int n, float f) {
        if (n == 1) {
            return 0;
        }
        return 0;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.setPropertiesFromAttributes();
        this.layoutChanged(0);
        this.layoutChanged(1);
        super.changedUpdate(documentEvent, shape, viewFactory);
    }

    static {
        tabChars = new char[1];
        ParagraphView.tabChars[0] = 9;
        tabDecimalChars = new char[2];
        ParagraphView.tabDecimalChars[0] = 9;
        ParagraphView.tabDecimalChars[1] = 46;
    }

    class Row
    extends BoxView {
        static final int SPACE_ADDON = 0;
        static final int START_JUSTIFIABLE = 1;
        static final int END_JUSTIFIABLE = 2;
        int[] justificationData;

        Row(Element element) {
            super(element, 0);
            this.justificationData = null;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public float getAlignment(int n) {
            if (n == 0) {
                switch (ParagraphView.this.justification) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: 
                    case 3: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(n);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            View view = this.getViewAtPosition(n, rectangle);
            if (view != null && !view.getElement().isLeaf()) {
                return super.modelToView(n, shape, bias);
            }
            rectangle = shape.getBounds();
            int n2 = rectangle.height;
            int n3 = rectangle.y;
            Shape shape2 = super.modelToView(n, shape, bias);
            rectangle = shape2.getBounds();
            rectangle.height = n2;
            rectangle.y = n3;
            return rectangle;
        }

        public int getStartOffset() {
            int n = Integer.MAX_VALUE;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                n = Math.min(n, view.getStartOffset());
            }
            return n;
        }

        public int getEndOffset() {
            int n = 0;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                n = Math.max(n, view.getEndOffset());
            }
            return n;
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            this.baselineLayout(n, n2, nArray, nArray2);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            return this.baselineRequirements(n, sizeRequirements);
        }

        boolean isJustifyEnabled() {
            boolean bl = ParagraphView.this.justification == 3;
            bl = bl && !Boolean.TRUE.equals(this.getDocument().getProperty("i18n"));
            return bl;
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            int[] nArray = this.justificationData;
            this.justificationData = null;
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
            if (this.isJustifyEnabled()) {
                this.justificationData = nArray;
            }
            return sizeRequirements2;
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3;
            int n42;
            int[] nArray3 = this.justificationData;
            this.justificationData = null;
            super.layoutMajorAxis(n, n2, nArray, nArray2);
            if (!this.isJustifyEnabled()) {
                return;
            }
            int n5 = 0;
            for (int n42 : nArray2) {
                n5 += n42;
            }
            if (n5 == n) {
                return;
            }
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            n42 = 0;
            for (n3 = this.getViewCount() - 1; n3 >= 0; --n3) {
                View view = this.getView(n3);
                if (!(view instanceof GlyphView)) continue;
                GlyphView.JustificationInfo justificationInfo = ((GlyphView)view).getJustificationInfo();
                if (justificationInfo.start >= 0) {
                    n7 = justificationInfo.start;
                    n6 += n42;
                }
                if (justificationInfo.end >= 0) {
                    n8 = justificationInfo.end;
                } else {
                    n6 += justificationInfo.trailingSpaces;
                }
                n6 += justificationInfo.contentSpaces;
                n42 = justificationInfo.leadingSpaces;
                if (justificationInfo.hasTab) break;
            }
            int n9 = n3 = n6 > 0 ? (n - n5) / n6 : 0;
            if (n3 > 0) {
                this.justificationData = nArray3 != null ? nArray3 : new int[3];
                this.justificationData[0] = n3;
                this.justificationData[1] = n7;
                this.justificationData[2] = n8;
                super.layoutMajorAxis(n, n2, nArray, nArray2);
            }
        }

        public float getMaximumSpan(int n) {
            float f = 0 == n && this.isJustifyEnabled() ? Float.MAX_VALUE : super.getMaximumSpan(n);
            return f;
        }

        protected int getViewIndexAtPosition(int n) {
            if (n < this.getStartOffset() || n >= this.getEndOffset()) {
                return -1;
            }
            for (int i = this.getViewCount() - 1; i >= 0; --i) {
                View view = this.getView(i);
                if (n < view.getStartOffset() || n >= view.getEndOffset()) continue;
                return i;
            }
            return -1;
        }

        protected short getLeftInset() {
            int n = 0;
            View view = this.getParent();
            if (view != null && this == view.getView(0)) {
                n = ParagraphView.this.firstLineIndent;
            }
            return (short)(super.getLeftInset() + n);
        }

        protected short getBottomInset() {
            return (short)((float)super.getBottomInset() + (float)(this.minorRequest != null ? this.minorRequest.preferred : 0) * ParagraphView.this.lineSpacing);
        }
    }
}

