/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.ietf.jgss.MessageProp;

public class TokenTracker {
    static final int MAX_INTERVALS = 5;
    private int initNumber;
    private int windowStart;
    private int expectedNumber;
    private int windowStartIndex = 0;
    private LinkedList list = new LinkedList();

    public TokenTracker(int n) {
        this.initNumber = n;
        this.windowStart = n;
        this.expectedNumber = n;
        Entry entry = new Entry(n - 1);
        this.list.add(entry);
    }

    private int getIntervalIndex(int n) {
        int n2;
        Entry entry = null;
        for (n2 = this.list.size() - 1; n2 >= 0 && (entry = (Entry)this.list.get(n2)).compareTo(n) > 0; --n2) {
        }
        return n2;
    }

    public final synchronized void getProps(int n, MessageProp messageProp) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this.getIntervalIndex(n);
        Entry entry = null;
        if (n2 != -1) {
            entry = (Entry)this.list.get(n2);
        }
        if (n == this.expectedNumber) {
            ++this.expectedNumber;
        } else if (entry != null && entry.contains(n)) {
            bl4 = true;
        } else if (this.expectedNumber >= this.initNumber) {
            if (n > this.expectedNumber) {
                bl = true;
            } else if (n >= this.windowStart) {
                bl3 = true;
            } else if (n >= this.initNumber) {
                bl2 = true;
            } else {
                bl = true;
            }
        } else if (n > this.expectedNumber) {
            if (n < this.initNumber) {
                bl = true;
            } else if (this.windowStart >= this.initNumber) {
                if (n >= this.windowStart) {
                    bl3 = true;
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        } else if (this.windowStart > this.expectedNumber) {
            bl3 = true;
        } else if (n < this.windowStart) {
            bl2 = true;
        } else {
            bl3 = true;
        }
        if (!bl4 && !bl2) {
            this.add(n, n2);
        }
        if (bl) {
            this.expectedNumber = n + 1;
        }
        messageProp.setSupplementaryStates(bl4, bl2, bl3, bl, 0, null);
    }

    private void add(int n, int n2) {
        Entry entry;
        int n3;
        Entry entry2 = null;
        Entry entry3 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 != -1 && n == (entry2 = (Entry)this.list.get(n2)).getEnd() + 1) {
            entry2.setEnd(n);
            bl = true;
        }
        if ((n3 = n2 + 1) < this.list.size() && n == (entry3 = (Entry)this.list.get(n3)).getStart() - 1) {
            if (!bl) {
                entry3.setStart(n);
            } else {
                entry3.setStart(entry2.getStart());
                this.list.remove(n2);
                if (this.windowStartIndex > n2) {
                    --this.windowStartIndex;
                }
            }
            bl2 = true;
        }
        if (bl2 || bl) {
            return;
        }
        if (this.list.size() < 5) {
            entry = new Entry(n);
            if (n2 < this.windowStartIndex) {
                ++this.windowStartIndex;
            }
        } else {
            int n4 = this.windowStartIndex;
            if (this.windowStartIndex == this.list.size() - 1) {
                this.windowStartIndex = 0;
            }
            entry = (Entry)this.list.remove(n4);
            this.windowStart = ((Entry)this.list.get(this.windowStartIndex)).getStart();
            entry.setStart(n);
            entry.setEnd(n);
            if (n2 >= n4) {
                --n2;
            } else if (n4 != this.windowStartIndex) {
                if (n2 == -1) {
                    this.windowStart = n;
                }
            } else {
                ++this.windowStartIndex;
            }
        }
        this.list.add(n2 + 1, entry);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TokenTracker: ");
        stringBuffer.append(" initNumber=").append(this.initNumber);
        stringBuffer.append(" windowStart=").append(this.windowStart);
        stringBuffer.append(" expectedNumber=").append(this.expectedNumber);
        stringBuffer.append(" windowStartIndex=").append(this.windowStartIndex);
        stringBuffer.append("\n\tIntervals are: {");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.list.get(i).toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Enter expected starting sequence number: ");
        int n = Integer.parseInt(bufferedReader.readLine());
        MessageProp messageProp = new MessageProp(0, true);
        TokenTracker tokenTracker = new TokenTracker(n);
        System.out.println("Now enter actual received sequence numbers and watch the list and the MessageProp:");
        while (true) {
            n = Integer.parseInt(bufferedReader.readLine());
            try {
                tokenTracker.getProps(n, messageProp);
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.out.println(tokenTracker);
                throw exception;
            }
            System.out.println(messageProp);
            System.out.println(tokenTracker);
            System.out.println("");
        }
    }

    class Entry {
        private int start;
        private int end;

        Entry(int n) {
            this.start = n;
            this.end = n;
        }

        final int compareTo(int n) {
            if (this.start > n) {
                return 1;
            }
            if (this.end < n) {
                return -1;
            }
            return 0;
        }

        final boolean contains(int n) {
            return n >= this.start && n <= this.end;
        }

        final void append(int n) {
            if (n == this.end + 1) {
                this.end = n;
            }
        }

        final void setInterval(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        final void setEnd(int n) {
            this.end = n;
        }

        final void setStart(int n) {
            this.start = n;
        }

        final int getStart() {
            return this.start;
        }

        final int getEnd() {
            return this.end;
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + "]";
        }
    }
}

