/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.internal.ASRep;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.EncASRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerValue;

public class KrbAsRep
extends KrbKdcRep {
    private ASRep rep;
    private Credentials creds;
    private boolean DEBUG = Krb5.DEBUG;

    KrbAsRep(byte[] byArray, EncryptionKey[] encryptionKeyArray, KrbAsReq krbAsReq) throws KrbException, Asn1Exception, IOException {
        if (encryptionKeyArray == null) {
            throw new KrbException(400);
        }
        DerValue derValue = new DerValue(byArray);
        ASReq aSReq = krbAsReq.getMessage();
        ASRep aSRep = null;
        try {
            aSRep = new ASRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            aSRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = null;
            if (kRBError.eText != null && kRBError.eText.length() > 0) {
                string = kRBError.eText.charAt(kRBError.eText.length() - 1) == '\u0000' ? kRBError.eText.substring(0, kRBError.eText.length() - 1) : kRBError.eText;
            }
            KrbException krbException = string == null ? new KrbException(kRBError.errorCode) : new KrbException(kRBError.errorCode, string);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        int n = aSRep.encPart.getEType();
        EncryptionKey encryptionKey = EncryptionKey.findKey(n, encryptionKeyArray);
        if (encryptionKey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AS REP - " + EType.toString(n));
        }
        byte[] byArray2 = aSRep.encPart.decrypt(encryptionKey, 3);
        byte[] byArray3 = aSRep.encPart.reset(byArray2, true);
        derValue = new DerValue(byArray3);
        EncASRepPart encASRepPart = new EncASRepPart(derValue);
        aSRep.ticket.sname.setRealm(aSRep.ticket.realm);
        aSRep.encKDCRepPart = encASRepPart;
        KrbAsRep.check(aSReq, aSRep);
        this.creds = new Credentials(aSRep.ticket, aSReq.reqBody.cname, aSRep.ticket.sname, encASRepPart.key, encASRepPart.flags, encASRepPart.authtime, encASRepPart.starttime, encASRepPart.endtime, encASRepPart.renewTill, encASRepPart.caddr);
        if (this.DEBUG) {
            System.out.println(">>> KrbAsRep cons in KrbAsReq.getReply " + aSReq.reqBody.cname.getNameString());
        }
        this.rep = aSRep;
        this.creds = this.creds;
    }

    public Credentials getCreds() {
        return this.creds;
    }

    public sun.security.krb5.internal.ccache.Credentials setCredentials() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep);
    }
}

