/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAEncTSEnc;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbAsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;
    private static KDCOptions defaultKDCOptions = new KDCOptions();

    KrbAsReq(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws KrbException, IOException {
        this(encryptionKeyArray, defaultKDCOptions, principalName, null, null, null, null, null, null, null);
    }

    private static int[] getETypesFromKeys(EncryptionKey[] encryptionKeyArray) {
        int[] nArray = new int[encryptionKeyArray.length];
        for (int i = 0; i < encryptionKeyArray.length; ++i) {
            nArray[i] = encryptionKeyArray[i].getEType();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsReq(char[] cArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        EncryptionKey[] encryptionKeyArray = null;
        if (cArray != null) {
            encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, principalName.getSalt());
        }
        if (this.DEBUG) {
            System.out.println(">>>KrbAsReq salt is " + principalName.getSalt());
        }
        try {
            this.init(encryptionKeyArray, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
        }
        finally {
            if (encryptionKeyArray != null) {
                for (int i = 0; i < encryptionKeyArray.length; ++i) {
                    encryptionKeyArray[i].destroy();
                }
            }
        }
    }

    public KrbAsReq(EncryptionKey[] encryptionKeyArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        this.init(encryptionKeyArray, kDCOptions, principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
    }

    private void init(EncryptionKey[] encryptionKeyArray, KDCOptions kDCOptions, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws KrbException, IOException {
        if (kDCOptions.get(2) || kDCOptions.get(4) || kDCOptions.get(28) || kDCOptions.get(30) || kDCOptions.get(31)) {
            throw new KrbException(101);
        }
        if (!kDCOptions.get(6) && kerberosTime != null) {
            kerberosTime = null;
        }
        if (!kDCOptions.get(8) && kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        this.princName = principalName;
        int[] nArray2 = EType.getDefaults("default_tkt_enctypes", encryptionKeyArray);
        EncryptionKey encryptionKey = EncryptionKey.findKey(nArray2[0], encryptionKeyArray);
        PAData[] pADataArray = null;
        PAEncTSEnc pAEncTSEnc = new PAEncTSEnc();
        byte[] byArray = pAEncTSEnc.asn1Encode();
        if (encryptionKey != null) {
            EncryptedData encryptedData = new EncryptedData(encryptionKey, byArray, 1);
            pADataArray = new PAData[]{new PAData(2, encryptedData.asn1Encode())};
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq calling createMessage");
        }
        if (nArray == null) {
            nArray = nArray2;
        }
        this.asReqMessg = this.createMessage(pADataArray, kDCOptions, principalName, principalName.getRealm(), principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, ticketArray);
        this.obuf = this.asReqMessg.asn1Encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsRep getReply(char[] cArray) throws KrbException, IOException {
        if (cArray == null) {
            throw new KrbException(400);
        }
        KrbAsRep krbAsRep = null;
        EncryptionKey[] encryptionKeyArray = null;
        try {
            encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, this.princName.getSalt());
            krbAsRep = this.getReply(encryptionKeyArray);
        }
        finally {
            if (encryptionKeyArray != null) {
                for (int i = 0; i < encryptionKeyArray.length; ++i) {
                    encryptionKeyArray[i].destroy();
                }
            }
        }
        return krbAsRep;
    }

    public String send() throws IOException, KrbException {
        String string = null;
        if (this.princName != null) {
            string = this.princName.getRealmString();
        }
        return this.send(string);
    }

    public KrbAsRep getReply(EncryptionKey[] encryptionKeyArray) throws KrbException, IOException {
        return new KrbAsRep(this.ibuf, encryptionKeyArray, this);
    }

    private ASReq createMessage(PAData[] pADataArray, KDCOptions kDCOptions, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, Ticket[] ticketArray) throws Asn1Exception, KrbApErrException, RealmException, UnknownHostException, IOException {
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq in createMessage");
        }
        PrincipalName principalName3 = null;
        if (principalName2 == null) {
            if (realm == null) {
                throw new RealmException(601, "default realm not specified ");
            }
            principalName3 = new PrincipalName("krbtgt/" + realm.toString(), 0);
        } else {
            principalName3 = principalName2;
        }
        KerberosTime kerberosTime4 = null;
        kerberosTime4 = kerberosTime2 == null ? new KerberosTime() : kerberosTime2;
        KDCReqBody kDCReqBody = new KDCReqBody(kDCOptions, principalName, realm, principalName3, kerberosTime, kerberosTime4, kerberosTime3, Nonce.value(), nArray, hostAddresses, null, ticketArray);
        return new ASReq(pADataArray, kDCReqBody);
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

