/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.internal.EncTGSRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.TGSRep;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerValue;

public class KrbTgsRep
extends KrbKdcRep {
    private TGSRep rep;
    private Credentials creds;
    private Ticket secondTicket;
    private static final boolean DEBUG = Krb5.DEBUG;

    KrbTgsRep(byte[] byArray, KrbTgsReq krbTgsReq) throws KrbException, IOException {
        DerValue derValue = new DerValue(byArray);
        TGSReq tGSReq = krbTgsReq.getMessage();
        TGSRep tGSRep = null;
        try {
            tGSRep = new TGSRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            tGSRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = null;
            if (kRBError.eText != null && kRBError.eText.length() > 0) {
                string = kRBError.eText.charAt(kRBError.eText.length() - 1) == '\u0000' ? kRBError.eText.substring(0, kRBError.eText.length() - 1) : kRBError.eText;
            }
            KrbException krbException = string == null ? new KrbException(kRBError.errorCode) : new KrbException(kRBError.errorCode, string);
            krbException.initCause(asn1Exception);
            throw krbException;
        }
        byte[] byArray2 = tGSRep.encPart.decrypt(krbTgsReq.tgsReqKey, krbTgsReq.usedSubkey() ? 9 : 8);
        byte[] byArray3 = tGSRep.encPart.reset(byArray2, true);
        derValue = new DerValue(byArray3);
        EncTGSRepPart encTGSRepPart = new EncTGSRepPart(derValue);
        tGSRep.ticket.sname.setRealm(tGSRep.ticket.realm);
        tGSRep.encKDCRepPart = encTGSRepPart;
        KrbTgsRep.check(tGSReq, tGSRep);
        this.creds = new Credentials(tGSRep.ticket, tGSReq.reqBody.cname, tGSRep.ticket.sname, encTGSRepPart.key, encTGSRepPart.flags, encTGSRepPart.authtime, encTGSRepPart.starttime, encTGSRepPart.endtime, encTGSRepPart.renewTill, encTGSRepPart.caddr);
        this.rep = tGSRep;
        this.creds = this.creds;
        this.secondTicket = krbTgsReq.getSecondTicket();
    }

    public Credentials getCreds() {
        return this.creds;
    }

    sun.security.krb5.internal.ccache.Credentials setCredentials() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep, this.secondTicket);
    }
}

