/*
 * Decompiled with CFR 0.152.
 */
package com.best108.atom_animation_reader.impl;

import com.best108.atom_animation_reader.IAtomAnimation;
import com.best108.atom_animation_reader.IAtomAnimationBuilder;
import com.best108.atom_animation_reader.IModelRenderer;
import com.best108.atom_animation_reader.impl.BasicAnimationTransform;
import com.best108.atom_animation_reader.impl.BasicAtomAnimation;
import com.best108.atom_animation_reader.impl.BasicDagNodeRenderer;
import com.best108.atom_animation_reader.impl.GroupedDagNodeRenderer;
import com.best108.atom_animation_reader.parsers.AtomParser;
import com.best108.atom_animation_reader.parsers.AtomParserElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;

public class BasicAtomAnimationBuilder
implements IAtomAnimationBuilder {
    private final int minKeyFrame;
    private final int maxKeyFrame;
    private final List<DagNode> renderNodes;

    public BasicAtomAnimationBuilder(AtomParser parser) {
        this.minKeyFrame = Integer.parseInt(parser.head.properties.get(6)[1]);
        this.maxKeyFrame = Integer.parseInt(parser.head.properties.get(7)[1]);
        this.renderNodes = new ArrayList<DagNode>();
        for (AtomParserElement dagNodesParsed : parser.head.branches) {
            this.renderNodes.add(new DagNode(dagNodesParsed));
        }
        for (DagNode dagNode : this.renderNodes) {
            for (AnimationDataNode animationNode : dagNode.animationNodes) {
                for (String[] stringArray : animationNode.animKeyframes.keyframes) {
                }
            }
        }
    }

    @Override
    public IAtomAnimation build(IModelRenderer modelRenderer) {
        ArrayList<BasicDagNodeRenderer> dagNodeRenderers = new ArrayList<BasicDagNodeRenderer>();
        HashMap<String, VectorImmutable> modelNamesToPivots = new HashMap<String, VectorImmutable>();
        for (DagNode dagNode : this.renderNodes) {
            if (dagNode.modelName.endsWith("_pivot")) {
                Vector pivotPoint = new Vector();
                for (AnimationDataNode animData : dagNode.animationNodes) {
                    if (animData.animationType.equals("translateX")) {
                        pivotPoint.X = Double.valueOf(animData.animKeyframes.keyframes.get(0)[1]);
                    }
                    if (animData.animationType.equals("translateY")) {
                        pivotPoint.Y = Double.valueOf(animData.animKeyframes.keyframes.get(0)[1]);
                    }
                    if (!animData.animationType.equals("translateZ")) continue;
                    pivotPoint.Z = Double.valueOf(animData.animKeyframes.keyframes.get(0)[1]);
                }
                modelNamesToPivots.put(dagNode.modelName.substring(0, dagNode.modelName.length() - 6), pivotPoint.toImmutable());
                continue;
            }
            ArrayList<BasicAnimationTransform> animations = new ArrayList<BasicAnimationTransform>();
            for (AnimationDataNode animationNode : dagNode.animationNodes) {
                BasicAnimationTransform basicTransform = new BasicAnimationTransform(animationNode.animationType, animationNode.animKeyframes.keyframes);
                animations.add(basicTransform);
            }
            BasicDagNodeRenderer dagRenderer = new BasicDagNodeRenderer(dagNode.modelName, animations, modelRenderer);
            dagNodeRenderers.add(dagRenderer);
        }
        for (BasicDagNodeRenderer dagNodeRenderer : dagNodeRenderers) {
            String modelName = dagNodeRenderer.getModelName();
            if (!modelNamesToPivots.containsKey(modelName)) continue;
            dagNodeRenderer.setPivot((VectorImmutable)((Object)modelNamesToPivots.get(modelName)));
        }
        boolean hasChanged = true;
        block4: while (hasChanged) {
            hasChanged = false;
            for (BasicDagNodeRenderer dagNodeRenderer : dagNodeRenderers) {
                String modelName = dagNodeRenderer.getModelName();
                String[] split = modelName.split("_");
                if (split.length <= 0 || !modelName.contains("defgroup")) continue;
                int index = -1;
                for (int i = 0; i < split.length; ++i) {
                    if (!split[i].contains("defgroup")) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    throw new IllegalStateException("This is a total mystery!\nOffending model name: " + modelName + "\n");
                }
                String groupName = split[index].replaceAll("defgroup", "");
                ArrayList<BasicDagNodeRenderer> children = new ArrayList<BasicDagNodeRenderer>();
                for (BasicDagNodeRenderer potentialChild : dagNodeRenderers) {
                    String possibleChildGroup;
                    String[] possibleChildNameSplit;
                    if (!potentialChild.getModelName().contains("_grp") || !(possibleChildNameSplit = potentialChild.getModelName().split("_"))[possibleChildNameSplit.length - 1].contains("grp") || !(possibleChildGroup = possibleChildNameSplit[possibleChildNameSplit.length - 1].replaceAll("grp", "")).equals(groupName)) continue;
                    children.add(potentialChild);
                }
                hasChanged = !children.isEmpty();
                if (!hasChanged) continue;
                ArrayList<BasicDagNodeRenderer> newDagRenderers = new ArrayList<BasicDagNodeRenderer>(dagNodeRenderers);
                newDagRenderers.removeAll(children);
                newDagRenderers.remove(dagNodeRenderer);
                newDagRenderers.add(new GroupedDagNodeRenderer(dagNodeRenderer.getModelName(), dagNodeRenderer.transformations, children, dagNodeRenderer.pivot));
                dagNodeRenderers = newDagRenderers;
                continue block4;
            }
        }
        return new BasicAtomAnimation(dagNodeRenderers, this.minKeyFrame, this.maxKeyFrame);
    }

    @Override
    public Set<String> getModelObjsUsed() {
        HashSet<String> toReturn = new HashSet<String>();
        for (DagNode dagNode : this.renderNodes) {
            if (dagNode.modelName.endsWith("_pivot")) continue;
            toReturn.add(dagNode.modelName);
        }
        return toReturn;
    }

    static class Keyframes {
        final List<String[]> keyframes;

        Keyframes(List<String[]> keyframes) {
            this.keyframes = keyframes;
        }
    }

    static class AnimationDataNode {
        final String animationType;
        final Keyframes animKeyframes;

        AnimationDataNode(String animationType, Keyframes animKeyframes) {
            this.animationType = animationType;
            this.animKeyframes = animKeyframes;
        }
    }

    static class DagNode {
        final String modelName;
        final List<AnimationDataNode> animationNodes;

        DagNode(AtomParserElement parserElement) {
            List<String[]> properties = parserElement.properties;
            this.modelName = !properties.get(0)[0].contains("|") ? properties.get(0)[0] : properties.get(0)[0].split(Pattern.quote("|"))[1];
            this.animationNodes = new ArrayList<AnimationDataNode>();
            int currentBranch = 0;
            for (String[] line : properties) {
                if (!line[0].equals("anim")) continue;
                List<String[]> animKeyframes = parserElement.branches.get((int)currentBranch).properties;
                Keyframes keyFrames = new Keyframes(parserElement.branches.get((int)currentBranch).branches.get((int)0).properties);
                AnimationDataNode animationNode = new AnimationDataNode(line[2], keyFrames);
                this.animationNodes.add(animationNode);
                ++currentBranch;
            }
        }
    }
}

