/*
 * Decompiled with CFR 0.152.
 */
package com.best108.atom_animation_reader.impl;

import com.best108.atom_animation_reader.IModelRenderer;
import com.best108.atom_animation_reader.impl.BasicAnimationTransform;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;

public class BasicDagNodeRenderer {
    private final String modelName;
    protected final List<BasicAnimationTransform> transformations;
    private final IModelRenderer modelRenderer;
    protected VectorImmutable pivot;

    public BasicDagNodeRenderer(String modelName, List<BasicAnimationTransform> transformations, IModelRenderer modelRenderer) {
        this.modelName = modelName;
        this.transformations = transformations;
        this.modelRenderer = modelRenderer;
        this.pivot = VectorImmutable.ZERO_VECTOR;
    }

    public void render(double keyframe, int brightness) {
        for (int i = 0; i < this.transformations.size(); ++i) {
            Vector customPivot = new Vector(this.pivot);
            for (int j = this.transformations.size() - 1; j > i; --j) {
                this.transformations.get(j).changePivot(customPivot, keyframe);
            }
            GlStateManager.func_179137_b((double)customPivot.X, (double)customPivot.Y, (double)customPivot.Z);
            this.transformations.get(i).transform(keyframe);
            GlStateManager.func_179137_b((double)(-customPivot.X), (double)(-customPivot.Y), (double)(-customPivot.Z));
        }
        this.modelRenderer.renderModel(this.modelName, brightness);
    }

    public void setPivot(VectorImmutable pivot) {
        this.pivot = pivot;
    }

    public String getModelName() {
        return this.modelName;
    }
}

