/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.fallback;

import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.All;
import com.googlecode.cqengine.query.simple.None;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import java.util.Collections;
import java.util.Iterator;

public class FallbackIndex<O>
implements Index<O> {
    private static final int INDEX_RETRIEVAL_COST = Integer.MAX_VALUE;
    private static final int INDEX_MERGE_COST = Integer.MAX_VALUE;
    volatile ObjectStore<O> objectStore = null;

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return true;
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    @Override
    public ResultSet<O> retrieve(final Query<O> query, final QueryOptions queryOptions) {
        final ObjectSet<O> objectSet = ObjectSet.fromObjectStore(this.objectStore, queryOptions);
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                if (query instanceof All) {
                    return IteratorUtil.wrapAsUnmodifiable(objectSet.iterator());
                }
                if (query instanceof None) {
                    return Collections.emptyList().iterator();
                }
                return new FilteringIterator<O>(objectSet.iterator(), queryOptions){

                    @Override
                    public boolean isValid(O object, QueryOptions queryOptions) {
                        return query.matches(object, queryOptions);
                    }
                };
            }

            @Override
            public boolean contains(O object) {
                return IteratorUtil.iterableContains(this, object);
            }

            @Override
            public int size() {
                return IteratorUtil.countElements(this);
            }

            @Override
            public boolean matches(O object) {
                return query.matches(object, queryOptions);
            }

            @Override
            public int getRetrievalCost() {
                return query instanceof None ? 0 : Integer.MAX_VALUE;
            }

            @Override
            public int getMergeCost() {
                return query instanceof None ? 0 : Integer.MAX_VALUE;
            }

            @Override
            public void close() {
                objectSet.close();
            }

            @Override
            public Query<O> getQuery() {
                return query;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return false;
    }

    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        return false;
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.objectStore = objectStore;
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.objectStore.clear(queryOptions);
    }
}

