/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.navigable;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractMapBasedAttributeIndex;
import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.Factory;
import com.googlecode.cqengine.index.support.IndexSupport;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.quantizer.Quantizer;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.filter.QuantizedResultSet;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import com.googlecode.cqengine.resultset.stored.StoredResultSet;
import com.googlecode.cqengine.resultset.stored.StoredSetBasedResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class NavigableIndex<A extends Comparable<A>, O>
extends AbstractMapBasedAttributeIndex<A, O, ConcurrentNavigableMap<A, StoredResultSet<O>>>
implements SortedKeyStatisticsAttributeIndex<A, O>,
OnHeapTypeIndex {
    protected static final int INDEX_RETRIEVAL_COST = 40;

    protected NavigableIndex(Factory<ConcurrentNavigableMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute) {
        super(indexMapFactory, valueSetFactory, attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(In.class);
                this.add(LessThan.class);
                this.add(GreaterThan.class);
                this.add(Between.class);
                this.add(Has.class);
            }
        });
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        IndexRangeLookupFunction lookupFunction;
        Class<?> queryClass = query.getClass();
        final boolean indexIsQuantized = this.isQuantized();
        if (queryClass.equals(Equal.class)) {
            Equal equal = (Equal)query;
            return this.retrieveEqual(equal, queryOptions);
        }
        if (queryClass.equals(In.class)) {
            In in = (In)query;
            return this.retrieveIn(in, queryOptions);
        }
        if (queryClass.equals(Has.class)) {
            return IndexSupport.deduplicateIfNecessary(((ConcurrentNavigableMap)this.indexMap).values(), query, this.getAttribute(), queryOptions, 40);
        }
        if (queryClass.equals(LessThan.class)) {
            final LessThan lessThan = (LessThan)query;
            lookupFunction = new IndexRangeLookupFunction<O>(query, false, true){

                @Override
                public Iterable<StoredResultSet<O>> perform() {
                    return ((ConcurrentNavigableMap)NavigableIndex.this.indexMap).headMap((Comparable)NavigableIndex.this.getQuantizedValue(lessThan.getValue()), lessThan.isValueInclusive() || indexIsQuantized).values();
                }
            };
        } else if (queryClass.equals(GreaterThan.class)) {
            final GreaterThan greaterThan = (GreaterThan)query;
            lookupFunction = new IndexRangeLookupFunction<O>(query, true, false){

                @Override
                public Iterable<StoredResultSet<O>> perform() {
                    return ((ConcurrentNavigableMap)NavigableIndex.this.indexMap).tailMap((Comparable)NavigableIndex.this.getQuantizedValue(greaterThan.getValue()), greaterThan.isValueInclusive() || indexIsQuantized).values();
                }
            };
        } else if (queryClass.equals(Between.class)) {
            final Between between = (Between)query;
            lookupFunction = new IndexRangeLookupFunction<O>(query, true, true){

                @Override
                public Iterable<StoredResultSet<O>> perform() {
                    return ((ConcurrentNavigableMap)NavigableIndex.this.indexMap).subMap((Comparable)NavigableIndex.this.getQuantizedValue(between.getLowerValue()), between.isLowerInclusive() || indexIsQuantized, (Comparable)NavigableIndex.this.getQuantizedValue(between.getUpperValue()), between.isUpperInclusive() || indexIsQuantized).values();
                }
            };
        } else {
            throw new IllegalStateException("Unsupported query: " + query);
        }
        Iterable results = lookupFunction.perform();
        results = this.addFilteringForQuantization(results, lookupFunction, queryOptions);
        return IndexSupport.deduplicateIfNecessary(results, query, this.getAttribute(), queryOptions, 40);
    }

    protected ResultSet<O> retrieveIn(final In<O, A> in, final QueryOptions queryOptions) {
        Iterable results = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new LazyIterator<ResultSet<O>>(){
                    final Iterator<A> values;
                    {
                        this.values = in.getValues().iterator();
                    }

                    @Override
                    protected ResultSet<O> computeNext() {
                        if (this.values.hasNext()) {
                            return NavigableIndex.this.retrieveEqual(new Equal(in.getAttribute(), (Comparable)this.values.next()), queryOptions);
                        }
                        return (ResultSet)this.endOfData();
                    }
                };
            }
        };
        return IndexSupport.deduplicateIfNecessary(results, in, this.getAttribute(), queryOptions, 40);
    }

    protected ResultSet<O> retrieveEqual(final Equal<O, A> equal, final QueryOptions queryOptions) {
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                ResultSet rs = (ResultSet)((ConcurrentNavigableMap)NavigableIndex.this.indexMap).get(NavigableIndex.this.getQuantizedValue((Comparable)equal.getValue()));
                return rs == null ? Collections.emptySet().iterator() : NavigableIndex.this.filterForQuantization(rs, equal, queryOptions).iterator();
            }

            @Override
            public boolean contains(O object) {
                ResultSet rs = (ResultSet)((ConcurrentNavigableMap)NavigableIndex.this.indexMap).get(NavigableIndex.this.getQuantizedValue((Comparable)equal.getValue()));
                return rs != null && NavigableIndex.this.filterForQuantization(rs, equal, queryOptions).contains(object);
            }

            @Override
            public boolean matches(O object) {
                return equal.matches(object, queryOptions);
            }

            @Override
            public int size() {
                ResultSet rs = (ResultSet)((ConcurrentNavigableMap)NavigableIndex.this.indexMap).get(NavigableIndex.this.getQuantizedValue((Comparable)equal.getValue()));
                return rs == null ? 0 : NavigableIndex.this.filterForQuantization(rs, equal, queryOptions).size();
            }

            @Override
            public int getRetrievalCost() {
                return 40;
            }

            @Override
            public int getMergeCost() {
                ResultSet rs = (ResultSet)((ConcurrentNavigableMap)NavigableIndex.this.indexMap).get(NavigableIndex.this.getQuantizedValue((Comparable)equal.getValue()));
                return rs == null ? 0 : rs.size();
            }

            @Override
            public void close() {
            }

            @Override
            public Query<O> getQuery() {
                return equal;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(this.getDistinctKeysInRange(null, true, null, true));
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(this.getDistinctKeysInRange(lowerBound, lowerInclusive, upperBound, upperInclusive));
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(this.getDistinctKeysInRange(null, true, null, true).descendingSet());
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(this.getDistinctKeysInRange(lowerBound, lowerInclusive, upperBound, upperInclusive).descendingSet());
    }

    NavigableSet<A> getDistinctKeysInRange(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive) {
        NavigableSet<A> results = lowerBound != null && upperBound != null ? ((ConcurrentNavigableMap)this.indexMap).keySet().subSet(lowerBound, lowerInclusive, upperBound, upperInclusive) : (lowerBound != null ? ((ConcurrentNavigableMap)this.indexMap).keySet().tailSet(lowerBound, lowerInclusive) : (upperBound != null ? ((ConcurrentNavigableMap)this.indexMap).keySet().headSet(upperBound, upperInclusive) : ((ConcurrentNavigableMap)this.indexMap).keySet()));
        return results;
    }

    @Override
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        return super.getCountForKey(key);
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        return super.getCountOfDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return super.getStatisticsForDistinctKeys(queryOptions);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeysDescending(QueryOptions queryOptions) {
        Iterator distinctKeysDescending = this.getDistinctKeysDescending(queryOptions).iterator();
        return NavigableIndex.wrapNonCloseable(new Iterable<KeyStatistics<A>>((CloseableIterator)distinctKeysDescending, queryOptions){
            final /* synthetic */ CloseableIterator val$distinctKeysDescending;
            final /* synthetic */ QueryOptions val$queryOptions;
            {
                this.val$distinctKeysDescending = closeableIterator;
                this.val$queryOptions = queryOptions;
            }

            @Override
            public Iterator<KeyStatistics<A>> iterator() {
                return new LazyIterator<KeyStatistics<A>>(){

                    @Override
                    protected KeyStatistics<A> computeNext() {
                        if (val$distinctKeysDescending.hasNext()) {
                            Comparable key = (Comparable)val$distinctKeysDescending.next();
                            return new KeyStatistics<Comparable>(key, NavigableIndex.this.getCountForKey(key, val$queryOptions));
                        }
                        return (KeyStatistics)this.endOfData();
                    }
                };
            }
        });
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(IteratorUtil.flatten(this.getKeysAndValuesInRange(null, true, null, true)));
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(IteratorUtil.flatten(this.getKeysAndValuesInRange(lowerBound, lowerInclusive, upperBound, upperInclusive)));
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(IteratorUtil.flatten(this.getKeysAndValuesInRange(null, true, null, true).descendingMap()));
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return NavigableIndex.wrapNonCloseable(IteratorUtil.flatten(this.getKeysAndValuesInRange(lowerBound, lowerInclusive, upperBound, upperInclusive).descendingMap()));
    }

    NavigableMap<A, StoredResultSet<O>> getKeysAndValuesInRange(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive) {
        NavigableMap results = lowerBound != null && upperBound != null ? ((ConcurrentNavigableMap)this.indexMap).subMap(lowerBound, lowerInclusive, upperBound, upperInclusive) : (lowerBound != null ? ((ConcurrentNavigableMap)this.indexMap).tailMap(lowerBound, lowerInclusive) : (upperBound != null ? ((ConcurrentNavigableMap)this.indexMap).headMap(upperBound, upperInclusive) : (NavigableMap)((Object)this.indexMap)));
        return results;
    }

    protected Iterable<ResultSet<O>> addFilteringForQuantization(Iterable<ResultSet<O>> resultSets, IndexRangeLookupFunction<O> lookupFunction, QueryOptions queryOptions) {
        return resultSets;
    }

    protected ResultSet<O> filterForQuantization(ResultSet<O> storedResultSet, Query<O> query, QueryOptions queryOptions) {
        return storedResultSet;
    }

    public static <A extends Comparable<A>, O> NavigableIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return NavigableIndex.onAttribute(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), attribute);
    }

    public static <A extends Comparable<A>, O> NavigableIndex<A, O> onAttribute(Factory<ConcurrentNavigableMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, Attribute<O, A> attribute) {
        return new NavigableIndex<A, O>(indexMapFactory, valueSetFactory, attribute);
    }

    public static <A extends Comparable<A>, O> NavigableIndex<A, O> withQuantizerOnAttribute(Quantizer<A> quantizer, Attribute<O, A> attribute) {
        return NavigableIndex.withQuantizerOnAttribute(new DefaultIndexMapFactory(), new DefaultValueSetFactory(), quantizer, attribute);
    }

    public static <A extends Comparable<A>, O> NavigableIndex<A, O> withQuantizerOnAttribute(Factory<ConcurrentNavigableMap<A, StoredResultSet<O>>> indexMapFactory, Factory<StoredResultSet<O>> valueSetFactory, final Quantizer<A> quantizer, Attribute<O, A> attribute) {
        return new NavigableIndex<A, O>(indexMapFactory, valueSetFactory, attribute){

            @Override
            protected Iterable<ResultSet<O>> addFilteringForQuantization(final Iterable<ResultSet<O>> resultSets, final IndexRangeLookupFunction<O> lookupFunction, final QueryOptions queryOptions) {
                if (!lookupFunction.filterFirstResultSet && !lookupFunction.filterLastResultSet) {
                    return resultSets;
                }
                return new Iterable<ResultSet<O>>(){

                    @Override
                    public Iterator<ResultSet<O>> iterator() {
                        return new UnmodifiableIterator<ResultSet<O>>(){
                            Iterator<? extends ResultSet<O>> resultSetsIterator;
                            boolean firstResultSet;
                            {
                                this.resultSetsIterator = resultSets.iterator();
                                this.firstResultSet = true;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.resultSetsIterator.hasNext();
                            }

                            @Override
                            public ResultSet<O> next() {
                                ResultSet rs = this.resultSetsIterator.next();
                                if (lookupFunction.filterFirstResultSet && this.firstResultSet) {
                                    this.firstResultSet = false;
                                    return new QuantizedResultSet(rs, lookupFunction.query, queryOptions);
                                }
                                if (!lookupFunction.filterLastResultSet || this.resultSetsIterator.hasNext()) {
                                    return rs;
                                }
                                return new QuantizedResultSet(rs, lookupFunction.query, queryOptions);
                            }
                        };
                    }
                };
            }

            @Override
            protected A getQuantizedValue(A attributeValue) {
                return (Comparable)quantizer.getQuantizedValue(attributeValue);
            }

            @Override
            protected ResultSet<O> filterForQuantization(ResultSet<O> storedResultSet, Query<O> query, QueryOptions queryOptions) {
                return new QuantizedResultSet(storedResultSet, query, queryOptions);
            }

            @Override
            public boolean isQuantized() {
                return true;
            }
        };
    }

    public static class DefaultValueSetFactory<O>
    implements Factory<StoredResultSet<O>> {
        @Override
        public StoredResultSet<O> create() {
            return new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    public static class DefaultIndexMapFactory<A, O>
    implements Factory<ConcurrentNavigableMap<A, StoredResultSet<O>>> {
        @Override
        public ConcurrentNavigableMap<A, StoredResultSet<O>> create() {
            return new ConcurrentSkipListMap();
        }
    }

    protected abstract class IndexRangeLookupFunction<O> {
        protected final boolean filterFirstResultSet;
        protected final boolean filterLastResultSet;
        protected final Query<O> query;

        protected IndexRangeLookupFunction(Query<O> query, boolean filterFirstResultSet, boolean filterLastResultSet) {
            this.query = query;
            this.filterFirstResultSet = filterFirstResultSet;
            this.filterLastResultSet = filterLastResultSet;
        }

        protected abstract Iterable<? extends ResultSet<O>> perform();
    }
}

