/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.radix;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.IndexSupport;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.stored.StoredResultSet;
import com.googlecode.cqengine.resultset.stored.StoredSetBasedResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RadixTreeIndex<A extends CharSequence, O>
extends AbstractAttributeIndex<A, O>
implements OnHeapTypeIndex {
    private static final int INDEX_RETRIEVAL_COST = 50;
    final NodeFactory nodeFactory;
    volatile RadixTree<StoredResultSet<O>> tree;

    protected RadixTreeIndex(Attribute<O, A> attribute) {
        this(attribute, new DefaultCharArrayNodeFactory());
    }

    protected RadixTreeIndex(Attribute<O, A> attribute, NodeFactory nodeFactory) {
        super(attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(In.class);
                this.add(StringStartsWith.class);
            }
        });
        this.nodeFactory = nodeFactory;
        this.tree = new ConcurrentRadixTree<StoredResultSet<O>>(nodeFactory);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(final Query<O> query, final QueryOptions queryOptions) {
        final RadixTree<StoredResultSet<O>> tree = this.tree;
        Class<?> queryClass = query.getClass();
        if (queryClass.equals(Equal.class)) {
            Equal equal = (Equal)query;
            return this.retrieveEqual(equal, queryOptions, tree);
        }
        if (queryClass.equals(In.class)) {
            In in = (In)query;
            return this.retrieveIn(in, queryOptions, tree);
        }
        if (queryClass.equals(StringStartsWith.class)) {
            final StringStartsWith stringStartsWith = (StringStartsWith)query;
            return new ResultSet<O>(){

                @Override
                public Iterator<O> iterator() {
                    Iterable resultSets = tree.getValuesForKeysStartingWith((CharSequence)stringStartsWith.getValue());
                    ResultSet rs = IndexSupport.deduplicateIfNecessary(resultSets, query, RadixTreeIndex.this.getAttribute(), queryOptions, 50);
                    return rs.iterator();
                }

                @Override
                public boolean contains(O object) {
                    Iterable resultSets = tree.getValuesForKeysStartingWith((CharSequence)stringStartsWith.getValue());
                    ResultSet rs = IndexSupport.deduplicateIfNecessary(resultSets, query, RadixTreeIndex.this.getAttribute(), queryOptions, 50);
                    return rs.contains(object);
                }

                @Override
                public boolean matches(O object) {
                    return query.matches(object, queryOptions);
                }

                @Override
                public int size() {
                    Iterable resultSets = tree.getValuesForKeysStartingWith((CharSequence)stringStartsWith.getValue());
                    ResultSet rs = IndexSupport.deduplicateIfNecessary(resultSets, query, RadixTreeIndex.this.getAttribute(), queryOptions, 50);
                    return rs.size();
                }

                @Override
                public int getRetrievalCost() {
                    return 50;
                }

                @Override
                public int getMergeCost() {
                    Iterable resultSets = tree.getValuesForKeysStartingWith((CharSequence)stringStartsWith.getValue());
                    ResultSet rs = IndexSupport.deduplicateIfNecessary(resultSets, query, RadixTreeIndex.this.getAttribute(), queryOptions, 50);
                    return rs.getMergeCost();
                }

                @Override
                public void close() {
                }

                @Override
                public Query<O> getQuery() {
                    return query;
                }

                @Override
                public QueryOptions getQueryOptions() {
                    return queryOptions;
                }
            };
        }
        throw new IllegalArgumentException("Unsupported query: " + query);
    }

    protected ResultSet<O> retrieveIn(final In<O, A> in, final QueryOptions queryOptions, final RadixTree<StoredResultSet<O>> tree) {
        Iterable results = new Iterable<ResultSet<O>>(){

            @Override
            public Iterator<ResultSet<O>> iterator() {
                return new LazyIterator<ResultSet<O>>(){
                    final Iterator<A> values;
                    {
                        this.values = in.getValues().iterator();
                    }

                    @Override
                    protected ResultSet<O> computeNext() {
                        if (this.values.hasNext()) {
                            return RadixTreeIndex.this.retrieveEqual(new Equal(in.getAttribute(), (CharSequence)this.values.next()), queryOptions, tree);
                        }
                        return (ResultSet)this.endOfData();
                    }
                };
            }
        };
        return IndexSupport.deduplicateIfNecessary(results, in, this.getAttribute(), queryOptions, 50);
    }

    protected ResultSet<O> retrieveEqual(final Equal<O, A> equal, final QueryOptions queryOptions, final RadixTree<StoredResultSet<O>> tree) {
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                ResultSet rs = (ResultSet)tree.getValueForExactKey((CharSequence)equal.getValue());
                return rs == null ? Collections.emptySet().iterator() : rs.iterator();
            }

            @Override
            public boolean contains(O object) {
                ResultSet rs = (ResultSet)tree.getValueForExactKey((CharSequence)equal.getValue());
                return rs != null && rs.contains(object);
            }

            @Override
            public boolean matches(O object) {
                return equal.matches(object, queryOptions);
            }

            @Override
            public int size() {
                ResultSet rs = (ResultSet)tree.getValueForExactKey((CharSequence)equal.getValue());
                return rs == null ? 0 : rs.size();
            }

            @Override
            public int getRetrievalCost() {
                return 50;
            }

            @Override
            public int getMergeCost() {
                ResultSet rs = (ResultSet)tree.getValueForExactKey((CharSequence)equal.getValue());
                return rs == null ? 0 : rs.size();
            }

            @Override
            public void close() {
            }

            @Override
            public Query<O> getQuery() {
                return equal;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    public StoredResultSet<O> createValueSet() {
        return new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            RadixTree<StoredResultSet<StoredResultSet<O>>> tree = this.tree;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (CharSequence attributeValue : attributeValues) {
                    StoredResultSet<O> existingValueSet;
                    StoredResultSet valueSet = tree.getValueForExactKey(attributeValue);
                    if (valueSet == null && (existingValueSet = tree.putIfAbsent(attributeValue, valueSet = this.createValueSet())) != null) {
                        valueSet = existingValueSet;
                    }
                    modified |= valueSet.add(object);
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            RadixTree<StoredResultSet<O>> tree = this.tree;
            for (Object object : objectSet) {
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (CharSequence attributeValue : attributeValues) {
                    StoredResultSet valueSet = tree.getValueForExactKey(attributeValue);
                    if (valueSet == null) continue;
                    modified |= valueSet.remove(object);
                    if (!valueSet.isEmpty()) continue;
                    tree.remove(attributeValue);
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, queryOptions), queryOptions);
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.tree = new ConcurrentRadixTree<StoredResultSet<O>>(new DefaultCharArrayNodeFactory());
    }

    public static <A extends CharSequence, O> RadixTreeIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return new RadixTreeIndex<A, O>(attribute);
    }

    public static <A extends CharSequence, O> RadixTreeIndex<A, O> onAttributeUsingNodeFactory(Attribute<O, A> attribute, NodeFactory nodeFactory) {
        return new RadixTreeIndex<A, O>(attribute, nodeFactory);
    }
}

