/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import de.javakaffee.kryoserializers.guava.MultimapSerializerBase;
import java.util.Comparator;

public class TreeMultimapSerializer
extends MultimapSerializerBase<Comparable, Comparable, TreeMultimap<Comparable, Comparable>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = false;

    public TreeMultimapSerializer() {
        super(true, false);
    }

    @Override
    public void write(Kryo kryo, Output output, TreeMultimap<Comparable, Comparable> multimap) {
        kryo.writeClassAndObject(output, multimap.keyComparator());
        kryo.writeClassAndObject(output, multimap.valueComparator());
        this.writeMultimap(kryo, output, multimap);
    }

    @Override
    public TreeMultimap<Comparable, Comparable> read(Kryo kryo, Input input, Class<? extends TreeMultimap<Comparable, Comparable>> type) {
        Comparator keyComparator = (Comparator)kryo.readClassAndObject(input);
        Comparator valueComparator = (Comparator)kryo.readClassAndObject(input);
        TreeMultimap multimap = TreeMultimap.create((Comparator)keyComparator, (Comparator)valueComparator);
        this.readMultimap(kryo, input, multimap);
        return multimap;
    }

    @Override
    protected Multimap createCopy(Kryo kryo, Multimap original) {
        TreeMultimap tm = (TreeMultimap)original;
        return TreeMultimap.create((Comparator)tm.keyComparator(), (Comparator)tm.valueComparator());
    }

    public static void registerSerializers(Kryo kryo) {
        TreeMultimapSerializer serializer = new TreeMultimapSerializer();
        kryo.register(TreeMultimap.class, serializer);
    }
}

