/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.graph.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import gigaherz.graph.api.ContextDataFactory;
import gigaherz.graph.api.GraphObject;
import gigaherz.graph.api.Mergeable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Graph {
    private static int lastUid = 0;
    private final int graphUid = ++lastUid;
    private Mergeable contextData;
    private final Set<Node> nodeList = Sets.newHashSet();
    private final Multimap<Node, Node> neighbours = HashMultimap.create();
    private final Multimap<Node, Node> reverseNeighbours = HashMultimap.create();
    private final Map<GraphObject, Node> objects = Maps.newHashMap();

    int getGraphUid() {
        return this.graphUid;
    }

    public static void integrate(GraphObject object, List<GraphObject> neighbours) {
        Graph.integrate(object, neighbours, null);
    }

    public static void integrate(GraphObject object, List<GraphObject> neighbours, @Nullable ContextDataFactory contextDataFactory) {
        Graph target;
        HashSet otherGraphs = Sets.newHashSet();
        for (GraphObject neighbour : neighbours) {
            Graph otherGraph = neighbour.getGraph();
            if (otherGraph == null || otherGraphs.contains(otherGraph)) continue;
            otherGraphs.add(otherGraph);
        }
        if (otherGraphs.size() > 0) {
            target = (Graph)otherGraphs.iterator().next();
        } else {
            target = new Graph();
            if (contextDataFactory != null) {
                target.contextData = contextDataFactory.create(target);
            }
        }
        target.add(object, neighbours);
    }

    public void add(GraphObject object, Iterable<GraphObject> neighbours) {
        if (object.getGraph() != null) {
            throw new IllegalArgumentException("The object is already in another graph.");
        }
        if (this.objects.containsKey(object)) {
            throw new IllegalStateException("The object is already in this graph.");
        }
        Node node = new Node(this, object);
        object.setGraph(this);
        this.objects.put(object, node);
        this.nodeList.add(node);
        this.verify();
        this.addNeighours(object, neighbours);
    }

    public void addNeighours(GraphObject object, Iterable<GraphObject> neighbours) {
        Node node = this.objects.get(object);
        for (GraphObject neighbour : neighbours) {
            Graph g = neighbour.getGraph();
            if (g == null) {
                throw new IllegalArgumentException("The neighbour object is not in a graph.");
            }
            if (g != this) {
                this.mergeWith(g);
            }
            if (neighbour.getGraph() != this) {
                throw new IllegalStateException("The graph merging didn't work as expected.");
            }
            Node n = this.objects.get(neighbour);
            this.neighbours.put((Object)node, (Object)n);
            this.reverseNeighbours.put((Object)n, (Object)node);
        }
        this.verify();
    }

    public void addNeighbour(GraphObject object, GraphObject neighbour) {
        Node node = this.objects.get(object);
        Node n = this.objects.get(neighbour);
        this.neighbours.put((Object)node, (Object)n);
        this.reverseNeighbours.put((Object)n, (Object)node);
        this.verify();
    }

    public void removeNeighbour(GraphObject object, GraphObject neighbour) {
        Node node = this.objects.get(object);
        Node other = this.objects.get(neighbour);
        this.neighbours.remove((Object)node, (Object)other);
        this.reverseNeighbours.remove((Object)other, (Object)node);
        this.verify();
        this.splitAfterRemoval();
    }

    public void remove(GraphObject object) {
        if (object.getGraph() != this) {
            throw new IllegalArgumentException("The object is not of this graph.");
        }
        object.setGraph(null);
        Node node = this.objects.get(object);
        if (node == null) {
            throw new IllegalStateException("The graph is broken.");
        }
        this.nodeList.remove(node);
        HashSet neighs = Sets.newHashSet((Iterable)this.neighbours.get((Object)node));
        neighs.addAll(this.reverseNeighbours.get((Object)node));
        for (Object n : neighs) {
            this.neighbours.remove(n, (Object)node);
            this.reverseNeighbours.remove((Object)node, n);
            this.neighbours.remove((Object)node, n);
            this.reverseNeighbours.remove(n, (Object)node);
        }
        this.objects.remove(object);
        this.verify();
        this.splitAfterRemoval();
    }

    public Collection<GraphObject> getObjects() {
        return ImmutableSet.copyOf(this.objects.keySet());
    }

    public Collection<GraphObject> getNeighbours(GraphObject object) {
        HashSet others = Sets.newHashSet();
        for (Node n : this.neighbours.get((Object)this.objects.get(object))) {
            others.add(n.getObject());
        }
        return ImmutableSet.copyOf((Collection)others);
    }

    public boolean contains(GraphObject object) {
        Node node = this.objects.get(object);
        return node != null && this.nodeList.contains(node);
    }

    private void splitAfterRemoval() {
        if (this.nodeList.size() == 0) {
            return;
        }
        HashSet remaining = Sets.newHashSet(this.nodeList);
        HashSet seen = Sets.newHashSet();
        ArrayDeque succ = Queues.newArrayDeque();
        Node node = (Node)remaining.iterator().next();
        succ.add(node);
        seen.add(node);
        remaining.remove(node);
        while (succ.size() > 0) {
            Node n;
            Node c = (Node)succ.poll();
            for (Object o : this.neighbours.get((Object)c)) {
                n = (Node)o;
                if (seen.contains(n)) continue;
                seen.add(n);
                succ.add(n);
                remaining.remove(n);
            }
            for (Object o : this.reverseNeighbours.get((Object)c)) {
                n = (Node)o;
                if (seen.contains(n)) continue;
                seen.add(n);
                succ.add(n);
                remaining.remove(n);
            }
        }
        while (remaining.size() > 0) {
            node = (Node)remaining.iterator().next();
            succ.add(node);
            seen.add(node);
            remaining.remove(node);
            Graph newGraph = new Graph();
            if (this.contextData != null) {
                newGraph.contextData = this.contextData.copy();
            }
            while (succ.size() > 0) {
                Node n;
                Node c = (Node)succ.poll();
                for (Object o : this.neighbours.get((Object)c)) {
                    n = (Node)o;
                    if (seen.contains(n)) continue;
                    seen.add(n);
                    succ.add(n);
                    remaining.remove(n);
                }
                for (Object o : this.reverseNeighbours.get((Object)c)) {
                    n = (Node)o;
                    if (seen.contains(n)) continue;
                    seen.add(n);
                    succ.add(n);
                    remaining.remove(n);
                }
                this.nodeList.remove(c);
                newGraph.nodeList.add(c);
                newGraph.neighbours.putAll((Object)c, (Iterable)this.neighbours.get((Object)c));
                newGraph.reverseNeighbours.putAll((Object)c, (Iterable)this.reverseNeighbours.get((Object)c));
                this.neighbours.removeAll((Object)c);
                this.reverseNeighbours.removeAll((Object)c);
                this.objects.remove(c.getObject());
                newGraph.objects.put(c.getObject(), c);
                c.owner = newGraph;
                c.getObject().setGraph(newGraph);
            }
            this.verify();
        }
        this.verify();
    }

    private void mergeWith(Graph graph) {
        this.nodeList.addAll(graph.nodeList);
        this.objects.putAll(graph.objects);
        this.neighbours.putAll(graph.neighbours);
        this.reverseNeighbours.putAll(graph.reverseNeighbours);
        for (Node n : graph.nodeList) {
            n.getObject().setGraph(this);
        }
        if (this.contextData != null && graph.contextData != null) {
            this.contextData = this.contextData.mergeWith(graph.contextData);
        } else if (graph.contextData != null) {
            this.contextData = graph.contextData;
        }
        this.verify();
    }

    private void verify() {
        for (Node node : this.nodeList) {
            for (Node other : this.neighbours.get((Object)node)) {
                if (this.nodeList.contains(other)) continue;
                throw new IllegalStateException("Graph is broken!");
            }
            if (this.objects.containsKey(node.getObject())) continue;
            throw new IllegalStateException("Graph is broken!");
        }
        for (Node other : this.objects.values()) {
            if (this.nodeList.contains(other)) continue;
            throw new IllegalStateException("Graph is broken!");
        }
    }

    public <T extends Mergeable<T>> T getContextData() {
        return (T)this.contextData;
    }

    public void setContextData(Mergeable contextData) {
        this.contextData = contextData;
    }

    private class Node {
        @Nonnull
        Graph owner;
        final GraphObject object;

        public Graph getOwner() {
            return this.owner;
        }

        public GraphObject getObject() {
            return this.object;
        }

        public Node(Graph owner, GraphObject object) {
            this.owner = owner;
            this.object = object;
        }
    }
}

