/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.nodenetwork.IVSNode;
import org.valkyrienskies.addon.control.tileentity.TileEntityNetworkDisplay;

public class BlockNetworkDisplay
extends Block
implements ITileEntityProvider {
    public BlockNetworkDisplay(Material materialIn) {
        super(materialIn);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        itemInformation.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.vs_control.network_display", (Object[])new Object[0]));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityNetworkDisplay) {
            TileEntityNetworkDisplay displayTile = (TileEntityNetworkDisplay)tile;
            Iterable<IVSNode> networkedObjects = displayTile.getNetworkedConnections();
            ArrayList<IVSNode> connectedNodes = new ArrayList<IVSNode>();
            HashMap<String, Integer> networkedClassTypeCounts = new HashMap<String, Integer>();
            for (IVSNode node : networkedObjects) {
                connectedNodes.add(node);
                Class<?> nodeClass = node.getParentTile().getClass();
                String tileClassName = nodeClass.getSimpleName();
                if (!networkedClassTypeCounts.containsKey(tileClassName)) {
                    networkedClassTypeCounts.put(tileClassName, 0);
                }
                networkedClassTypeCounts.put(tileClassName, (Integer)networkedClassTypeCounts.get(tileClassName) + 1);
            }
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Networked objects connected: " + connectedNodes.size()));
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Types of objects connected: " + ((Object)networkedClassTypeCounts).toString()));
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNetworkDisplay();
    }
}

