/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.tileentity.TileEntityPassengerChair;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockPassengerChair
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockPassengerChair(Material materialIn) {
        super(materialIn);
    }

    public static double getChairYaw(IBlockState state, BlockPos pos) {
        EnumFacing enumFace = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return -enumFace.func_185119_l() - 90.0f;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPassengerChair();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            Vec3d chairPos = this.getPlayerMountOffset(state, pos);
            TileEntity chairTile = worldIn.func_175625_s(pos);
            if (chairTile instanceof TileEntityPassengerChair) {
                ((TileEntityPassengerChair)chairTile).tryToMountPlayerToChair(playerIn, chairPos);
            } else {
                new IllegalStateException("world.getTileEntity() returned a tile that wasn't a chair at pos " + pos).printStackTrace();
            }
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity passengerChair = worldIn.func_175625_s(pos);
        if (passengerChair instanceof TileEntityPassengerChair && !passengerChair.func_145837_r()) {
            ((TileEntityPassengerChair)passengerChair).onBlockBroken(state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        itemInformation.add(TextFormatting.ITALIC + "" + TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.passenger_chair", (Object[])new Object[0]));
    }

    private Vec3d getPlayerMountOffset(IBlockState state, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: {
                return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.6);
            }
            case SOUTH: {
                return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.4);
            }
            case WEST: {
                return new Vec3d((double)pos.func_177958_n() + 0.6, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
            case EAST: {
                return new Vec3d((double)pos.func_177958_n() + 0.4, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
        }
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO().func_176734_d() : placer.func_174811_aO()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

