/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.engine;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.tileentity.TileEntityPropellerEngine;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public abstract class BlockAirshipEngine
extends Block
implements IBlockForceProvider,
ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected double enginePower;

    public BlockAirshipEngine(Material materialIn, double enginePower) {
        super(materialIn);
        this.setEnginePower(enginePower);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    @Override
    public Vector getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        Vector acting = new Vector(0.0, 0.0, 0.0);
        if (!world.func_175640_z(pos)) {
            return acting;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityPropellerEngine) {
            ((TileEntityPropellerEngine)tileEntity).setThrustMultiplierGoal(this.getEnginePower(world, pos, state, physicsObject));
            ((TileEntityPropellerEngine)tileEntity).updateTicksSinceLastRecievedSignal();
            ((TileEntityPropellerEngine)tileEntity).setThrustMultiplierGoal(1.0);
            return ((TileEntityPropellerEngine)tileEntity).getForceOutputUnoriented(secondsToApply, physicsObject);
        }
        return acting;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public double getEnginePower(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject) {
        return this.enginePower;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        IBlockState state = this.func_176203_a(meta);
        return new TileEntityPropellerEngine(new Vector((EnumFacing)state.func_177229_b((IProperty)FACING)), true, this.enginePower);
    }

    public void setEnginePower(double power) {
        this.enginePower = power;
    }

    @Override
    public boolean doesForceSpawnParticles() {
        return true;
    }
}

