/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.engine;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.block.engine.BlockAirshipEngine;
import org.valkyrienskies.addon.control.tileentity.TileEntityPropellerEngine;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public abstract class BlockAirshipEngineLore
extends BlockAirshipEngine {
    private String[] lore;

    public BlockAirshipEngineLore(Material materialIn, double enginePower) {
        super(materialIn, enginePower);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        Collections.addAll(itemInformation, this.lore);
    }

    public abstract String getEnginePowerTooltip();

    @Override
    public void setEnginePower(double power) {
        super.setEnginePower(power);
        this.lore = new String[]{"" + TextFormatting.GRAY + TextFormatting.ITALIC + TextFormatting.BOLD + "Force:", "  " + this.getEnginePowerTooltip() + " Newtons"};
    }

    @Override
    public boolean shouldLocalForceBeRotated(World world, BlockPos pos, IBlockState state, double secondsToApply) {
        return true;
    }

    @Override
    public Vector getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        TileEntityPropellerEngine engineTile = (TileEntityPropellerEngine)world.func_175625_s(pos);
        if (engineTile != null) {
            VectorImmutable forceOutputNormal = engineTile.getForceOutputNormal(secondsToApply, physicsObject);
            return new Vector((double)pos.func_177958_n() + 0.5 - forceOutputNormal.getX() * 0.75, (double)pos.func_177956_o() + 0.5 - forceOutputNormal.getY() * 0.75, (double)pos.func_177952_p() + 0.5 - forceOutputNormal.getZ() * 0.75);
        }
        return null;
    }
}

