/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityGiantPropellerPart;

public class GiantPropellerMultiblockSchematic
implements IMultiblockSchematic {
    private final List<BlockPosBlockPair> structureRelativeToCenter = new ArrayList<BlockPosBlockPair>();
    private String schematicID = "unknown";
    private int propellerRadius;
    private EnumFacing propellerFacing = EnumFacing.NORTH;

    @Override
    public void initializeMultiblockSchematic(String schematicID) {
        Block enginePart = ValkyrienSkiesControl.INSTANCE.vsControlBlocks.giantPropellerPart;
        Vec3i perpAxisOne = null;
        Vec3i perpAxisTwo = null;
        switch (this.propellerFacing.func_176740_k()) {
            case X: {
                perpAxisOne = new Vec3i(0, 1, 0);
                perpAxisTwo = new Vec3i(0, 0, 1);
                break;
            }
            case Y: {
                perpAxisOne = new Vec3i(1, 0, 0);
                perpAxisTwo = new Vec3i(0, 0, 1);
                break;
            }
            case Z: {
                perpAxisOne = new Vec3i(1, 0, 0);
                perpAxisTwo = new Vec3i(0, 1, 0);
            }
        }
        for (int x = -this.propellerRadius; x <= this.propellerRadius; ++x) {
            for (int y = -this.propellerRadius; y <= this.propellerRadius; ++y) {
                int relativeX = perpAxisOne.func_177958_n() * x + perpAxisTwo.func_177958_n() * y;
                int relativeY = perpAxisOne.func_177956_o() * x + perpAxisTwo.func_177956_o() * y;
                int relativeZ = perpAxisOne.func_177952_p() * x + perpAxisTwo.func_177952_p() * y;
                this.structureRelativeToCenter.add(new BlockPosBlockPair(new BlockPos(relativeX, relativeY, relativeZ), enginePart));
            }
        }
        this.schematicID = schematicID;
    }

    @Override
    public List<BlockPosBlockPair> getStructureRelativeToCenter() {
        return this.structureRelativeToCenter;
    }

    @Override
    public String getSchematicPrefix() {
        return "multiblock_giant_propeller";
    }

    @Override
    public String getSchematicID() {
        return this.schematicID;
    }

    @Override
    public void applyMultiblockCreation(World world, BlockPos tilePos, BlockPos relativePos) {
        TileEntity tileEntity = world.func_175625_s(tilePos);
        if (!(tileEntity instanceof TileEntityGiantPropellerPart)) {
            throw new IllegalStateException();
        }
        TileEntityGiantPropellerPart enginePart = (TileEntityGiantPropellerPart)tileEntity;
        enginePart.assembleMultiblock(this, relativePos);
    }

    @Override
    public List<IMultiblockSchematic> generateAllVariants() {
        ArrayList<IMultiblockSchematic> variants = new ArrayList<IMultiblockSchematic>();
        for (EnumFacing variantPropellerFacing : EnumFacing.values()) {
            for (int radius = 3; radius >= 1; --radius) {
                GiantPropellerMultiblockSchematic variant = new GiantPropellerMultiblockSchematic();
                variant.propellerRadius = radius;
                variant.propellerFacing = variantPropellerFacing;
                variant.initializeMultiblockSchematic(this.getSchematicPrefix() + ":facing:" + variantPropellerFacing.toString() + ":radius:" + radius);
                variants.add(variant);
            }
        }
        return variants;
    }

    public EnumFacing getPropellerFacing() {
        return this.propellerFacing;
    }

    public int getPropellerRadius() {
        return this.propellerRadius;
    }
}

