/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.RudderAxleMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPartForce;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class TileEntityRudderPart
extends TileEntityMultiblockPartForce<RudderAxleMultiblockSchematic, TileEntityRudderPart> {
    private double rudderAngle = 0.0;
    private double prevRudderAngle = 0.0;
    private double nextRudderAngle = 0.0;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevRudderAngle = this.rudderAngle;
        if (this.func_145831_w().field_72995_K) {
            this.rudderAngle += 0.5 * (this.nextRudderAngle - this.rudderAngle);
        }
    }

    public Vector getForcePositionInShipSpace() {
        Vector facingOffset = this.getForcePosRelativeToAxleInShipSpace();
        if (facingOffset != null) {
            return new Vector(facingOffset.X + (double)this.field_174879_c.func_177958_n() + 0.5, facingOffset.Y + (double)this.field_174879_c.func_177956_o() + 0.5, facingOffset.Z + (double)this.field_174879_c.func_177952_p() + 0.5);
        }
        return null;
    }

    private Vector getForcePosRelativeToAxleInShipSpace() {
        if (this.getRudderAxleSchematic().isPresent()) {
            Vec3i directionFacing = this.getRudderAxleFacingDirection().get().func_176730_m();
            Vec3i directionAxle = this.getRudderAxleAxisDirection().get().func_176730_m();
            Vector facingOffset = new Vector(directionFacing.func_177958_n(), directionFacing.func_177956_o(), directionFacing.func_177952_p());
            double axleLength = this.getRudderAxleLength().get().intValue();
            facingOffset.multiply(axleLength / 2.0);
            double[] rotationMatrix = RotationMatrices.getRotationMatrix(directionAxle.func_177958_n(), directionAxle.func_177956_o(), directionAxle.func_177952_p(), Math.toRadians(this.rudderAngle));
            RotationMatrices.applyTransform(rotationMatrix, facingOffset);
            return facingOffset;
        }
        return null;
    }

    public Vector calculateForceFromVelocity(PhysicsObject physicsObject) {
        if (this.getRudderAxleSchematic().isPresent()) {
            Vector directionFacing = this.getForcePosRelativeToAxleInShipSpace();
            Vector forcePosRelativeToShipCenter = this.getForcePositionInShipSpace();
            forcePosRelativeToShipCenter.subtract(physicsObject.getPhysicsProcessor().gameTickCenterOfMass);
            physicsObject.getShipTransformationManager().getCurrentPhysicsTransform().rotate(forcePosRelativeToShipCenter, TransformType.SUBSPACE_TO_GLOBAL);
            Vector velocity = physicsObject.getPhysicsProcessor().getVelocityAtPoint(forcePosRelativeToShipCenter);
            physicsObject.getShipTransformationManager().getCurrentPhysicsTransform().rotate(velocity, TransformType.GLOBAL_TO_SUBSPACE);
            Vec3i directionAxle = this.getRudderAxleAxisDirection().get().func_176730_m();
            Vector directionAxleVector = new Vector(directionAxle);
            Vector surfaceNormal = directionAxleVector.cross(new Vector(directionFacing));
            surfaceNormal.normalize();
            double dragMagnitude = surfaceNormal.dot(velocity);
            Vector dragForceClockwise = new Vector(surfaceNormal, -dragMagnitude);
            dragForceClockwise.multiply(100000.0);
            return dragForceClockwise;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rudderAngle = compound.func_74769_h("rudderAngle");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        toReturn.func_74780_a("rudderAngle", this.rudderAngle);
        return toReturn;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        double currentRudderAngle = this.rudderAngle;
        super.onDataPacket(net, pkt);
        this.nextRudderAngle = pkt.func_148857_g().func_74769_h("rudderAngle");
        this.rudderAngle = currentRudderAngle;
    }

    @Override
    public Vector getForceOutputUnoriented(double secondsToApply, PhysicsObject physicsObject) {
        return null;
    }

    @Override
    public VectorImmutable getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return null;
    }

    @Override
    public double getThrustMagnitude() {
        return 0.0;
    }

    public Optional<EnumFacing> getRudderAxleAxisDirection() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleAxisDirection());
        }
        return Optional.empty();
    }

    public Optional<EnumFacing> getRudderAxleFacingDirection() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleFacingDirection());
        }
        return Optional.empty();
    }

    public Optional<Integer> getRudderAxleLength() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleLength());
        }
        return Optional.empty();
    }

    private Optional<RudderAxleMultiblockSchematic> getRudderAxleSchematic() {
        if (this.isPartOfAssembledMultiblock()) {
            return Optional.of(this.getMultiBlockSchematic());
        }
        return Optional.empty();
    }

    public double getRudderAngle() {
        return this.rudderAngle;
    }

    public void setRudderAngle(double forcedValue) {
        this.rudderAngle = forcedValue;
        VSNetwork.sendTileToAllNearby(this);
    }

    public double getRenderRudderAngle(double partialTicks) {
        return this.prevRudderAngle + (this.rudderAngle - this.prevRudderAngle) * partialTicks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isPartOfAssembledMultiblock() && this.isMaster() && this.getRudderAxleAxisDirection().isPresent()) {
            BlockPos minPos = this.field_174879_c;
            EnumFacing axleAxis = this.getRudderAxleAxisDirection().get();
            EnumFacing axleFacing = this.getRudderAxleFacingDirection().get();
            Vec3i otherAxis = axleAxis.func_176730_m().func_177955_d(axleFacing.func_176730_m());
            int nexAxisX = axleAxis.func_176730_m().func_177958_n() + axleFacing.func_176730_m().func_177958_n();
            int nexAxisY = axleAxis.func_176730_m().func_177956_o() + axleFacing.func_176730_m().func_177956_o();
            int nexAxisZ = axleAxis.func_176730_m().func_177952_p() + axleFacing.func_176730_m().func_177952_p();
            int axleLength = this.getRudderAxleLength().get();
            int offsetX = nexAxisX * axleLength;
            int offsetY = nexAxisY * axleLength;
            int offsetZ = nexAxisZ * axleLength;
            BlockPos maxPos = minPos.func_177982_a(offsetX, offsetY, offsetZ);
            int otherAxisXExpanded = otherAxis.func_177958_n() * axleLength;
            int otherAxisYExpanded = otherAxis.func_177956_o() * axleLength;
            int otherAxisZExpanded = otherAxis.func_177952_p() * axleLength;
            return new AxisAlignedBB(minPos, maxPos).func_72314_b((double)otherAxisXExpanded, (double)otherAxisYExpanded, (double)otherAxisZExpanded).func_72314_b(0.5, 0.5, 0.5);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> schematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_rudder_axle");
        for (IMultiblockSchematic schematic : schematics) {
            RudderAxleMultiblockSchematic rudderSchem = (RudderAxleMultiblockSchematic)schematic;
            if (facing.func_176740_k() == rudderSchem.getAxleAxisDirection().func_176740_k() || rudderSchem.getAxleFacingDirection() != facing || !schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }
}

