/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPartForce;
import org.valkyrienskies.addon.control.block.multiblocks.ValkyriumCompressorMultiblockSchematic;
import org.valkyrienskies.addon.control.fuel.IValkyriumEngine;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class TileEntityValkyriumCompressorPart
extends TileEntityMultiblockPartForce<ValkyriumCompressorMultiblockSchematic, TileEntityValkyriumCompressorPart>
implements IValkyriumEngine {
    private static final VectorImmutable FORCE_NORMAL = new VectorImmutable(0.0, 1.0, 0.0);
    private double prevKeyframe;
    private double currentKeyframe;

    public TileEntityValkyriumCompressorPart() {
    }

    public TileEntityValkyriumCompressorPart(double maxThrust) {
        this();
        this.setMaxThrust(maxThrust);
        this.prevKeyframe = 0.0;
        this.currentKeyframe = 0.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevKeyframe = this.currentKeyframe;
        this.currentKeyframe += 1.2;
        this.currentKeyframe %= 99.0;
    }

    @Override
    public VectorImmutable getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return FORCE_NORMAL;
    }

    @Override
    public void setThrustMultiplierGoal(double thrustMultiplierGoal) {
        if (this.isMaster() || this.getMaster() == this) {
            super.setThrustMultiplierGoal(thrustMultiplierGoal);
        } else {
            ((TileEntityValkyriumCompressorPart)this.getMaster()).setThrustMultiplierGoal(thrustMultiplierGoal);
        }
    }

    @Override
    public double getThrustMagnitude() {
        if (this.isPartOfAssembledMultiblock() && this.getMaster() instanceof TileEntityValkyriumCompressorPart) {
            return this.getMaxThrust() * ((TileEntityValkyriumCompressorPart)this.getMaster()).getThrustMultiplierGoal() * this.getCurrentValkyriumEfficiency();
        }
        return 0.0;
    }

    @Override
    public double getCurrentValkyriumEfficiency() {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.field_145850_b, this.field_174879_c);
        if (physicsObject.isPresent()) {
            Vector tilePos = new Vector((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            physicsObject.get().getShipTransformationManager().getCurrentPhysicsTransform().transform(tilePos, TransformType.SUBSPACE_TO_GLOBAL);
            double yPos = tilePos.Y;
            return IValkyriumEngine.getValkyriumEfficiencyFromHeight(yPos);
        }
        return 1.0;
    }

    public double getCurrentKeyframe(double partialTick) {
        double increment = this.currentKeyframe - this.prevKeyframe;
        if (increment < 0.0) {
            increment = increment % 99.0 + 99.0;
        }
        return this.prevKeyframe + increment * partialTick + 1.0;
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> valkyriumEngineMultiblockSchematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_valkyrium_compressor");
        for (IMultiblockSchematic schematic : valkyriumEngineMultiblockSchematics) {
            if (!schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }
}

