/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPart;
import org.valkyrienskies.addon.control.block.multiblocks.ValkyriumEngineMultiblockSchematic;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeProvider;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorldProvider;
import org.valkyrienskies.addon.control.block.torque.ImplRotationNode;
import org.valkyrienskies.addon.control.block.torque.custom_torque_functions.ValkyriumEngineTorqueFunction;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.common.math.VSMath;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class TileEntityValkyriumEnginePart
extends TileEntityMultiblockPart<ValkyriumEngineMultiblockSchematic, TileEntityValkyriumEnginePart>
implements IRotationNodeProvider<TileEntityValkyriumEnginePart> {
    private static final int ROTATION_NODE_SORT_PRIORITY = 10000;
    protected final IRotationNode rotationNode = new ImplRotationNode<TileEntityValkyriumEnginePart>(this, 50.0, 10000);
    private double prevKeyframe = 0.0;
    private double currentKeyframe = 0.0;
    private double nextKeyframe;
    private boolean firstUpdate = true;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.firstUpdate) {
                this.rotationNode.markInitialized();
                this.firstUpdate = false;
            }
            if (this.isPartOfAssembledMultiblock()) {
                IRotationNodeWorld nodeWorld;
                Optional<PhysicsObject> physicsObjectOptional = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
                if (physicsObjectOptional.isPresent()) {
                    nodeWorld = physicsObjectOptional.get().getPhysicsProcessor().getPhysicsRotationNodeWorld();
                } else {
                    IRotationNodeWorldProvider provider = (IRotationNodeWorldProvider)this.func_145831_w();
                    nodeWorld = provider.getPhysicsRotationNodeWorld();
                }
                if (physicsObjectOptional.isPresent() && !this.rotationNode.hasBeenPlacedIntoNodeWorld() && this.getRelativePos().equals((Object)((ValkyriumEngineMultiblockSchematic)this.getMultiBlockSchematic()).getTorqueOutputPos())) {
                    nodeWorld.enqueueTaskOntoWorld(() -> nodeWorld.setNodeFromPos(this.func_174877_v(), this.rotationNode));
                }
                BlockPos torqueOutputPos = ((ValkyriumEngineMultiblockSchematic)this.getMultiBlockSchematic()).getTorqueOutputPos().func_177971_a((Vec3i)this.func_174877_v());
                TileEntity tileEntity = this.func_145831_w().func_175625_s(torqueOutputPos);
                if (tileEntity instanceof TileEntityValkyriumEnginePart && ((TileEntityValkyriumEnginePart)tileEntity).getRotationNode().isPresent()) {
                    this.prevKeyframe = this.currentKeyframe;
                    double radiansRotatedThisTick = ((TileEntityValkyriumEnginePart)tileEntity).getRotationNode().get().getAngularVelocityUnsynchronized() / 20.0;
                    this.currentKeyframe += radiansRotatedThisTick * 99.0 / (Math.PI * 6);
                    this.currentKeyframe %= 99.0;
                }
                VSNetwork.sendTileToAllNearby(this);
            }
            this.func_70296_d();
        } else {
            this.prevKeyframe = this.currentKeyframe;
            this.currentKeyframe = VSMath.interpolateModulatedNumbers(this.currentKeyframe, this.nextKeyframe, 0.85, 99.0);
        }
    }

    public double getCurrentKeyframe(double partialTick) {
        return VSMath.interpolateModulatedNumbers(this.prevKeyframe, this.currentKeyframe, partialTick, 99.0);
    }

    @Override
    public void assembleMultiblock(ValkyriumEngineMultiblockSchematic schematic, BlockPos relativePos) {
        super.assembleMultiblock(schematic, relativePos);
        if (relativePos.equals((Object)schematic.getTorqueOutputPos())) {
            IRotationNodeWorld nodeWorld;
            Optional<PhysicsObject> objectOptional = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
            if (objectOptional.isPresent()) {
                nodeWorld = objectOptional.get().getPhysicsProcessor().getPhysicsRotationNodeWorld();
            } else {
                IRotationNodeWorldProvider provider = (IRotationNodeWorldProvider)this.func_145831_w();
                nodeWorld = provider.getPhysicsRotationNodeWorld();
            }
            EnumFacing facing = EnumFacing.func_176737_a((float)schematic.getTorqueOutputDirection().func_177958_n(), (float)schematic.getTorqueOutputDirection().func_177956_o(), (float)schematic.getTorqueOutputDirection().func_177952_p());
            assert (this.getRotationNode().isPresent()) : "How the heck did we try assembling the multiblock without a rotation node initialized!";
            this.rotationNode.queueTask(() -> {
                this.rotationNode.setAngularVelocityRatio(facing, Optional.of(-1.0));
                this.rotationNode.setCustomTorqueFunction(new ValkyriumEngineTorqueFunction(this.rotationNode));
            });
            nodeWorld.enqueueTaskOntoWorld(() -> nodeWorld.setNodeFromPos(this.field_174879_c, this.rotationNode));
        }
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> schematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_valkyrium_engine");
        for (IMultiblockSchematic schematic : schematics) {
            if (!schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disassembleMultiblockLocal() {
        super.disassembleMultiblockLocal();
        Optional<PhysicsObject> object = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
        if (object.isPresent()) {
            this.rotationNode.queueTask(this.rotationNode::resetNodeData);
        }
    }

    @Override
    public Optional<IRotationNode> getRotationNode() {
        if (this.rotationNode.isInitialized()) {
            return Optional.of(this.rotationNode);
        }
        return Optional.empty();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.func_145831_w() == null || !this.func_145831_w().field_72995_K) {
            this.rotationNode.readFromNBT(compound);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.rotationNode.writeToNBT(compound);
        return compound;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = super.func_189517_E_();
        tagToSend.func_74780_a("currentKeyframe", this.currentKeyframe);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.nextKeyframe = pkt.func_148857_g().func_74769_h("currentKeyframe");
    }
}

