/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.EnumMultiblockRotation;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityValkyriumEnginePart;

public class ValkyriumEngineMultiblockSchematic
implements IMultiblockSchematic {
    private final List<BlockPosBlockPair> structureRelativeToCenter = new ArrayList<BlockPosBlockPair>();
    private String schematicID = "unknown";
    private EnumMultiblockRotation multiblockRotation = EnumMultiblockRotation.NONE;
    private BlockPos torqueOutputPos;
    private Vec3i torqueOutputDirection;

    @Override
    public void initializeMultiblockSchematic(String schematicID) {
        Block enginePart = ValkyrienSkiesControl.INSTANCE.vsControlBlocks.valkyriumEnginePart;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 0; ++z) {
                    this.structureRelativeToCenter.add(new BlockPosBlockPair(new BlockPos(x, y, z), enginePart));
                }
            }
        }
        this.torqueOutputPos = new BlockPos(1, 0, -1);
        this.torqueOutputDirection = new BlockPos(1, 0, 0);
        this.schematicID = schematicID;
    }

    @Override
    public List<BlockPosBlockPair> getStructureRelativeToCenter() {
        return this.structureRelativeToCenter;
    }

    @Override
    public String getSchematicID() {
        return this.schematicID;
    }

    @Override
    public void applyMultiblockCreation(World world, BlockPos tilePos, BlockPos relativePos) {
        TileEntity tileEntity = world.func_175625_s(tilePos);
        if (!(tileEntity instanceof TileEntityValkyriumEnginePart)) {
            throw new IllegalStateException();
        }
        TileEntityValkyriumEnginePart enginePart = (TileEntityValkyriumEnginePart)tileEntity;
        enginePart.assembleMultiblock(this, relativePos);
    }

    @Override
    public String getSchematicPrefix() {
        return "multiblock_valkyrium_engine";
    }

    @Override
    public List<IMultiblockSchematic> generateAllVariants() {
        ArrayList<IMultiblockSchematic> variants = new ArrayList<IMultiblockSchematic>();
        for (EnumMultiblockRotation potentialRotation : EnumMultiblockRotation.values()) {
            ValkyriumEngineMultiblockSchematic variant = new ValkyriumEngineMultiblockSchematic();
            variant.initializeMultiblockSchematic(this.getSchematicPrefix() + ":rot:" + potentialRotation.toString());
            ArrayList<BlockPosBlockPair> rotatedPairs = new ArrayList<BlockPosBlockPair>();
            for (BlockPosBlockPair unrotatedPairs : variant.structureRelativeToCenter) {
                BlockPos rotatedPos = potentialRotation.rotatePos(unrotatedPairs.getPos());
                rotatedPairs.add(new BlockPosBlockPair(rotatedPos, unrotatedPairs.getBlock()));
            }
            variant.structureRelativeToCenter.clear();
            variant.structureRelativeToCenter.addAll(rotatedPairs);
            variant.multiblockRotation = potentialRotation;
            variant.torqueOutputPos = potentialRotation.rotatePos(variant.torqueOutputPos);
            variant.torqueOutputDirection = potentialRotation.rotatePos((BlockPos)variant.torqueOutputDirection);
            variants.add(variant);
        }
        return variants;
    }

    @Override
    public EnumMultiblockRotation getMultiblockRotation() {
        return this.multiblockRotation;
    }

    public BlockPos getTorqueOutputPos() {
        return this.torqueOutputPos;
    }

    public Vec3i getTorqueOutputDirection() {
        return this.torqueOutputDirection;
    }
}

