/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.torque;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.addon.control.block.torque.PhysicsThreadOnly;
import org.valkyrienskies.addon.control.block.torque.custom_torque_functions.SimpleTorqueFunction;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public interface IRotationNode
extends Comparable<IRotationNode> {
    @PhysicsThreadOnly
    default public double getEnergy() {
        return this.getAngularVelocity() * this.getAngularVelocity() * this.getRotationalInertia() / 2.0;
    }

    @PhysicsThreadOnly
    default public void simulate(double timeStep, PhysicsObject parent) {
        double torque = this.calculateInstantaneousTorque(parent);
        double deltaVelocity = torque / this.getRotationalInertia() * timeStep;
        this.setAngularRotation(this.getAngularRotation() + this.getAngularVelocity() * timeStep + torque / this.getRotationalInertia() * timeStep * timeStep / 2.0);
        this.setAngularVelocity(this.getAngularVelocity() + deltaVelocity);
    }

    @PhysicsThreadOnly
    default public double calculateInstantaneousTorque(PhysicsObject parent) {
        if (!this.getCustomTorqueFunction().isPresent()) {
            return this.getAngularVelocity() * -0.4 * this.getRotationalInertia();
        }
        return this.getCustomTorqueFunction().get().calculateTorque(parent);
    }

    @PhysicsThreadOnly
    public Optional<SimpleTorqueFunction> getCustomTorqueFunction();

    @PhysicsThreadOnly
    public void setCustomTorqueFunction(SimpleTorqueFunction var1);

    @PhysicsThreadOnly
    default public boolean isConnectedToSide(EnumFacing side) {
        Optional<IRotationNode> connectedTo = this.getTileOnSide(side);
        if (!connectedTo.isPresent()) {
            return false;
        }
        return this.getAngularVelocityRatioFor(side).isPresent() && connectedTo.get().getAngularVelocityRatioFor(side.func_176734_d()).isPresent();
    }

    @PhysicsThreadOnly
    public Optional<Double> getAngularVelocityRatioFor(EnumFacing var1);

    @PhysicsThreadOnly
    public Optional<IRotationNode> getTileOnSide(EnumFacing var1);

    public double getAngularVelocity();

    @PhysicsThreadOnly
    public void setAngularVelocity(double var1);

    public double getAngularRotation();

    @PhysicsThreadOnly
    public void setAngularRotation(double var1);

    public double getAngularRotationUnsynchronized();

    public double getAngularVelocityUnsynchronized();

    public double getRotationalInertia();

    @PhysicsThreadOnly
    public void setRotationalInertia(double var1);

    public void markInitialized();

    public boolean isInitialized();

    @PhysicsThreadOnly
    public void setAngularVelocityRatio(EnumFacing var1, Optional<Double> var2);

    @PhysicsThreadOnly
    public void resetNodeData();

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public int getSortingPriority();

    @PhysicsThreadOnly
    public void setSortingPriority(int var1);

    @Override
    default public int compareTo(IRotationNode o2) {
        return this.getSortingPriority() - o2.getSortingPriority();
    }

    @PhysicsThreadOnly
    default public List<Tuple<IRotationNode, EnumFacing>> connectedTorqueTilesList() {
        ArrayList<Tuple<IRotationNode, EnumFacing>> connectedTiles = new ArrayList<Tuple<IRotationNode, EnumFacing>>();
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.isConnectedToSide(facing)) continue;
            Optional<IRotationNode> tileOnSide = this.getTileOnSide(facing);
            if (!tileOnSide.isPresent()) {
                throw new IllegalStateException("I thought this was impossible!");
            }
            connectedTiles.add((Tuple<IRotationNode, EnumFacing>)new Tuple((Object)tileOnSide.get(), (Object)facing));
        }
        return connectedTiles;
    }

    public Optional<BlockPos> getNodePos();

    public void queueTask(Runnable var1);

    public ConcurrentLinkedQueue<Runnable> getQueuedTasks();

    public void queueNodeForDeletion();

    public boolean markedForDeletion();

    public boolean hasBeenPlacedIntoNodeWorld();

    public void setPlacedIntoNodeWorld(boolean var1);

    public Optional<Double>[] connectedRotationRatiosUnsychronized();

    default public boolean isConnectedToSideUnsynchronized(EnumFacing side) {
        Optional<IRotationNode> connectedTo = this.getTileOnSideUnsynchronized(side);
        if (!connectedTo.isPresent()) {
            return false;
        }
        return this.getAngularVelocityRatioForUnsynchronized(side).isPresent() && connectedTo.get().getAngularVelocityRatioForUnsynchronized(side.func_176734_d()).isPresent();
    }

    public Optional<IRotationNode> getTileOnSideUnsynchronized(EnumFacing var1);

    public Optional<Double> getAngularVelocityRatioForUnsynchronized(EnumFacing var1);
}

