/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.torque;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.PhysicsAssert;
import org.valkyrienskies.addon.control.block.torque.PhysicsThreadOnly;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public class ImplRotationNodeWorld
implements IRotationNodeWorld {
    @Nullable
    private final PhysicsObject parent;
    @Nonnull
    private final Map<BlockPos, IRotationNode> posToNodeMap;
    @Nonnull
    private final ConcurrentLinkedQueue<Runnable> queuedTasks;

    public ImplRotationNodeWorld(@Nullable PhysicsObject parent) {
        this.parent = parent;
        this.posToNodeMap = new HashMap<BlockPos, IRotationNode>();
        this.queuedTasks = new ConcurrentLinkedQueue();
    }

    @Override
    public void enqueueTaskOntoWorld(Runnable task) {
        this.queuedTasks.add(task);
    }

    @Override
    public void enqueueTaskOntoNode(Consumer<IRotationNode> task, BlockPos taskPos) {
        this.queuedTasks.add(() -> {
            IRotationNode nodeAtPos = this.getNodeFromPos(taskPos);
            if (nodeAtPos != null) {
                task.accept(nodeAtPos);
            }
        });
    }

    @Override
    @PhysicsThreadOnly
    public void processQueuedTasks() {
        PhysicsAssert.assertPhysicsThread();
        while (!this.queuedTasks.isEmpty()) {
            Runnable queuedTask = (Runnable)this.queuedTasks.remove();
            queuedTask.run();
        }
        for (IRotationNode node : this.posToNodeMap.values()) {
            while (!node.getQueuedTasks().isEmpty()) {
                ((Runnable)node.getQueuedTasks().remove()).run();
            }
        }
    }

    @Override
    @PhysicsThreadOnly
    public void processTorquePhysics(double timeDelta) {
        PhysicsAssert.assertPhysicsThread();
        this.posToNodeMap.entrySet().removeIf(entry -> ((IRotationNode)entry.getValue()).markedForDeletion());
        this.processQueuedTasks();
        ArrayList<IRotationNode> nodesToVisit = new ArrayList<IRotationNode>(this.posToNodeMap.values());
        Collections.shuffle(nodesToVisit);
        while (nodesToVisit.size() > 0) {
            IRotationNode startNode = (IRotationNode)nodesToVisit.get(0);
            HashSet<IRotationNode> visitedNodes = new HashSet<IRotationNode>();
            double apparentTorque = this.calculateApparentTorque(startNode, visitedNodes);
            visitedNodes.clear();
            double apparentInertia = this.calculateApparentInertia(startNode, visitedNodes);
            visitedNodes.clear();
            double apparentOmega = this.calculateApparentOmega(startNode, visitedNodes);
            visitedNodes.clear();
            double gearTrainEnergy = this.calculateTotalEnergy(startNode, visitedNodes);
            visitedNodes.clear();
            double apparentAngularAcceleration = apparentTorque / apparentInertia;
            double deltaOmega = apparentAngularAcceleration * timeDelta;
            double omegaGuess = Math.sqrt(2.0 * gearTrainEnergy / apparentInertia);
            double newOmega = (omegaGuess *= Math.signum(apparentOmega)) + deltaOmega;
            if (!Double.isNaN(newOmega)) {
                this.applyNewOmega(startNode, newOmega, timeDelta, visitedNodes);
            } else {
                System.err.println("Gear Train Simulation Error, Resetting Rotation Nodes.\nOmega guess is " + omegaGuess + "\nDelta omega is " + deltaOmega);
                this.resetGearTrain(startNode, visitedNodes);
            }
            nodesToVisit.removeAll(visitedNodes);
        }
    }

    private void resetGearTrain(IRotationNode start, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        start.setAngularRotation(0.0);
        start.setAngularVelocity(0.0);
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            this.resetGearTrain(endNode, visitedNodes);
        }
    }

    private void applyNewOmega(IRotationNode start, double newOmega, double deltaTime, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        start.setAngularRotation(start.getAngularRotation() + start.getAngularVelocity() * deltaTime + (newOmega - start.getAngularVelocity()) * deltaTime / 2.0);
        start.setAngularVelocity(newOmega);
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            EnumFacing exploreDirection = (EnumFacing)connectedNode.func_76340_b();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            double ratioStart = start.getAngularVelocityRatioFor(exploreDirection).get();
            double ratioEnd = endNode.getAngularVelocityRatioFor(exploreDirection.func_176734_d()).get();
            double multiplier = -ratioStart / ratioEnd;
            this.applyNewOmega(endNode, newOmega * multiplier, deltaTime, visitedNodes);
        }
    }

    private double calculateTotalEnergy(IRotationNode start, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        double totalEnergy = start.getEnergy();
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            EnumFacing exploreDirection = (EnumFacing)connectedNode.func_76340_b();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            totalEnergy += this.calculateTotalEnergy(endNode, visitedNodes);
        }
        return totalEnergy;
    }

    private double calculateApparentInertia(IRotationNode start, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        double apparentInertia = start.getRotationalInertia();
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            EnumFacing exploreDirection = (EnumFacing)connectedNode.func_76340_b();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            double ratioStart = start.getAngularVelocityRatioFor(exploreDirection).get();
            double ratioEnd = endNode.getAngularVelocityRatioFor(exploreDirection.func_176734_d()).get();
            double multiplier = -ratioStart / ratioEnd;
            apparentInertia += multiplier * multiplier * this.calculateApparentInertia(endNode, visitedNodes);
        }
        return apparentInertia;
    }

    private double calculateApparentOmega(IRotationNode start, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        double apparentOmega = start.getAngularVelocity();
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            EnumFacing exploreDirection = (EnumFacing)connectedNode.func_76340_b();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            double ratioStart = start.getAngularVelocityRatioFor(exploreDirection).get();
            double ratioEnd = endNode.getAngularVelocityRatioFor(exploreDirection.func_176734_d()).get();
            double multiplier = -ratioStart / ratioEnd;
            apparentOmega += multiplier * this.calculateApparentOmega(endNode, visitedNodes);
        }
        return apparentOmega;
    }

    private double calculateApparentTorque(IRotationNode start, Set<IRotationNode> visitedNodes) {
        visitedNodes.add(start);
        double apparentTorque = start.calculateInstantaneousTorque(this.parent);
        for (Tuple<IRotationNode, EnumFacing> connectedNode : start.connectedTorqueTilesList()) {
            IRotationNode endNode = (IRotationNode)connectedNode.func_76341_a();
            EnumFacing exploreDirection = (EnumFacing)connectedNode.func_76340_b();
            if (visitedNodes.contains(connectedNode.func_76341_a())) continue;
            double ratioStart = start.getAngularVelocityRatioFor(exploreDirection).get();
            double ratioEnd = endNode.getAngularVelocityRatioFor(exploreDirection.func_176734_d()).get();
            double multiplier = -ratioStart / ratioEnd;
            apparentTorque += multiplier * this.calculateApparentTorque(endNode, visitedNodes);
        }
        return apparentTorque;
    }

    @Override
    @PhysicsThreadOnly
    public IRotationNode getNodeFromPos(BlockPos pos) {
        PhysicsAssert.assertPhysicsThread();
        IRotationNode nodeAtPos = this.posToNodeMap.get(pos);
        assert (nodeAtPos == null || nodeAtPos.isInitialized()) : "NodeAtPos " + nodeAtPos + " was not initialized!";
        return nodeAtPos;
    }

    @Override
    @PhysicsThreadOnly
    public boolean hasNodeAtPos(BlockPos pos) {
        PhysicsAssert.assertPhysicsThread();
        return this.posToNodeMap.containsKey(pos);
    }

    @Override
    @PhysicsThreadOnly
    public IRotationNode setNodeFromPos(BlockPos pos, IRotationNode node) {
        PhysicsAssert.assertPhysicsThread();
        assert (node == null || node.isInitialized()) : "NodeAtPos " + pos + " was not initialized!";
        node.setPlacedIntoNodeWorld(true);
        return this.posToNodeMap.put(pos, node);
    }

    @Override
    @PhysicsThreadOnly
    public IRotationNode removePos(BlockPos pos) {
        PhysicsAssert.assertPhysicsThread();
        return this.posToNodeMap.remove(pos);
    }

    @Override
    public void readFromNBTTag(NBTTagCompound compound) {
    }

    @Override
    public void writeToNBTTag(NBTTagCompound compound) {
    }
}

