/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.torque;

import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeProvider;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorldProvider;
import org.valkyrienskies.addon.control.block.torque.ImplRotationNode;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class TileEntityBasicRotationNodeTile
extends BasicNodeTileEntity
implements IRotationNodeProvider,
ITickable {
    protected final IRotationNode rotationNode = new ImplRotationNode<TileEntityBasicRotationNodeTile>(this, 0.1);
    protected double rotation = 0.0;
    protected double lastRotation = 0.0;
    protected double nextRotation = 0.0;
    private boolean firstUpdate = true;

    public TileEntityBasicRotationNodeTile() {
    }

    public TileEntityBasicRotationNodeTile(int sortingPriority) {
        this();
        this.rotationNode.setSortingPriority(sortingPriority);
    }

    @Override
    public Optional<IRotationNode> getRotationNode() {
        if (this.rotationNode.isInitialized()) {
            return Optional.of(this.rotationNode);
        }
        return Optional.empty();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotationNode.readFromNBT(compound);
        this.rotation = this.nextRotation = this.rotationNode.getAngularRotationUnsynchronized();
        this.lastRotation = this.nextRotation;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.rotationNode.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.lastRotation = this.rotation;
            this.rotation += (this.nextRotation - this.rotation) * 0.85;
        } else {
            if (this.firstUpdate || !this.rotationNode.isInitialized()) {
                IRotationNodeWorld nodeWorld;
                Optional<PhysicsObject> physicsObjectOptional = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
                if (physicsObjectOptional.isPresent()) {
                    nodeWorld = physicsObjectOptional.get().getPhysicsProcessor().getPhysicsRotationNodeWorld();
                } else {
                    IRotationNodeWorldProvider provider = (IRotationNodeWorldProvider)this.func_145831_w();
                    nodeWorld = provider.getPhysicsRotationNodeWorld();
                }
                this.rotationNode.markInitialized();
                nodeWorld.enqueueTaskOntoWorld(() -> nodeWorld.setNodeFromPos(this.func_174877_v(), this.rotationNode));
                this.firstUpdate = false;
            }
            this.rotation = this.rotationNode.getAngularRotationUnsynchronized();
            VSNetwork.sendTileToAllNearby(this);
            this.func_70296_d();
        }
    }

    public final double getRenderRotationRadians(float partialTick) {
        return this.lastRotation + (this.rotation - this.lastRotation) * (double)partialTick;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = new NBTTagCompound();
        tagToSend.func_74780_a("rotation", this.rotation);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextRotation = pkt.func_148857_g().func_74769_h("rotation");
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.rotationNode.queueNodeForDeletion();
    }
}

