/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.capability.ICapabilityLastRelay;
import org.valkyrienskies.addon.control.nodenetwork.IVSNode;
import org.valkyrienskies.addon.control.nodenetwork.IVSNodeProvider;
import org.valkyrienskies.mod.common.config.VSConfig;

public class ItemRelayWire
extends Item {
    public ItemRelayWire() {
        this.func_77656_e(80);
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        itemInformation.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.relay_wire", (Object[])new Object[0]));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ICapabilityLastRelay inst;
        IBlockState clickedState = worldIn.func_180495_p(pos);
        Block block = clickedState.func_177230_c();
        TileEntity currentTile = worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (currentTile instanceof IVSNodeProvider && !worldIn.field_72995_K && (inst = (ICapabilityLastRelay)stack.getCapability(ValkyrienSkiesControl.lastRelayCapability, null)) != null) {
            if (!inst.hasLastRelay()) {
                inst.setLastRelay(pos);
            } else {
                BlockPos lastPos = inst.getLastRelay();
                double distanceSq = lastPos.func_177951_i((Vec3i)pos);
                TileEntity lastPosTile = worldIn.func_175625_s(lastPos);
                if (!lastPos.equals((Object)pos) && lastPosTile != null && currentTile != null) {
                    if (distanceSq < VSConfig.relayWireLength * VSConfig.relayWireLength) {
                        IVSNode lastPosNode = ((IVSNodeProvider)lastPosTile).getNode();
                        IVSNode currentPosNode = ((IVSNodeProvider)currentTile).getNode();
                        if (lastPosNode != null && currentPosNode != null) {
                            if (currentPosNode.isLinkedToNode(lastPosNode)) {
                                player.func_145747_a((ITextComponent)new TextComponentString("These nodes are already linked!"));
                            } else if (currentPosNode.canLinkToOtherNode(lastPosNode)) {
                                currentPosNode.makeConnection(lastPosNode);
                                stack.func_77972_a(1, (EntityLivingBase)player);
                            } else {
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"message.vs_control.error_relay_wire_limit", (Object[])new Object[]{VSConfig.networkRelayLimit})));
                            }
                            inst.setLastRelay(null);
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + I18n.func_135052_a((String)"message.vs_control.error_relay_wire_length", (Object[])new Object[0])));
                        inst.setLastRelay(null);
                    }
                } else {
                    inst.setLastRelay(pos);
                }
            }
        }
        if (currentTile instanceof IVSNodeProvider) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

