/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.block.multiblocks.ITileEntityMultiblockPart;
import org.valkyrienskies.addon.control.item.EnumWrenchMode;
import org.valkyrienskies.addon.control.tileentity.TileEntityGearbox;
import org.valkyrienskies.mod.common.config.VSConfig;

public class ItemWrench
extends Item {
    private EnumWrenchMode mode = EnumWrenchMode.CONSTRUCT;

    public ItemWrench() {
        this.func_77625_d(1);
        this.func_77656_e(80);
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        if (VSConfig.wrenchModeless) {
            itemInformation.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.wrench_toggle", (Object[])new Object[0]));
        } else {
            itemInformation.add(TextFormatting.BLUE + I18n.func_135052_a((String)("tooltip.vs_control.wrench." + this.mode.toString()), (Object[])new Object[0]));
            itemInformation.add(TextFormatting.GREEN + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.vs_control.wrench_modes", (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean shouldDeconstruct;
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af() && !VSConfig.wrenchModeless) {
            this.mode = EnumWrenchMode.values()[(this.mode.ordinal() + 1) % EnumWrenchMode.values().length];
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.wrench_switched", (Object[])new Object[]{this.mode.toString()})));
            return EnumActionResult.SUCCESS;
        }
        TileEntity blockTile = worldIn.func_175625_s(pos);
        boolean shouldConstruct = this.mode == EnumWrenchMode.CONSTRUCT || VSConfig.wrenchModeless;
        boolean bl = shouldDeconstruct = this.mode == EnumWrenchMode.DECONSTRUCT || VSConfig.wrenchModeless;
        if (blockTile instanceof ITileEntityMultiblockPart) {
            ITileEntityMultiblockPart part = (ITileEntityMultiblockPart)blockTile;
            shouldConstruct = shouldConstruct && !part.isPartOfAssembledMultiblock();
            shouldDeconstruct = shouldDeconstruct && part.isPartOfAssembledMultiblock();
        } else if (blockTile instanceof TileEntityGearbox) {
            shouldConstruct = true;
        } else {
            return EnumActionResult.PASS;
        }
        if (shouldConstruct) {
            if (blockTile instanceof ITileEntityMultiblockPart) {
                if (((ITileEntityMultiblockPart)blockTile).attemptToAssembleMultiblock(worldIn, pos, facing)) {
                    return EnumActionResult.SUCCESS;
                }
            } else if (blockTile instanceof TileEntityGearbox) {
                ((TileEntityGearbox)blockTile).setInputFacing(player.func_70093_af() ? facing.func_176734_d() : facing);
            }
        } else if (shouldDeconstruct) {
            ((ITileEntityMultiblockPart)blockTile).disassembleMultiblock();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumWrenchMode getMode() {
        return this.mode;
    }
}

