/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import net.minecraft.nbt.NBTTagCompound;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.addon.control.nodenetwork.IForceTile;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;

public abstract class BasicForceNodeTileEntity
extends BasicNodeTileEntity
implements IForceTile {
    protected double maxThrust = 5000.0;
    protected double currentThrust = 0.0;
    private double thrusGoalMultiplier = 0.0;
    private Vector forceOutputVector = new Vector();
    private Vector normalVelocityUnoriented;
    private int ticksSinceLastControlSignal = 0;
    private boolean hasAlreadyCheckedForParent = false;

    public BasicForceNodeTileEntity() {
    }

    public BasicForceNodeTileEntity(Vector normalVelocityUnoriented, boolean isForceOutputOriented, double maxThrust) {
        this();
        this.normalVelocityUnoriented = normalVelocityUnoriented;
        this.maxThrust = maxThrust;
    }

    public boolean isForceOutputOriented() {
        return true;
    }

    @Override
    public VectorImmutable getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return this.normalVelocityUnoriented.toImmutable();
    }

    @Override
    public double getMaxThrust() {
        return this.maxThrust;
    }

    @Override
    public void setMaxThrust(double maxThrust) {
        this.maxThrust = maxThrust;
    }

    @Override
    public double getThrustMagnitude() {
        return this.getMaxThrust() * this.getThrustMultiplierGoal();
    }

    @Override
    public double getThrustMultiplierGoal() {
        return this.thrusGoalMultiplier;
    }

    @Override
    public void setThrustMultiplierGoal(double multiplier) {
        this.thrusGoalMultiplier = multiplier;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.maxThrust = compound.func_74769_h("maxThrust");
        this.currentThrust = compound.func_74769_h("currentThrust");
        this.normalVelocityUnoriented = ValkyrienNBTUtils.readVectorFromNBT("normalVelocityUnoriented", compound);
        this.ticksSinceLastControlSignal = compound.func_74762_e("ticksSinceLastControlSignal");
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("maxThrust", this.maxThrust);
        compound.func_74780_a("currentThrust", this.currentThrust);
        ValkyrienNBTUtils.writeVectorToNBT("normalVelocityUnoriented", this.normalVelocityUnoriented, compound);
        compound.func_74768_a("ticksSinceLastControlSignal", this.ticksSinceLastControlSignal);
        return super.func_189515_b(compound);
    }

    public boolean updateParentShip() {
        return true;
    }

    public void updateTicksSinceLastRecievedSignal() {
        this.ticksSinceLastControlSignal = 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticksSinceLastControlSignal;
        if (this.ticksSinceLastControlSignal > 5 && this.getThrustMultiplierGoal() != 0.0) {
            this.setThrustMultiplierGoal(this.getThrustMultiplierGoal() * 0.9);
        }
    }
}

